package com.xforceplus.ultraman.oqsengine.plus.common.iterator.searchafter;

/**
 * 加载信息.
 *
 * @author dongbin
 * @version 0.1 2022/5/24 14:06
 * @since 1.8
 */
public class SearchAfterLoadInfo {
    private int limit;
    private long offset;
    private boolean asc;
    private boolean first;

    /**
     * 构造新的加载信息.
     *
     * @param limit 极限元素数量.
     * @param offset 当前偏移量.
     * @param asc true 降序, false 升序.
     * @param first true 第一次加载, false 非第一次.
     */
    public SearchAfterLoadInfo(int limit, long offset, boolean asc, boolean first) {
        this.limit = limit;
        this.offset = offset;
        this.asc = asc;
        this.first = first;
    }

    public int limit() {
        return limit;
    }

    public long offset() {
        return offset;
    }

    public boolean asc() {
        return asc;
    }

    public boolean first() {
        return first;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("SearchAfterLoadInfo{");
        sb.append("asc=").append(asc);
        sb.append(", first=").append(first);
        sb.append(", limit=").append(limit);
        sb.append(", offset=").append(offset);
        sb.append('}');
        return sb.toString();
    }
}
