/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.common.file;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.StringTokenizer;

public final class MapperByteBufferUnmapper {
    private static final Version VERSION = MapperByteBufferUnmapper.parseVersion(System.getProperty("java.specification.version"));
    private static final MethodHandle UNMAP;
    private static final RuntimeException UNMAP_NOT_SUPPORTED_EXCEPTION;

    public static void unmap(MappedByteBuffer buffer) throws IOException {
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("Unmapping only works with direct buffers");
        }
        if (UNMAP == null) {
            throw UNMAP_NOT_SUPPORTED_EXCEPTION;
        }
        try {
            UNMAP.invokeExact(buffer);
        }
        catch (Throwable throwable) {
            throw new IOException("Unable to unmap the mapped buffer.", throwable);
        }
    }

    private static MethodHandle lookupUnmapMethodHandle() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            if (VERSION.isJava9Compatible()) {
                return MapperByteBufferUnmapper.unmapJava9(lookup);
            }
            return MapperByteBufferUnmapper.unmapJava7Or8(lookup);
        }
        catch (ReflectiveOperationException | RuntimeException e1) {
            throw new UnsupportedOperationException("Unmapping is not supported on this platform, because internal Java APIs are not compatible.", e1);
        }
    }

    private static MethodHandle unmapJava7Or8(MethodHandles.Lookup lookup) throws ReflectiveOperationException {
        Class<?> directBufferClass = Class.forName("java.nio.DirectByteBuffer");
        Method m = directBufferClass.getMethod("cleaner", new Class[0]);
        m.setAccessible(true);
        MethodHandle directBufferCleanerMethod = lookup.unreflect(m);
        TypeDescriptor.OfField cleanerClass = directBufferCleanerMethod.type().returnType();
        MethodHandle cleanMethod = lookup.findVirtual((Class<?>)cleanerClass, "clean", MethodType.methodType(Void.TYPE));
        MethodHandle nonNullTest = lookup.findStatic(MapperByteBufferUnmapper.class, "nonNull", MethodType.methodType(Boolean.TYPE, Object.class)).asType(MethodType.methodType(Boolean.TYPE, cleanerClass));
        MethodHandle noop = MethodHandles.dropArguments(MethodHandles.constant(Void.class, null).asType(MethodType.methodType(Void.TYPE)), 0, new Class[]{cleanerClass});
        MethodHandle unmapper = MethodHandles.filterReturnValue(directBufferCleanerMethod, MethodHandles.guardWithTest(nonNullTest, cleanMethod, noop)).asType(MethodType.methodType(Void.TYPE, ByteBuffer.class));
        return unmapper;
    }

    private static MethodHandle unmapJava9(MethodHandles.Lookup lookup) throws ReflectiveOperationException {
        Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
        MethodHandle unmapper = lookup.findVirtual(unsafeClass, "invokeCleaner", MethodType.methodType(Void.TYPE, ByteBuffer.class));
        Field f = unsafeClass.getDeclaredField("theUnsafe");
        f.setAccessible(true);
        Object theUnsafe = f.get(null);
        return unmapper.bindTo(theUnsafe);
    }

    private static boolean nonNull(Object o) {
        return o != null;
    }

    private static Version parseVersion(String versionString) {
        StringTokenizer st = new StringTokenizer(versionString, ".");
        int majorVersion = Integer.parseInt(st.nextToken());
        int minorVersion = st.hasMoreTokens() ? Integer.parseInt(st.nextToken()) : 0;
        return new Version(majorVersion, minorVersion);
    }

    static {
        MethodHandle unmap = null;
        RuntimeException exception = null;
        try {
            unmap = MapperByteBufferUnmapper.lookupUnmapMethodHandle();
        }
        catch (RuntimeException e) {
            exception = e;
        }
        if (unmap != null) {
            UNMAP = unmap;
            UNMAP_NOT_SUPPORTED_EXCEPTION = null;
        } else {
            UNMAP = null;
            UNMAP_NOT_SUPPORTED_EXCEPTION = exception;
        }
    }

    static class Version {
        public final int majorVersion;
        public final int minorVersion;

        private Version(int majorVersion, int minorVersion) {
            this.majorVersion = majorVersion;
            this.minorVersion = minorVersion;
        }

        public String toString() {
            return "Version(majorVersion=" + this.majorVersion + ", minorVersion=" + this.minorVersion + ")";
        }

        public boolean isJava9Compatible() {
            return this.majorVersion >= 9;
        }

        public boolean isJava11Compatible() {
            return this.majorVersion >= 11;
        }
    }
}

