/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.common;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Function;

public class ArrayUtil {
    private ArrayUtil() {
    }

    public static long[] removeDuplicateWithSort(long[] target) {
        if (target == null) {
            return target;
        }
        boolean threshold = true;
        if (target.length <= 1) {
            return target;
        }
        long[] useTarget = Arrays.copyOf(target, target.length);
        int slow = 0;
        for (int fast = 1; fast < useTarget.length; ++fast) {
            long slowElem = useTarget[slow];
            long fastElem = useTarget[fast];
            if (slowElem == fastElem) continue;
            useTarget[++slow] = useTarget[fast];
        }
        return Arrays.copyOfRange(useTarget, 0, slow + 1);
    }

    public static int[] removeDuplicateWithSort(int[] target) {
        if (target == null) {
            return target;
        }
        boolean threshold = true;
        if (target.length <= 1) {
            return target;
        }
        int[] useTarget = Arrays.copyOf(target, target.length);
        int slow = 0;
        for (int fast = 1; fast < useTarget.length; ++fast) {
            int slowElem = useTarget[slow];
            int fastElem = useTarget[fast];
            if (slowElem == fastElem) continue;
            useTarget[++slow] = useTarget[fast];
        }
        return Arrays.copyOfRange(useTarget, 0, slow + 1);
    }

    public static <T> T[] removeDuplicateWithSort(T[] target) {
        if (target == null) {
            return target;
        }
        boolean threshold = true;
        if (target.length <= 1) {
            return target;
        }
        T[] useTarget = Arrays.copyOf(target, target.length);
        int slow = 0;
        for (int fast = 1; fast < useTarget.length; ++fast) {
            T slowElem = useTarget[slow];
            T fastElem = useTarget[fast];
            if (slowElem.equals(fastElem)) continue;
            useTarget[++slow] = useTarget[fast];
        }
        return Arrays.copyOfRange(useTarget, 0, slow + 1);
    }

    public static long[] mergeRemoveDuplicateWithSort(long[] a, long[] b) {
        if (!(a != null && a.length != 0 || b != null && b.length != 0)) {
            return new long[0];
        }
        if (a == null || a.length == 0) {
            return b;
        }
        if (b == null || b.length == 0) {
            return a;
        }
        long[] useA = ArrayUtil.removeDuplicateWithSort(a);
        long[] useB = ArrayUtil.removeDuplicateWithSort(b);
        long[] buff = new long[a.length + b.length];
        int p0 = 0;
        int p1 = 0;
        int point = 0;
        while (p0 < useA.length && p1 < useB.length) {
            if (useA[p0] < useB[p1]) {
                buff[point] = useA[p0];
                ++p0;
            } else if (useA[p0] > b[p1]) {
                buff[point] = b[p1];
                ++p1;
            } else {
                buff[point] = useA[p0];
                ++p0;
                ++p1;
            }
            if (point > 0) {
                if (buff[point] == buff[point - 1]) continue;
                ++point;
                continue;
            }
            ++point;
        }
        if (p0 < useA.length) {
            System.arraycopy(useA, p0, buff, point, useA.length - p0);
            point += useA.length - p0;
        } else {
            System.arraycopy(useB, p1, buff, point, useB.length - p1);
            point += useB.length - p1;
        }
        return Arrays.copyOfRange(buff, 0, point);
    }

    public static int[] mergeRemoveDuplicateWithSort(int[] a, int[] b) {
        if (!(a != null && a.length != 0 || b != null && b.length != 0)) {
            return new int[0];
        }
        if (a == null || a.length == 0) {
            return b;
        }
        if (b == null || b.length == 0) {
            return a;
        }
        int[] useA = ArrayUtil.removeDuplicateWithSort(a);
        int[] useB = ArrayUtil.removeDuplicateWithSort(b);
        int[] buff = new int[a.length + b.length];
        int p0 = 0;
        int p1 = 0;
        int point = 0;
        while (p0 < useA.length && p1 < useB.length) {
            if (useA[p0] < useB[p1]) {
                buff[point] = useA[p0];
                ++p0;
            } else if (useA[p0] > b[p1]) {
                buff[point] = b[p1];
                ++p1;
            } else {
                buff[point] = useA[p0];
                ++p0;
                ++p1;
            }
            if (point > 0) {
                if (buff[point] == buff[point - 1]) continue;
                ++point;
                continue;
            }
            ++point;
        }
        if (p0 < useA.length) {
            System.arraycopy(useA, p0, buff, point, useA.length - p0);
            point += useA.length - p0;
        } else {
            System.arraycopy(useB, p1, buff, point, useB.length - p1);
            point += useB.length - p1;
        }
        return Arrays.copyOfRange(buff, 0, point);
    }

    public static <T> T[] mergeRemoveDuplicateWithSort(T[] a, T[] b, Comparator<T> comparator) {
        Class<?> newType = a.getClass();
        if (!(a != null && a.length != 0 || b != null && b.length != 0)) {
            return newType == Object[].class ? new Object[]{} : (Object[])Array.newInstance(newType.getComponentType(), 0);
        }
        if (a == null || a.length == 0) {
            return b;
        }
        if (b == null || b.length == 0) {
            return a;
        }
        T[] useA = ArrayUtil.removeDuplicateWithSort(a);
        T[] useB = ArrayUtil.removeDuplicateWithSort(b);
        Object[] buff = newType == Object[].class ? new Object[a.length + b.length] : (Object[])Array.newInstance(newType.getComponentType(), a.length + b.length);
        int p0 = 0;
        int p1 = 0;
        int point = 0;
        while (p0 < useA.length && p1 < useB.length) {
            int compareResult = comparator.compare(useA[p0], useB[p1]);
            if (compareResult < 0) {
                buff[point] = useA[p0];
                ++p0;
            } else if (compareResult > 0) {
                buff[point] = b[p1];
                ++p1;
            } else {
                buff[point] = useA[p0];
                ++p0;
                ++p1;
            }
            if (point > 0) {
                if (comparator.compare(buff[point], buff[point - 1]) == 0) continue;
                ++point;
                continue;
            }
            ++point;
        }
        if (p0 < useA.length) {
            System.arraycopy(useA, p0, buff, point, useA.length - p0);
            point += useA.length - p0;
        } else {
            System.arraycopy(useB, p1, buff, point, useB.length - p1);
            point += useB.length - p1;
        }
        return Arrays.copyOfRange(buff, 0, point);
    }

    public static <T, R> int binarySearch(T[] target, R key, Function<T, R> keyFunction, Comparator<R> comparator) {
        int low = 0;
        int high = target.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            R midKey = keyFunction.apply(target[mid]);
            int compareResult = comparator.compare(key, midKey);
            if (compareResult == 0) {
                return mid;
            }
            if (compareResult == -1) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return -1;
    }
}

