/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.common.load;

import com.xforceplus.ultraman.oqsengine.plus.common.load.SystemLoadEvaluator;
import com.xforceplus.ultraman.oqsengine.plus.common.load.loadfactor.LoadFactor;
import java.util.Collection;

public class DefaultSystemLoadEvaluator
implements SystemLoadEvaluator {
    private static double MAX_VALUE = 100.0;
    private static double MIN_VALUE = 0.0;
    private double max;
    private Collection<LoadFactor> loadFactors;

    public void setLoadFactors(Collection<LoadFactor> loadFactors) {
        this.loadFactors = loadFactors;
        this.max = loadFactors.stream().filter(loadFactor -> loadFactor.weight() > 0.0).mapToDouble(loadFactor -> {
            double weight = loadFactor.weight();
            if (weight > 1.0) {
                weight = 1.0;
            }
            return MAX_VALUE * weight;
        }).sum();
    }

    @Override
    public double evaluate() {
        if (this.loadFactors == null) {
            return (int)MIN_VALUE;
        }
        double value = this.loadFactors.stream().filter(loadFactor -> loadFactor.weight() > 0.0).mapToDouble(loadFactor -> {
            double load = loadFactor.now();
            double weight = loadFactor.weight();
            if (weight > 1.0) {
                weight = 1.0;
            }
            if (load < MIN_VALUE) {
                return MIN_VALUE;
            }
            if (load > MAX_VALUE) {
                return MAX_VALUE * weight;
            }
            return load * weight;
        }).sum();
        double load = value / this.max * 100.0;
        if (Double.isNaN(load)) {
            return MIN_VALUE;
        }
        if (Double.isInfinite(load)) {
            return MIN_VALUE;
        }
        return load;
    }
}

