/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.common.pool;

import java.nio.ByteBuffer;

public class DirectByteBufferTable {
    private static final int MIN_BLOCK_SIZE = 4096;
    private static int DEFAULT_SIZE = 12;
    private static final DirectByteBufferTable INSTANCE = new DirectByteBufferTable();
    private int alignmentBlockSize;
    private DirectByteBuff[] buffers = new DirectByteBuff[DEFAULT_SIZE];

    public DirectByteBufferTable() {
        this(4096);
    }

    public DirectByteBufferTable(int alignmentBlockSize) {
        this.alignmentBlockSize = alignmentBlockSize;
        if (this.alignmentBlockSize < 4096) {
            this.alignmentBlockSize = 4096;
        }
    }

    public static DirectByteBufferTable getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirectByteBuff allocate(int cap) {
        int blockSize = this.calculateBlockSize(cap);
        int blockIndex = this.calculationBlockIndex(blockSize);
        DirectByteBuff[] directByteBuffArray = this.buffers;
        synchronized (this.buffers) {
            if (blockIndex > this.buffers.length - 1) {
                DirectByteBuff[] newBuffers = new DirectByteBuff[this.buffers.length * 2];
                System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
                this.buffers = newBuffers;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            DirectByteBuff buff = this.buffers[blockIndex];
            if (buff == null) {
                DirectByteBuff[] directByteBuffArray2 = this.buffers;
                synchronized (this.buffers) {
                    buff = this.buffers[blockIndex];
                    if (buff == null) {
                        this.buffers[blockIndex] = buff = new DirectByteBuff(ByteBuffer.allocateDirect(blockSize));
                    }
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                }
            } else if (buff.isBusy()) {
                throw new RuntimeException(String.format("A direct buffer of length (%d) is in use.", cap));
            }
            {
                buff.busy();
                return buff;
            }
        }
    }

    private int calculateBlockSize(int cap) {
        return cap + (this.alignmentBlockSize - 1) & ~(this.alignmentBlockSize - 1);
    }

    private int calculationBlockIndex(int blockSize) {
        return blockSize / this.alignmentBlockSize - 1;
    }

    public static class DirectByteBuff
    implements AutoCloseable {
        private ByteBuffer buff;
        private volatile boolean free;

        public DirectByteBuff(ByteBuffer buff) {
            this.buff = buff;
            this.free = true;
        }

        public ByteBuffer buff() {
            return this.buff;
        }

        protected void busy() {
            this.free = false;
        }

        protected boolean isBusy() {
            return !this.free;
        }

        @Override
        public void close() throws Exception {
            if (this.isBusy()) {
                this.free = true;
                this.buff.clear();
            }
        }
    }
}

