/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.common.thread;

import com.xforceplus.ultraman.oqsengine.plus.common.thread.LifeCycledThread;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingThreadExecutor<T>
implements LifeCycledThread<T> {
    private final Logger logger = LoggerFactory.getLogger(PollingThreadExecutor.class);
    private Thread worker;
    private int duration = 1;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private int maxStopTimes = 10;
    private volatile boolean tryStop = false;

    public PollingThreadExecutor(String workName, int duration, TimeUnit timeUnit, int maxWait, Consumer<T> consumer, T element) {
        if (duration > 0) {
            this.duration = duration;
        }
        if (null != timeUnit) {
            this.timeUnit = timeUnit;
        }
        if (maxWait > 0) {
            this.maxStopTimes = maxWait;
        }
        this.worker = new Thread(() -> {
            while (!this.tryStop) {
                consumer.accept(element);
                this.wakeupAfter(this.duration, this.timeUnit);
            }
        });
        this.worker.setName(workName);
    }

    @Override
    public void start() {
        this.logger.info("[pollingThread-{}] start.", (Object)this.worker.getName());
        this.worker.start();
    }

    @Override
    public void stop() {
        this.tryStop = true;
        for (int tryTimes = 0; tryTimes < this.maxStopTimes; ++tryTimes) {
            if (!this.worker.isAlive()) {
                this.logger.info("[pollingThread-{}] stopped.", (Object)this.worker.getName());
                break;
            }
            this.wakeupAfter(this.duration, this.timeUnit);
        }
        if (this.worker.isAlive()) {
            this.logger.warn("[pollingThread-{}] stopped by force.", (Object)this.worker.getName());
            this.worker.interrupt();
        }
    }

    private void wakeupAfter(long duration, TimeUnit timeUnit) {
        try {
            Thread.sleep(timeUnit.toMillis(duration));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

