package com.xforceplus.ultraman.oqsengine.plus.event.payload.transaction;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;

/**
 * 事务提交事件的负载.
 *
 * @author dongbin
 * @version 0.1 2021/3/24 15:03
 * @since 1.8
 */
public class CommitPayload implements Serializable {
    private long txId;
    private long commitId;
    private String msg;
    private boolean readonly;

    public long getTxId() {
        return txId;
    }

    public long getCommitId() {
        return commitId;
    }

    public Optional<String> getMsg() {
        return Optional.ofNullable(msg);
    }

    public boolean isReadonly() {
        return readonly;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CommitPayload)) {
            return false;
        }
        CommitPayload that = (CommitPayload) o;
        return getTxId() == that.getTxId() && getCommitId() == that.getCommitId() && isReadonly() == that.isReadonly()
            && Objects.equals(getMsg(), that.getMsg());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getTxId(), getCommitId(), getMsg(), isReadonly());
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", CommitPayload.class.getSimpleName() + "[", "]")
            .add("commitId=" + commitId)
            .add("msg='" + msg + "'")
            .add("readonly=" + readonly)
            .add("txId=" + txId)
            .toString();
    }

    /**
     * 构造器.
     */
    public static final class Builder {
        private long txId;
        private long commitId;
        private String msg;
        private boolean readonly;

        private Builder() {}

        public static Builder anCommitPayload() {
            return new Builder();
        }

        public Builder withTxId(long txId) {
            this.txId = txId;
            return this;
        }

        public Builder withCommitId(long commitId) {
            this.commitId = commitId;
            return this;
        }

        public Builder withMsg(String msg) {
            this.msg = msg;
            return this;
        }

        public Builder withReadonly(boolean readonly) {
            this.readonly = readonly;
            return this;
        }

        /**
         * 构造.
         */
        public CommitPayload build() {
            CommitPayload commitPayload = new CommitPayload();
            commitPayload.msg = this.msg;
            commitPayload.readonly = this.readonly;
            commitPayload.commitId = this.commitId;
            commitPayload.txId = this.txId;
            return commitPayload;
        }
    }
}
