package com.xforceplus.ultraman.oqsengine.plus.event.storage;

import com.xforceplus.ultraman.oqsengine.plus.event.Event;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.LongAdder;

/**
 * 基于内存非持久化的事件储存.
 * TODO: 暂时没有实现事件的优先级.
 *
 * @author dongbin
 * @version 0.1 2021/3/24 11:37
 * @since 1.8
 */
public class MemoryEventStorage implements EventStorage {

    private Queue<Event> eventQueue = new ConcurrentLinkedQueue();

    private LongAdder size = new LongAdder();

    @Override
    public boolean push(Event event) {
        if (eventQueue.offer(event)) {
            size.increment();
            return true;
        }

        return false;
    }

    @Override
    public Optional<Event> pop() {
        Event event = eventQueue.poll();
        if (event != null) {
            size.decrement();
            return Optional.of(event);
        } else {
            return Optional.empty();
        }
    }

    @Override
    public void clear() {
        size.reset();
        eventQueue.clear();
    }

    @Override
    public int size() {
        return size.intValue();
    }
}
