/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.event.payload.transaction;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;

public class CommitPayload
implements Serializable {
    private long txId;
    private long commitId;
    private String msg;
    private boolean readonly;

    public long getTxId() {
        return this.txId;
    }

    public long getCommitId() {
        return this.commitId;
    }

    public Optional<String> getMsg() {
        return Optional.ofNullable(this.msg);
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CommitPayload)) {
            return false;
        }
        CommitPayload that = (CommitPayload)o;
        return this.getTxId() == that.getTxId() && this.getCommitId() == that.getCommitId() && this.isReadonly() == that.isReadonly() && Objects.equals(this.getMsg(), that.getMsg());
    }

    public int hashCode() {
        return Objects.hash(this.getTxId(), this.getCommitId(), this.getMsg(), this.isReadonly());
    }

    public String toString() {
        return new StringJoiner(", ", CommitPayload.class.getSimpleName() + "[", "]").add("commitId=" + this.commitId).add("msg='" + this.msg + "'").add("readonly=" + this.readonly).add("txId=" + this.txId).toString();
    }

    public static final class Builder {
        private long txId;
        private long commitId;
        private String msg;
        private boolean readonly;

        private Builder() {
        }

        public static Builder anCommitPayload() {
            return new Builder();
        }

        public Builder withTxId(long txId) {
            this.txId = txId;
            return this;
        }

        public Builder withCommitId(long commitId) {
            this.commitId = commitId;
            return this;
        }

        public Builder withMsg(String msg) {
            this.msg = msg;
            return this;
        }

        public Builder withReadonly(boolean readonly) {
            this.readonly = readonly;
            return this;
        }

        public CommitPayload build() {
            CommitPayload commitPayload = new CommitPayload();
            commitPayload.msg = this.msg;
            commitPayload.readonly = this.readonly;
            commitPayload.commitId = this.commitId;
            commitPayload.txId = this.txId;
            return commitPayload;
        }
    }
}

