/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.event.storage;

import com.xforceplus.ultraman.oqsengine.plus.event.Event;
import com.xforceplus.ultraman.oqsengine.plus.event.storage.EventStorage;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.LongAdder;

public class MemoryEventStorage
implements EventStorage {
    private Queue<Event> eventQueue = new ConcurrentLinkedQueue<Event>();
    private LongAdder size = new LongAdder();

    @Override
    public boolean push(Event event) {
        if (this.eventQueue.offer(event)) {
            this.size.increment();
            return true;
        }
        return false;
    }

    @Override
    public Optional<Event> pop() {
        Event event = this.eventQueue.poll();
        if (event != null) {
            this.size.decrement();
            return Optional.of(event);
        }
        return Optional.empty();
    }

    @Override
    public void clear() {
        this.size.reset();
        this.eventQueue.clear();
    }

    @Override
    public int size() {
        return this.size.intValue();
    }
}

