/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.core.impl;

import com.xforceplus.ultraman.core.EntityWriteService;
import com.xforceplus.ultraman.core.pojo.OqsEngineResult;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.entity.EntityClassRef;
import com.xforceplus.ultraman.metadata.entity.IEntity;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.values.IValue;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.MasterStorage;
import com.xforceplus.ultraman.oqsengine.plus.storage.pojo.dto.EntityPackage;
import com.xforceplus.ultraman.oqsengine.plus.storage.pojo.dto.select.SelectConfig;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Transactional
public class EntityWriteServiceImpl
implements EntityWriteService {
    private MasterStorage masterStorage;
    private EntityClassEngine engine;

    public EntityWriteServiceImpl(MasterStorage masterStorage, EntityClassEngine engine) {
        this.masterStorage = masterStorage;
        this.engine = engine;
    }

    @Override
    public OqsEngineResult<Long> build(IEntity entity, Map<String, Object> context) {
        Optional entityClassOp;
        if (entity.time() == 0L) {
            entity.markTime();
        }
        if ((entityClassOp = this.engine.load(Long.toString(entity.entityClassRef().getId()), entity.entityClassRef().getProfile())).isPresent()) {
            try {
                boolean result = this.masterStorage.build(entity, (IEntityClass)entityClassOp.get(), context);
                if (result) {
                    return OqsEngineResult.success(entity.id());
                }
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return OqsEngineResult.elevateFailed();
            }
            catch (SQLException throwables) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return OqsEngineResult.elevateFailed(throwables.getMessage());
            }
        }
        return OqsEngineResult.elevateFailed("entityClass load failed.");
    }

    @Override
    public OqsEngineResult<Long> build(IEntity[] entities, Map<String, Object> context) {
        EntityPackage entityPackage = EntityPackage.build();
        Map<Tuple2, List<IEntity>> grouped = Arrays.stream(entities).collect(Collectors.groupingBy(x -> Tuple.of((Object)x.entityClassRef().getId(), (Object)Optional.ofNullable(x.entityClassRef().getProfile()).orElse(""))));
        try {
            long start = System.currentTimeMillis();
            for (Map.Entry<Tuple2, List<IEntity>> entityEntry : grouped.entrySet()) {
                Optional entityClassOp = this.engine.load(Long.toString((Long)entityEntry.getKey()._1), (String)entityEntry.getKey()._2);
                entityClassOp.ifPresent(entityClass -> {
                    List entityList = (List)entityEntry.getValue();
                    entityList.forEach(x -> {
                        if (x.time() == 0L) {
                            x.markTime();
                        }
                        entityPackage.put(x, entityClass);
                    });
                });
            }
            System.out.println(System.currentTimeMillis() - start);
            this.masterStorage.build(entityPackage, context);
            return OqsEngineResult.success(entityPackage.size());
        }
        catch (Throwable throwables) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return OqsEngineResult.elevateFailed(throwables.getMessage());
        }
    }

    @Override
    public OqsEngineResult<Long> replace(IEntity entity, Map<String, Object> context) {
        Optional entityClassOp;
        if (entity.time() == 0L) {
            entity.markTime();
        }
        if ((entityClassOp = this.engine.load(Long.toString(entity.entityClassRef().getId()), entity.entityClassRef().getProfile())).isPresent()) {
            try {
                boolean result = this.masterStorage.replace(entity, (IEntityClass)entityClassOp.get(), context);
                if (result) {
                    return OqsEngineResult.success(entity.id());
                }
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return OqsEngineResult.elevateFailed();
            }
            catch (SQLException throwables) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return OqsEngineResult.elevateFailed(throwables.getMessage());
            }
        }
        return OqsEngineResult.elevateFailed("entityClass load failed.");
    }

    @Override
    public OqsEngineResult<Long> replace(IEntity[] entities, Map<String, Object> context) {
        EntityPackage entityPackage = EntityPackage.build();
        for (IEntity entity : entities) {
            if (entity.time() == 0L) {
                entity.markTime();
            }
            Optional entityClassOp = this.engine.load(Long.toString(entity.entityClassRef().getId()), entity.entityClassRef().getProfile());
            entityClassOp.ifPresent(entityClass -> entityPackage.put(entity, entityClass));
        }
        try {
            this.masterStorage.replace(entityPackage, context);
            return OqsEngineResult.success(entityPackage.size());
        }
        catch (SQLException throwables) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return OqsEngineResult.elevateFailed(throwables.getMessage());
        }
    }

    @Override
    public OqsEngineResult<Long> replace(SelectConfig selectConfig, EntityClassRef entityClassRef, Map<String, Object> context, IValue ... newValues) {
        return null;
    }

    @Override
    public OqsEngineResult<Long> delete(IEntity entity, Map<String, Object> context) {
        Optional entityClassOp;
        if (entity.time() == 0L) {
            entity.markTime();
        }
        if ((entityClassOp = this.engine.load(Long.toString(entity.entityClassRef().getId()), entity.entityClassRef().getProfile())).isPresent()) {
            try {
                boolean result = this.masterStorage.delete(entity, (IEntityClass)entityClassOp.get(), context);
                if (result) {
                    return OqsEngineResult.success(entity.id());
                }
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return OqsEngineResult.elevateFailed();
            }
            catch (SQLException throwables) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return OqsEngineResult.elevateFailed(throwables.getMessage());
            }
        }
        TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        return OqsEngineResult.elevateFailed("entityClass load failed.");
    }

    @Override
    public OqsEngineResult<Long> delete(IEntity[] entities, Map<String, Object> context) {
        EntityPackage entityPackage = EntityPackage.build();
        for (IEntity entity : entities) {
            if (entity.time() == 0L) {
                entity.markTime();
            }
            Optional entityClassOp = this.engine.load(Long.toString(entity.entityClassRef().getId()), entity.entityClassRef().getProfile());
            entityClassOp.ifPresent(entityClass -> entityPackage.put(entity, entityClass));
        }
        try {
            this.masterStorage.delete(entityPackage, context);
            return OqsEngineResult.success(entityPackage.size());
        }
        catch (SQLException throwables) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return OqsEngineResult.elevateFailed(throwables.getMessage());
        }
    }

    @Override
    public OqsEngineResult<Long> delete(SelectConfig selectConfig, EntityClassRef entityClassRef, Map<String, Object> context) {
        return null;
    }
}

