/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.core.impl;

import com.xforceplus.ultraman.core.EntityQueryService;
import com.xforceplus.ultraman.core.pojo.OqsEngineResult;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.entity.EntityClassRef;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.MasterStorage;
import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.table.QueryResult;
import com.xforceplus.ultraman.oqsengine.plus.storage.pojo.dto.select.SelectConfig;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Resource;

public class EntityQueryServiceImpl
implements EntityQueryService {
    @Resource
    private MasterStorage masterStorage;
    @Resource
    private EntityClassEngine engine;

    public EntityQueryServiceImpl(MasterStorage masterStorage, EntityClassEngine engine) {
        this.masterStorage = masterStorage;
        this.engine = engine;
    }

    @Override
    public OqsEngineResult<Collection<QueryResult>> selectByConditions(SelectConfig selectConfig, EntityClassRef entityClassRef) {
        Optional entityClassOp = this.engine.load(Long.toString(entityClassRef.getId()), entityClassRef.getProfile());
        if (entityClassOp.isPresent()) {
            try {
                Collection entities = this.masterStorage.selectEntities(selectConfig, (IEntityClass)entityClassOp.get());
                return OqsEngineResult.success(entities);
            }
            catch (SQLException throwables) {
                return OqsEngineResult.elevateFailed(throwables.getMessage());
            }
        }
        return OqsEngineResult.elevateFailed("entityClass load failed.");
    }

    @Override
    public OqsEngineResult<Long> count(SelectConfig selectConfig, EntityClassRef entityClassRef) {
        return null;
    }

    @Override
    public OqsEngineResult<Collection<QueryResult>> search(SelectConfig config) {
        return null;
    }
}

