/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.core.impl;

import com.xforceplus.ultraman.core.EntityWriteService;
import com.xforceplus.ultraman.core.pojo.OqsEngineResult;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntity;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.MasterStorage;
import com.xforceplus.ultraman.oqsengine.plus.storage.pojo.dto.EntityPackage;
import com.xforceplus.ultraman.sdk.core.pojo.UpdateConfig;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpCondition;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpField;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpNode;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpOperator;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpQuery;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpRel;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpValue;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Metrics;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Transactional
public class EntityWriteServiceImpl
implements EntityWriteService {
    private static final Logger log = LoggerFactory.getLogger(EntityWriteServiceImpl.class);
    private MasterStorage masterStorage;
    private EntityClassEngine engine;
    private final Counter failCountTotal = Metrics.counter((String)"oqs.fail.count.total", (String[])new String[0]);

    public EntityWriteServiceImpl(MasterStorage masterStorage, EntityClassEngine engine) {
        this.masterStorage = masterStorage;
        this.engine = engine;
    }

    @Override
    public OqsEngineResult<Long> build(IEntity entity, Map<String, Object> context) {
        Optional entityClassOp;
        if (entity.time() == 0L) {
            entity.markTime();
        }
        if ((entityClassOp = this.engine.load(Long.toString(entity.entityClassRef().getId()), entity.entityClassRef().getProfile())).isPresent()) {
            try {
                boolean result = this.masterStorage.build(entity, (IEntityClass)entityClassOp.get(), context);
                if (result) {
                    return OqsEngineResult.success(entity.id());
                }
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                this.failCountTotal.increment();
                return OqsEngineResult.unCreated();
            }
            catch (SQLException throwable) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                this.failCountTotal.increment();
                return OqsEngineResult.panic(throwable);
            }
        }
        return OqsEngineResult.notExistMeta(entity.entityClassRef());
    }

    @Override
    public OqsEngineResult<Long> build(IEntity[] entities, Map<String, Object> context) {
        EntityPackage entityPackage = EntityPackage.build();
        Map<Tuple2, List<IEntity>> grouped = Arrays.stream(entities).collect(Collectors.groupingBy(x -> Tuple.of((Object)x.entityClassRef().getId(), (Object)Optional.ofNullable(x.entityClassRef().getProfile()).orElse(""))));
        try {
            long start = System.currentTimeMillis();
            for (Map.Entry<Tuple2, List<IEntity>> entityEntry : grouped.entrySet()) {
                Optional entityClassOp = this.engine.load(Long.toString((Long)entityEntry.getKey()._1), (String)entityEntry.getKey()._2);
                entityClassOp.ifPresent(entityClass -> {
                    List entityList = (List)entityEntry.getValue();
                    entityList.forEach(x -> {
                        if (x.time() == 0L) {
                            x.markTime();
                        }
                        entityPackage.put(x, entityClass);
                    });
                });
            }
            log.warn("build time {}", (Object)(System.currentTimeMillis() - start));
            this.masterStorage.build(entityPackage, context);
            return OqsEngineResult.success(entityPackage.size());
        }
        catch (Throwable throwable) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            this.failCountTotal.increment((double)entities.length);
            return OqsEngineResult.panic(throwable);
        }
    }

    @Override
    public OqsEngineResult<Long> replace(IEntity entity, UpdateConfig updateConfig, Map<String, Object> context) {
        Optional entityClassOp;
        if (entity.time() == 0L) {
            entity.markTime();
        }
        if ((entityClassOp = this.engine.load(Long.toString(entity.entityClassRef().getId()), entity.entityClassRef().getProfile())).isPresent()) {
            try {
                if (updateConfig != null && updateConfig.getVersion() != null && updateConfig.getVersion() >= 0) {
                    entity.resetVersion(updateConfig.getVersion().intValue());
                } else {
                    entity.resetVersion(-1);
                }
                if (updateConfig != null && updateConfig.getUseOptimizeLock() != null && updateConfig.getUseOptimizeLock().booleanValue()) {
                    entity.resetOptimizeLock(true);
                } else {
                    entity.resetOptimizeLock(false);
                }
                boolean result = this.masterStorage.replace(entity, (IEntityClass)entityClassOp.get(), context);
                if (result) {
                    return OqsEngineResult.success(entity.id());
                }
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return OqsEngineResult.unReplaced(entity.id());
            }
            catch (SQLException throwable) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                this.failCountTotal.increment();
                return OqsEngineResult.panic(throwable);
            }
        }
        return OqsEngineResult.notExistMeta(entity.entityClassRef());
    }

    @Override
    public OqsEngineResult<Long> replace(IEntity[] entities, Map<String, Object> context) {
        EntityPackage entityPackage = EntityPackage.build();
        for (IEntity entity : entities) {
            if (entity.time() == 0L) {
                entity.markTime();
            }
            Optional entityClassOp = this.engine.load(Long.toString(entity.entityClassRef().getId()), entity.entityClassRef().getProfile());
            entityClassOp.ifPresent(entityClass -> entityPackage.put(entity, entityClass));
        }
        try {
            Boolean[] replace = this.masterStorage.replace(entityPackage, context);
            long successCount = Arrays.stream(replace).filter(x -> x).count();
            long failedCount = (long)replace.length - successCount;
            if (failedCount > 0L) {
                return OqsEngineResult.unReplaced(-1L);
            }
            return OqsEngineResult.success(Arrays.stream(replace).filter(x -> x).count());
        }
        catch (SQLException throwable) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            this.failCountTotal.increment((double)entities.length);
            return OqsEngineResult.panic(throwable);
        }
    }

    @Override
    public OqsEngineResult<Long> delete(IEntity entity, Map<String, Object> context) {
        Optional entityClassOp;
        if (entity.time() == 0L) {
            entity.markTime();
        }
        if ((entityClassOp = this.engine.load(Long.toString(entity.entityClassRef().getId()), entity.entityClassRef().getProfile())).isPresent()) {
            try {
                boolean result = this.masterStorage.delete(entity, (IEntityClass)entityClassOp.get(), context);
                Object relation = context.get("relations");
                if (relation instanceof String) {
                    String relationStr = relation.toString();
                    EntityClassGroup describe = this.engine.describe((IEntityClass)entityClassOp.get(), entity.entityClassRef().getProfile());
                    Optional relatedEntityClassOp = describe.relatedEntityClass(relationStr);
                    if (relatedEntityClassOp.isPresent()) {
                        IEntityClass relatedEntityClass = (IEntityClass)relatedEntityClassOp.get();
                        EntityPackage entityPackage = new EntityPackage();
                        entityPackage.setTargetEntityClass(relatedEntityClass);
                        entityPackage.setTargetCode(relatedEntityClass.code());
                        ExpCondition query = ExpCondition.call((ExpOperator)ExpOperator.EQUALS, (ExpNode)ExpField.field((String)relationStr.concat(".id")), (List)ExpValue.from((Object)entity.id()));
                        entityPackage.setCondition((ExpRel)new ExpQuery().filters((ExpNode)query).range(Integer.valueOf(1), Integer.valueOf(10000)));
                        this.masterStorage.deleteByCondition(entityPackage, context);
                    }
                }
                if (result) {
                    return OqsEngineResult.success(entity.id());
                }
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                this.failCountTotal.increment();
                return OqsEngineResult.unDeleted(entity.id());
            }
            catch (SQLException throwable) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                this.failCountTotal.increment();
                return OqsEngineResult.panic(throwable);
            }
        }
        TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        this.failCountTotal.increment();
        return OqsEngineResult.notExistMeta(entity.entityClassRef());
    }

    @Override
    public OqsEngineResult<Long> delete(IEntity[] entities, Map<String, Object> context) {
        EntityPackage entityPackage = EntityPackage.build();
        for (IEntity entity : entities) {
            if (entity.time() == 0L) {
                entity.markTime();
            }
            Optional entityClassOp = this.engine.load(Long.toString(entity.entityClassRef().getId()), entity.entityClassRef().getProfile());
            entityClassOp.ifPresent(entityClass -> entityPackage.put(entity, entityClass));
        }
        try {
            Boolean[] delete = this.masterStorage.delete(entityPackage, context);
            return OqsEngineResult.success(Arrays.stream(delete).filter(x -> x).count());
        }
        catch (SQLException throwable) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            this.failCountTotal.increment((double)entities.length);
            return OqsEngineResult.panic(throwable);
        }
    }

    @Override
    public OqsEngineResult<Long> updateByCondition(IEntityClass entityClass, ExpRel expRel, IEntity example, Map<String, Object> context) {
        EntityPackage entityPackage = new EntityPackage();
        entityPackage.setCondition(expRel);
        entityPackage.setExample(example);
        entityPackage.setTargetCode(entityClass.code());
        entityPackage.setTargetEntityClass(entityClass);
        try {
            int affectedRow = this.masterStorage.replaceByCondition(entityPackage, context);
            return OqsEngineResult.success(affectedRow);
        }
        catch (SQLException throwable) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return OqsEngineResult.panic(throwable);
        }
    }

    @Override
    public OqsEngineResult<Long> deleteByCondition(IEntityClass entityClass, ExpRel expRel, Map<String, Object> context) {
        EntityPackage entityPackage = new EntityPackage();
        entityPackage.setCondition(expRel);
        entityPackage.setTargetCode(entityClass.code());
        entityPackage.setTargetEntityClass(entityClass);
        try {
            int affectedRow = this.masterStorage.deleteByCondition(entityPackage, context);
            return OqsEngineResult.success(affectedRow);
        }
        catch (SQLException throwable) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return OqsEngineResult.panic(throwable);
        }
    }
}

