package com.xforceplus.ultraman.core;

import com.xforceplus.ultraman.core.pojo.OqsEngineResult;
import com.xforceplus.ultraman.metadata.entity.EntityClassRef;
import com.xforceplus.ultraman.metadata.entity.IEntity;
import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.table.QueryResult;
import com.xforceplus.ultraman.oqsengine.plus.storage.pojo.dto.select.SelectConfig;

import java.util.Collection;

/**
 * Created by justin.xu on 03/2023.
 *
 * @since 1.8
 */
public interface EntityQueryService {
//
//    /**
//     * 根据一个长整形数字(对象的唯一标识)和类型信息指针查询一个实例.
//     *
//     * @param id             目标 id.
//     * @param entityClassRef 目标 entity 类型指针.
//     * @return 目标 entity 实体.
//     */
//    OqsEngineResult<QueryResult> selectOne(long id, EntityClassRef entityClassRef);
//
//
//    /**
//     * 根据多个长整形数字(对象的唯一标识)和类型信息指针查询多个实例.<br />
//     * 不存在的实例不会出现在返回结果列表中,如果所有数字对应的对象都不存在那么将返回一个空的列表.<br />
//     * 注意: 没有查询到任何对象也认为是成功.
//     *
//     * @param ids            目标 id 列表.
//     * @param entityClassRef 目标 entity 类型.
//     * @return 实体列表.
//     */
//    OqsEngineResult<Collection<QueryResult>> selectMultiple(long[] ids, EntityClassRef entityClassRef);

    /**
     * 条件查询,指定一个对象的字段条件,查询出所有符合条件的对象.<br />
     * 同时可以根据config信息进行截取和排序等.
     *
     * @param conditions     查询主条件组.
     * @param entityClassRef 查询目标entity元信息.
     * @param config         查询配置.
     * @return 查询结果列表.
     */
    OqsEngineResult<Collection<QueryResult>> selectByConditions(
            SelectConfig selectConfig, EntityClassRef entityClassRef);

    /**
     * 条件统计总数.<br />
     * 和条件查询本质是一样的,区别只是其并不会给出对象实例,而是给出符合条件的对象实例数量.<br />
     * 排序和截取在这是没有意义的,即使指定也会被忽略.<br />
     *
     * @param entityClassRef 查询目标entity元信息.
     * @param config         查询配置.
     * @return 数量.
     */
    OqsEngineResult<Long> count(
            SelectConfig selectConfig, EntityClassRef entityClassRef);

    /**
     * 跨类型的实例搜索.
     *
     * @param config 搜索配置.
     * @return 搜索结果.
     */
    OqsEngineResult<Collection<QueryResult>> search(SelectConfig config);
}
