/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.core.status;

import com.xforceplus.ultraman.core.status.State;
import com.xforceplus.ultraman.core.status.StateChecker;
import com.xforceplus.ultraman.core.status.StateControl;
import com.xforceplus.ultraman.oqsengine.plus.common.mode.OqsMode;
import com.xforceplus.ultraman.sdk.infra.base.thread.ExecutorHelper;
import com.xforceplus.ultraman.sdk.infra.lifecycle.SimpleLifecycle;
import io.micrometer.core.instrument.Metrics;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStateControl
implements StateControl,
SimpleLifecycle {
    private final Logger logger = LoggerFactory.getLogger(DefaultStateControl.class);
    private final AtomicInteger oqsMode = (AtomicInteger)Metrics.gauge((String)"oqs.mode", (Number)new AtomicInteger(0));
    private final AtomicInteger oqsModeRease = (AtomicInteger)Metrics.gauge((String)"oqs.readonly.rease", (Number)new AtomicInteger(0));
    private State state = State.NORMAL;
    private StateChecker checker;
    private ScheduledExecutorService worker;

    public DefaultStateControl(StateChecker checker) {
        this.checker = checker;
    }

    public void init() throws Exception {
        this.worker = Executors.newScheduledThreadPool(1, ExecutorHelper.buildNameThreadFactory((String)"oqs-state-monitor"));
        this.worker.scheduleWithFixedDelay(new Checker(), 12L, 12L, TimeUnit.SECONDS);
    }

    public void destroy() throws Exception {
        ExecutorHelper.shutdownAndAwaitTermination((ExecutorService)this.worker);
    }

    @Override
    public boolean isNormal() {
        return State.NORMAL == this.state;
    }

    @Override
    public State getLastState() {
        return this.state;
    }

    class Checker
    implements Runnable {
        Checker() {
        }

        @Override
        public void run() {
            DefaultStateControl.this.state = DefaultStateControl.this.checker.check();
            if (State.UNKNOWN == DefaultStateControl.this.state) {
                DefaultStateControl.this.state = State.NORMAL;
                if (DefaultStateControl.this.logger.isWarnEnabled()) {
                    DefaultStateControl.this.logger.warn("The status check result is UNKNOWN, which assumes that the status is normal.");
                }
            }
            if (State.NORMAL != DefaultStateControl.this.state) {
                if (DefaultStateControl.this.logger.isWarnEnabled()) {
                    DefaultStateControl.this.logger.warn("The state checker finds that the current state is abnormal and is {}.", (Object)DefaultStateControl.this.state.name());
                }
                DefaultStateControl.this.oqsMode.set(OqsMode.READ_ONLY.getValue());
                DefaultStateControl.this.oqsModeRease.set(DefaultStateControl.this.state.getSymbol());
            }
        }
    }
}

