/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.core.pojo;

import com.xforceplus.ultraman.core.pojo.Hint;
import com.xforceplus.ultraman.core.pojo.OqsEngineReusltAction;
import com.xforceplus.ultraman.core.pojo.exception.OqsEngineException;
import com.xforceplus.ultraman.metadata.entity.EntityClassRef;
import com.xforceplus.ultraman.metadata.entity.IEntity;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.values.IValue;
import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.table.QueryResult;
import com.xforceplus.ultraman.sdk.core.facade.result.ResultStatus;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OqsEngineResult<V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OqsEngineResult.class);
    private ResultStatus.OriginStatus resultStatus;
    private V value;
    private Throwable ex;
    private Collection<Hint> hints;
    private String message;
    private static final OqsEngineResult SUCCESS = new OqsEngineResult(ResultStatus.OriginStatus.SUCCESS, "");

    public static OqsEngineResult unknown() {
        return new OqsEngineResult(ResultStatus.OriginStatus.UNKNOWN, ResultStatus.OriginStatus.UNKNOWN.name());
    }

    public static OqsEngineResult success() {
        return SUCCESS;
    }

    public static OqsEngineResult success(String msg) {
        return new OqsEngineResult(ResultStatus.OriginStatus.SUCCESS, msg);
    }

    public static OqsEngineResult<QueryResult> success(QueryResult entity) {
        return new OqsEngineResult<QueryResult>(ResultStatus.OriginStatus.SUCCESS, entity, null);
    }

    public static OqsEngineResult<QueryResult[]> success(QueryResult[] entities) {
        return new OqsEngineResult<QueryResult[]>(ResultStatus.OriginStatus.SUCCESS, entities, null);
    }

    public static OqsEngineResult<Map<IEntity, IValue[]>> success(Map<IEntity, IValue[]> changes) {
        return new OqsEngineResult<Map<IEntity, IValue[]>>(ResultStatus.OriginStatus.SUCCESS, changes, null);
    }

    public static OqsEngineResult<Map.Entry<IEntity, IValue[]>> success(Map.Entry<IEntity, IValue[]> change) {
        return new OqsEngineResult<Map.Entry<IEntity, IValue[]>>(ResultStatus.OriginStatus.SUCCESS, change, null);
    }

    public static OqsEngineResult<Long> success(long value) {
        return new OqsEngineResult<Long>(ResultStatus.OriginStatus.SUCCESS, value, null);
    }

    public static OqsEngineResult<Collection<QueryResult>> success(Collection<QueryResult> entities) {
        return new OqsEngineResult<Collection<QueryResult>>(ResultStatus.OriginStatus.SUCCESS, entities, null);
    }

    public static OqsEngineResult panic(Throwable throwable) {
        LOGGER.error(throwable.getMessage(), throwable);
        return new OqsEngineResult(throwable);
    }

    public static OqsEngineResult conflict() {
        return OqsEngineResult.conflict(null);
    }

    public static OqsEngineResult conflict(String msg) {
        return new OqsEngineResult(ResultStatus.OriginStatus.CONFLICT, msg);
    }

    public static OqsEngineResult conflict(long entityId) {
        return OqsEngineResult.notFound(String.format("A conflict occurred for entity %d..", entityId));
    }

    public static OqsEngineResult notFound() {
        return OqsEngineResult.notFound(null);
    }

    public static OqsEngineResult notFound(String msg) {
        return new OqsEngineResult(ResultStatus.OriginStatus.NOT_FOUND, msg);
    }

    public static OqsEngineResult notFound(long entityId) {
        return OqsEngineResult.notFound(String.format("Entity %d was not found.", entityId));
    }

    public static OqsEngineResult unCreated() {
        return new OqsEngineResult(ResultStatus.OriginStatus.UNCREATED, "The entity was not created successfully.");
    }

    public static OqsEngineResult unReplaced(long id) {
        OqsEngineResult result = new OqsEngineResult(ResultStatus.OriginStatus.UNREPLACE, String.format("The entity(%d) was not replace successfully.", id));
        result.addHint(new Hint<Long>(id));
        return result;
    }

    public static OqsEngineResult unDeleted(long id) {
        OqsEngineResult result = new OqsEngineResult(ResultStatus.OriginStatus.UNDELETED, String.format("The entity(%d) was not deleted successfully.", id));
        result.addHint(new Hint<Long>(id));
        return result;
    }

    public static OqsEngineResult fieldMust(IEntityField field) {
        OqsEngineResult result = new OqsEngineResult(ResultStatus.OriginStatus.FIELD_MUST, String.format("The field %s is required.", field.name()));
        result.addHint(new Hint<IEntityField>(field));
        return result;
    }

    public static OqsEngineResult fieldTooLong(IEntityField field) {
        OqsEngineResult result = new OqsEngineResult(ResultStatus.OriginStatus.FIELD_TOO_LONG, String.format("Field %s is too long. The maximum allowed length is %d.", field.name(), field.config().getLen()));
        result.addHint(new Hint<IEntityField>(field));
        return result;
    }

    public static OqsEngineResult fieldHighPrecision(IEntityField field) {
        OqsEngineResult result = new OqsEngineResult(ResultStatus.OriginStatus.FIELD_HIGH_PRECISION, String.format("Field %s is too precise. The maximum accuracy allowed is %d.", field.name(), field.config().getPrecision()));
        result.addHint(new Hint<IEntityField>(field));
        return result;
    }

    public static OqsEngineResult fieldNonExist(IEntityField field) {
        OqsEngineResult result = new OqsEngineResult(ResultStatus.OriginStatus.FIELD_NON_EXISTENT, String.format("The field %s does not exist.", field.name()));
        result.addHint(new Hint<IEntityField>(field));
        return result;
    }

    public static OqsEngineResult notExistMeta() {
        return new OqsEngineResult(ResultStatus.OriginStatus.NOT_EXIST_META, "Unexpected meta information.");
    }

    public static OqsEngineResult notExistMeta(EntityClassRef ref) {
        OqsEngineResult result = ref.getProfile() != null ? new OqsEngineResult(ResultStatus.OriginStatus.NOT_EXIST_META, String.format("Meta message %s-%s does not exist.", ref.getCode(), ref.getProfile())) : new OqsEngineResult(ResultStatus.OriginStatus.NOT_EXIST_META, String.format("Meta message %s does not exist.", ref.getCode()));
        result.addHint(new Hint<EntityClassRef>(ref));
        return result;
    }

    private OqsEngineResult(Throwable ex) {
        this.ex = ex;
        this.resultStatus = ResultStatus.OriginStatus.PANIC;
        this.message = ex.getMessage();
    }

    public ResultStatus.OriginStatus getResultStatus() {
        return this.resultStatus;
    }

    public Throwable getEx() {
        return this.ex;
    }

    private OqsEngineResult(ResultStatus.OriginStatus resultStatus, String message) {
        this(resultStatus, null, message);
    }

    private OqsEngineResult(ResultStatus.OriginStatus resultStatus, V value, String message) {
        this.resultStatus = resultStatus;
        this.message = message;
        this.value = value;
    }

    public OqsEngineResult copy(Object value) {
        return new OqsEngineResult<Object>(this.resultStatus, value, this.message);
    }

    public OqsEngineResult addHint(Hint hint) {
        if (hint == null) {
            return this;
        }
        if (this.hints == null) {
            this.hints = new LinkedList<Hint>();
        }
        this.hints.add(hint);
        if (ResultStatus.OriginStatus.SUCCESS == this.resultStatus) {
            this.resultStatus = ResultStatus.OriginStatus.HALF_SUCCESS;
        }
        return this;
    }

    public OqsEngineResult addHints(Collection<Hint> hints) {
        if (hints == null || hints.isEmpty()) {
            return this;
        }
        if (this.hints == null) {
            this.hints = new LinkedList<Hint>();
        }
        this.hints.addAll(hints);
        if (ResultStatus.OriginStatus.SUCCESS == this.resultStatus) {
            this.resultStatus = ResultStatus.OriginStatus.HALF_SUCCESS;
        }
        return this;
    }

    public boolean isSuccess() {
        return ResultStatus.OriginStatus.SUCCESS == this.resultStatus || ResultStatus.OriginStatus.HALF_SUCCESS == this.resultStatus;
    }

    public boolean isHalfSuccess() {
        return ResultStatus.OriginStatus.HALF_SUCCESS == this.resultStatus;
    }

    public boolean isPanic() {
        return ResultStatus.OriginStatus.PANIC == this.resultStatus;
    }

    public void act() throws Exception {
        this.act(new OqsEngineReusltAction());
    }

    public <T> Optional<T> act(OqsEngineReusltAction<T, V> action) {
        Optional<T> value;
        if (this.hints == null) {
            this.hints = new LinkedList<Hint>();
        }
        switch (this.resultStatus) {
            case SUCCESS: {
                value = action.success(Optional.ofNullable(this.value), this.hints);
                break;
            }
            case HALF_SUCCESS: {
                value = action.halfSuccess(Optional.ofNullable(this.value), this.hints);
                break;
            }
            case CONFLICT: {
                value = action.conflict(Optional.ofNullable(this.message), this.hints);
                break;
            }
            case NOT_FOUND: {
                value = action.notFound(Optional.ofNullable(this.message), this.hints);
                break;
            }
            case UNCREATED: {
                value = action.unCreated(Optional.ofNullable(this.message), this.hints);
                break;
            }
            case UNREPLACE: {
                value = action.unReplace(Optional.ofNullable(this.message), this.hints);
                break;
            }
            case UNDELETED: {
                value = action.unDeleted(Optional.ofNullable(this.message), this.hints);
                break;
            }
            case FIELD_MUST: {
                value = action.fieldMust(Optional.ofNullable(this.message), this.hints);
                break;
            }
            case FIELD_TOO_LONG: {
                value = action.fieldTooLong(Optional.ofNullable(this.message), this.hints);
                break;
            }
            case FIELD_HIGH_PRECISION: {
                value = action.fieldHighPrecision(Optional.ofNullable(this.message), this.hints);
                break;
            }
            case FIELD_NON_EXISTENT: {
                value = action.fieldNonExist(Optional.ofNullable(this.message), this.hints);
                break;
            }
            case NOT_EXIST_META: {
                value = action.notExistMeta(Optional.ofNullable(this.message), this.hints);
                break;
            }
            case PANIC: {
                value = action.panic(this.ex, Optional.ofNullable(this.message), this.hints);
                break;
            }
            default: {
                value = action.unknown(Optional.ofNullable(this.message), this.hints);
            }
        }
        for (Hint hint : this.hints) {
            if (!hint.isException()) continue;
            throw new OqsEngineException((Throwable)hint.getValue());
        }
        return value;
    }

    public String getMessage() {
        return this.message;
    }

    public Collection<Hint> getHints() {
        if (this.hints == null) {
            this.hints = new LinkedList<Hint>();
        }
        return this.hints;
    }

    public Optional<V> getValue() {
        return Optional.ofNullable(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OqsEngineResult)) {
            return false;
        }
        OqsEngineResult result = (OqsEngineResult)o;
        return this.resultStatus == result.resultStatus;
    }

    public int hashCode() {
        return Objects.hash(this.resultStatus);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OperationResult{");
        sb.append("hints=").append(this.hints);
        sb.append(", message='").append(this.message).append('\'');
        sb.append(", resultStatus=").append(this.resultStatus);
        sb.append(", value=").append(this.value);
        sb.append('}');
        return sb.toString();
    }
}

