package com.xforceplus.ultraman.core.pojo;

import java.io.Serializable;
import java.util.Objects;

/**
 * Created by justin.xu on 03/2023.
 *
 * @since 1.8
 */
public class Hint<T> implements Serializable {

    private T value;
    private String msg;

    public Hint(T target) {
        this.value = target;
        this.msg = "";
    }

    public Hint(T value, String msg) {
        this.value = value;
        this.msg = msg;
    }

    /**
     * 判断是否一个异常提示.
     *
     * @return true 是, false不是.
     */
    public boolean isException() {
        return value != null && Exception.class.isInstance(value);
    }

    public T getValue() {
        return value;
    }

    public String getMsg() {
        return msg;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Hint)) {
            return false;
        }
        Hint<?> hint = (Hint<?>) o;
        return Objects.equals(value, hint.value) && Objects.equals(msg, hint.msg);
    }

    @Override
    public int hashCode() {
        return Objects.hash(value, msg);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("Hint{");
        sb.append("target=").append(value);
        sb.append(", msg='").append(msg).append('\'');
        sb.append('}');
        return sb.toString();
    }
}
