package com.xforceplus.ultraman.core.impl;

import com.xforceplus.ultraman.core.EntityQueryService;
import com.xforceplus.ultraman.core.pojo.OqsEngineResult;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.entity.EntityClassRef;
import com.xforceplus.ultraman.metadata.entity.IEntity;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.MasterStorage;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.table.QueryResult;
import com.xforceplus.ultraman.oqsengine.plus.storage.pojo.dto.EntityId;
import com.xforceplus.ultraman.oqsengine.plus.storage.pojo.dto.select.SelectConfig;

import javax.annotation.Resource;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;

/**
 * Created by justin.xu on 03/2023.
 *
 * @since 1.8
 */
public class EntityQueryServiceImpl implements EntityQueryService {

    @Resource
    private MasterStorage masterStorage;

    @Resource
    private EntityClassEngine engine;

    public EntityQueryServiceImpl(MasterStorage masterStorage, EntityClassEngine engine) {
        this.masterStorage = masterStorage;
        this.engine = engine;
    }

//    @Override
//    public OqsEngineResult<QueryResult> selectOne(long id, EntityClassRef entityClassRef) {
//        Optional<IEntityClass> entityClassOp =
//                engine.load(Long.toString(entityClassRef.getId()), entityClassRef.getProfile());
//
//        if (entityClassOp.isPresent()) {
//            EntityId entityId =
//                    EntityId.build(id, entityClassOp.get());
//            try {
//                Optional<QueryResult> entityOptional =
//                        masterStorage.selectOne(entityId);
//
//                if (entityOptional.isPresent()) {
//                    return OqsEngineResult.success(entityOptional.get());
//                }
//                return OqsEngineResult.elevateFailed();
//            } catch (SQLException throwables) {
//                return OqsEngineResult.elevateFailed(throwables.getMessage());
//            }
//        }
//
//        return OqsEngineResult.elevateFailed("entityClass load failed.");
//    }

//    @Override
//    public OqsEngineResult<Collection<QueryResult>> selectMultiple(long[] ids, EntityClassRef entityClassRef) {
//        Optional<IEntityClass> entityClassOp =
//                engine.load(Long.toString(entityClassRef.getId()), entityClassRef.getProfile());
//
//        if (entityClassOp.isPresent()) {
//            EntityId[] entityIds =
//                    EntityId.build(ids, entityClassOp.get());
//            try {
//                Collection<QueryResult> entities =
//                        masterStorage.selectMultiple(entityIds);
//
//                if (entities.size() > 0) {
//                    return OqsEngineResult.success(entities);
//                }
//                return OqsEngineResult.elevateFailed("query result is empty");
//            } catch (SQLException throwables) {
//                return OqsEngineResult.elevateFailed(throwables.getMessage());
//            }
//            //return OqsEngineResult.elevateFailed();
//        }
//
//        return OqsEngineResult.elevateFailed("entityClass load failed.");
//    }

    @Override
    public OqsEngineResult<Collection<QueryResult>> selectByConditions(SelectConfig selectConfig,
                                                                   EntityClassRef entityClassRef) {
        Optional<IEntityClass> entityClassOp =
                engine.load(Long.toString(entityClassRef.getId()), entityClassRef.getProfile());

        if (entityClassOp.isPresent()) {
            try {
                Collection<QueryResult> entities =
                        masterStorage.selectEntities(selectConfig, entityClassOp.get());

                return OqsEngineResult.success(entities);
            } catch (SQLException throwables) {
                return OqsEngineResult.elevateFailed(throwables.getMessage());
            }
        }
        return OqsEngineResult.elevateFailed("entityClass load failed.");
    }

    @Override
    public OqsEngineResult<Long> count(SelectConfig selectConfig, EntityClassRef entityClassRef) {
        return null;
    }

    @Override
    public OqsEngineResult<Collection<QueryResult>> search(SelectConfig config) {
        return null;
    }
}
