package com.xforceplus.ultraman.core.status;

/**
 * OQS状态列表.
 *
 * @author dongbin
 * @version 0.1 2022/6/1 13:01
 * @since 1.8
 */
public enum State {
    // 未知,不应该产生.
    UNKNOWN(0),
    // 非只读,正常状态.
    NORMAL(1),
    // CDC心跳失败.
    CDC_HEARTBEAT(2),
    // 未同步的提交号过多.
    UNCOMMIT_TOO_MUCH(3),
    // CDC离线.
    CDC_UNCONNECTED(4);

    private final int symbol;

    State(int symbol) {
        this.symbol = symbol;
    }

    public int getSymbol() {
        return symbol;
    }

    /**
     * 解析实例.
     *
     * @param value 目标值.
     * @return 目标值表示的实例.
     */
    public static State getInstance(int value) {
        for (State rease : State.values()) {
            if (rease.getSymbol() == value) {
                return rease;
            }
        }

        return UNKNOWN;
    }
}
