//package com.xforceplus.ultraman.core.status.checker;
//
//import com.xforceplus.ultraman.core.status.StateChecker;
//import com.xforceplus.ultraman.oqsengine.core.service.status.State;
//import com.xforceplus.ultraman.oqsengine.inner.pojo.cdc.enums.CDCStatus;
//import com.xforceplus.ultraman.oqsengine.inner.pojo.cdc.metrics.CDCMetrics;
//import com.xforceplus.ultraman.oqsengine.status.CDCStatusService;
//import com.xforceplus.ultraman.oqsengine.status.CommitIdStatusService;
//
//import javax.annotation.Resource;
//import java.util.Optional;
//
///**
// * 一个默认的状态检查者.
// * 会检查如下状态.
// * 1. CDC是否在线.
// * 2. CDC心跳是否正常.
// * 3. 未同步提交号是否超过阀值.
// *
// * @author dongbin
// * @version 0.1 2022/6/1 16:17
// * @since 1.8
// */
//public class DefaultStateChecker implements StateChecker {
//
//    @Resource
//    private CDCStatusService cdcStatusService;
//
//    @Resource
//    private CommitIdStatusService commitIdStatusService;
//
//    /**
//     * 可以接受的最大未同步提交号数量.
//     */
//    private long allowMaxUnSyncCommitIdSize = 2000;
//
//    public DefaultStateChecker() {
//    }
//
//    public DefaultStateChecker(long allowMaxUnSyncCommitIdSize) {
//        this.allowMaxUnSyncCommitIdSize = allowMaxUnSyncCommitIdSize;
//    }
//
//    @Override
//    public State check() {
//        /*
//         * 几种情况会认为是CDC同步停止.
//         * 1. CDC状态非正常.
//         * 2. CDC心跳.
//         * 3. 未同步提交号达到阀值.
//         */
//        if (!cdcStatusService.isAlive()) {
//            return State.CDC_HEARTBEAT;
//        }
//
//        long uncommentSize = commitIdStatusService.size();
//        if (uncommentSize > allowMaxUnSyncCommitIdSize) {
//            return State.UNCOMMIT_TOO_MUCH;
//        }
//
//        /*
//         * 检查CDC指标.
//         */
//        Optional<CDCMetrics> ackOp = cdcStatusService.get();
//        if (ackOp.isPresent()) {
//            CDCMetrics cdcMetrics = ackOp.get();
//            CDCStatus cdcStatus = cdcMetrics.getCdcStatus();
//            if (CDCStatus.CONNECTED != cdcStatus) {
//                return State.CDC_UNCONNECTED;
//            }
//        }
//
//        return State.NORMAL;
//    }
//}
