package com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor;


import com.xforceplus.ultraman.oqsengine.plus.common.executor.Executor;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.MasterStorageEntity;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

/**
 * Created by justin.xu on 03/2023.
 *
 * @since 1.8
 */
public class DeleteExecutor extends AbstractMasterTaskExecutor<List<MasterStorageEntity>, boolean[]> {

    public DeleteExecutor(Connection connection, long timeout) {
        super(connection, timeout);
    }

    public static Executor<List<MasterStorageEntity>, boolean[]> build(
            Connection connection, long timeout) {
        return new DeleteExecutor(connection, timeout);
    }

    @Override
    public boolean[] execute(List<MasterStorageEntity> masterStorageEntities) throws SQLException {

        boolean isBatch = masterStorageEntities.size() > 1;

        try (Statement st = getConnection().createStatement()) {
            checkTimeout(st);
            if (isBatch) {
                for (MasterStorageEntity entity : masterStorageEntities) {
                    String sql = buildSql(entity);
                    st.addBatch(sql);
                }
                return executedUpdate(st, true);
            } else {
                MasterStorageEntity entity = masterStorageEntities.get(0);

                String sql = buildSql(entity);

                return new boolean[] {st.executeUpdate(sql) > 0};
            }
        }
    }

    protected String buildSql(MasterStorageEntity masterStorageEntity) {

        StringBuilder base = new StringBuilder();

        base.append("DELETE FROM ").append(masterStorageEntity.getTableName());
        base.append(" ").append("where id").append("=").append(masterStorageEntity.getSystemColumn().getId());

        return base.toString();
    }
}
