/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.master.mysql;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.metadata.constants.SystemField;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.EntityClassRef;
import com.xforceplus.ultraman.metadata.entity.IEntity;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.entity.IEntityValue;
import com.xforceplus.ultraman.metadata.values.DateTimeValue;
import com.xforceplus.ultraman.metadata.values.IValue;
import com.xforceplus.ultraman.oqsengine.plus.common.iterator.DataIterator;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.MasterQueryResult;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.MasterStorageEntity;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.MasterStorage;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor.ConditionQueryExecutor;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor.CreateExecutor;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor.DeleteExecutor;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor.UpdateExecutor;
import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.Operation;
import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.table.QueryResult;
import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.table.SystemColumn;
import com.xforceplus.ultraman.oqsengine.plus.storage.pojo.dto.EntityPackage;
import com.xforceplus.ultraman.oqsengine.plus.storage.pojo.dto.select.SelectConfig;
import com.xforceplus.ultraman.sdk.core.event.EntityAfterCreate;
import com.xforceplus.ultraman.sdk.core.event.EntityAfterDelete;
import com.xforceplus.ultraman.sdk.core.event.EntityAfterMultiCreate;
import com.xforceplus.ultraman.sdk.core.event.EntityAfterMultiDelete;
import com.xforceplus.ultraman.sdk.core.event.EntityAfterMultiUpdate;
import com.xforceplus.ultraman.sdk.core.event.EntityAfterUpdate;
import com.xforceplus.ultraman.sdk.core.event.EntityBeforeCreate;
import com.xforceplus.ultraman.sdk.core.event.EntityBeforeDelete;
import com.xforceplus.ultraman.sdk.core.event.EntityBeforeMultiCreate;
import com.xforceplus.ultraman.sdk.core.event.EntityBeforeMultiDelete;
import com.xforceplus.ultraman.sdk.core.event.EntityBeforeMultiUpdate;
import com.xforceplus.ultraman.sdk.core.event.EntityBeforeUpdate;
import com.xforceplus.ultraman.sdk.core.event.EntityChanged;
import com.xforceplus.ultraman.sdk.core.utils.MasterStorageHelper;
import com.xforceplus.ultraman.sdk.infra.event.EventPublisher;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.calcite.adapter.jdbc.JdbcSchema;
import org.apache.calcite.config.Lex;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.plan.Context;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.RelBuilder;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class SQLMasterStorage
implements MasterStorage {
    private static final Logger log = LoggerFactory.getLogger(SQLMasterStorage.class);
    private PlatformTransactionManager manager;
    private TransactionTemplate template;
    private JdbcTemplate jdbcTemplate;
    private DataSource masterDataSource;
    private EntityClassEngine engine;
    private ObjectMapper objectMapper;
    private ExecutorService masterDispatcher;
    private SchemaPlus rootSchema;
    @Autowired(required=false)
    public EventPublisher publisher;
    private FrameworkConfig frameworkConfig;
    private Map<String, Schema> mapping = new ConcurrentHashMap<String, Schema>();
    private long queryTimeout;
    private long refreshTime;
    private long initTime;
    private ScheduledExecutorService scheduler;

    public SQLMasterStorage(PlatformTransactionManager manager, DataSource masterDataSource, ObjectMapper objectMapper, ExecutorService masterDispatcher, EntityClassEngine engine, long queryTimeout, long refreshTime, long initTime) {
        this.manager = manager;
        this.masterDataSource = masterDataSource;
        this.objectMapper = objectMapper;
        this.masterDispatcher = masterDispatcher;
        this.queryTimeout = queryTimeout;
        this.engine = engine;
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.refreshTime = refreshTime;
        this.initTime = initTime;
        this.template = new TransactionTemplate(manager);
        this.jdbcTemplate = new JdbcTemplate(masterDataSource);
        this.prepareSchema();
    }

    private void prepareSchema() {
        this.rootSchema = CalciteSchema.createRootSchema((boolean)true, (boolean)false).plus();
        JdbcSchema oqs = JdbcSchema.create((SchemaPlus)this.rootSchema, (String)"oqs", (DataSource)this.masterDataSource, null, null);
        this.rootSchema.add("oqs", (Schema)oqs);
        this.mapping.put("oqs", (Schema)oqs);
        this.scheduler.scheduleAtFixedRate(() -> {
            Set tableNames = oqs.getTableNames();
            log.info("Refresh JDBC schema");
        }, this.initTime, this.refreshTime, TimeUnit.SECONDS);
        Frameworks.ConfigBuilder configBuilder = Frameworks.newConfigBuilder();
        this.frameworkConfig = configBuilder.defaultSchema(this.rootSchema).parserConfig(SqlParser.config().withLex(Lex.MYSQL).withCaseSensitive(false)).context(new Context(){

            public <C> @Nullable C unwrap(Class<C> aClass) {
                if (aClass == RelBuilder.Config.class) {
                    return (C)RelBuilder.Config.DEFAULT.withSimplify(false);
                }
                return null;
            }
        }).build();
    }

    private void checkId(IEntity entity) throws SQLException {
        if (entity.id() == 0L) {
            throw new SQLException("Invalid entity`s id.");
        }
    }

    public boolean build(IEntity entity, IEntityClass entityClass, Map<String, Object> context) throws SQLException {
        EntityClassGroup group = this.engine.describe(entityClass, entityClass.profile());
        return this.writeProcessing(entity, group, Operation.BUILD, context);
    }

    public void build(EntityPackage entityPackage, Map<String, Object> context) throws SQLException {
        this.packageWriteProcessing(entityPackage, Operation.BUILD, context);
    }

    public boolean replace(IEntity entity, IEntityClass entityClass, Map<String, Object> context) throws SQLException {
        EntityClassGroup group = this.engine.describe(entityClass, entityClass.profile());
        return this.writeProcessing(entity, group, Operation.REPLACE, context);
    }

    public void replace(EntityPackage entityPackage, Map<String, Object> context) throws SQLException {
        this.packageWriteProcessing(entityPackage, Operation.REPLACE, context);
    }

    public boolean delete(IEntity entity, IEntityClass entityClass, Map<String, Object> context) throws SQLException {
        EntityClassGroup group = this.engine.describe(entityClass, entityClass.profile());
        return this.writeProcessing(entity, group, Operation.DELETE, context);
    }

    public void delete(EntityPackage entityPackage, Map<String, Object> context) throws SQLException {
        this.packageWriteProcessing(entityPackage, Operation.DELETE, context);
    }

    @Override
    public DataIterator<MasterStorageEntity> iterator(IEntityClass entityClass, long startTime, long endTime, long lastId, boolean useSelfEntityClass) throws SQLException {
        return null;
    }

    @Override
    public DataIterator<MasterStorageEntity> iterator(IEntityClass entityClass, long startTime, long endTime, long lastId, int size, boolean useSelfEntityClass) throws SQLException {
        return null;
    }

    public Collection<QueryResult> selectEntities(final SelectConfig selectConfig, final IEntityClass entityClass) throws SQLException {
        selectConfig.setScheme(this.mapping.get("oqs"));
        return (Collection)this.template.execute(status -> (Collection)this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Collection<QueryResult>>(){

            public Collection<QueryResult> doInConnection(Connection conn) throws SQLException, DataAccessException {
                MasterQueryResult result = null;
                result = (MasterQueryResult)ConditionQueryExecutor.build(conn, SQLMasterStorage.this.queryTimeout, SQLMasterStorage.this.masterDataSource, SQLMasterStorage.this.engine.describe(entityClass, selectConfig.getProfile()), SQLMasterStorage.this.frameworkConfig).execute((Object)selectConfig);
                ArrayList<QueryResult> entities = new ArrayList<QueryResult>();
                if (!result.getValues().isEmpty()) {
                    List<String> fieldsNames = result.getFieldsNames();
                    for (List<Object> value : result.getValues()) {
                        QueryResult queryResult = new QueryResult(null);
                        ArrayList<QueryResult.SelectItem> items = new ArrayList<QueryResult.SelectItem>();
                        queryResult.setSelectItems(items);
                        for (int i = 0; i < fieldsNames.size(); ++i) {
                            String field = fieldsNames.get(i);
                            items.add(new QueryResult.SelectItem(field, field, value.get(i)));
                        }
                        entities.add(queryResult);
                    }
                }
                return entities;
            }
        }));
    }

    private boolean checkResult(boolean[] rs) {
        if (null == rs) {
            return false;
        }
        for (boolean r : rs) {
            if (r) continue;
            return false;
        }
        return true;
    }

    private void publishAfterCreateEvent(IEntity entity, EntityClassGroup entityClassGroup, Map<String, Object> context) {
        if (this.publisher != null) {
            try {
                IEntityClass entityClass = entityClassGroup.getEntityClass();
                long id = entity.id();
                String code = entityClass.code();
                this.publisher.publishEvent((Object)new EntityAfterCreate(code, Long.valueOf(id), this.toMap(entity), false, context));
            }
            catch (Throwable throwable) {
                log.error("", throwable);
            }
        }
    }

    private void publishBeforeCreateEvent(IEntity entity, EntityClassGroup entityClassGroup, Map<String, Object> context) {
        if (this.publisher != null) {
            try {
                IEntityClass entityClass = entityClassGroup.getEntityClass();
                long id = entity.id();
                String code = entityClass.code();
                this.publisher.publishEvent((Object)new EntityBeforeCreate(code, id, false, this.toMap(entity), context));
            }
            catch (Throwable throwable) {
                log.error("", throwable);
            }
        }
    }

    private void publishAfterUpdateEvent(IEntity entity, EntityClassGroup entityClassGroup, Map<String, Object> context) {
        if (this.publisher != null) {
            try {
                IEntityClass entityClass = entityClassGroup.getEntityClass();
                long id = entity.id();
                String code = entityClass.code();
                this.publisher.publishEvent((Object)new EntityAfterUpdate(code, Long.valueOf(id), Collections.emptyMap(), this.toMap(entity), false, context));
            }
            catch (Throwable throwable) {
                log.error("", throwable);
            }
        }
    }

    private void publishBeforeUpdateEvent(IEntity entity, EntityClassGroup entityClassGroup, Map<String, Object> context) {
        if (this.publisher != null) {
            try {
                IEntityClass entityClass = entityClassGroup.getEntityClass();
                long id = entity.id();
                String code = entityClass.code();
                this.publisher.publishEvent((Object)new EntityBeforeUpdate(code, id, false, this.toMap(entity), context));
            }
            catch (Throwable throwable) {
                log.error("", throwable);
            }
        }
    }

    private void publishAfterDeleteEvent(IEntity entity, EntityClassGroup entityClassGroup, Map<String, Object> context) {
        if (this.publisher != null) {
            try {
                IEntityClass entityClass = entityClassGroup.getEntityClass();
                long id = entity.id();
                String code = entityClass.code();
                this.publisher.publishEvent((Object)new EntityAfterDelete(code, Long.valueOf(id), Collections.emptyMap(), false, context));
            }
            catch (Throwable throwable) {
                log.error("", throwable);
            }
        }
    }

    private void publishBeforeDeleteEvent(IEntity entity, EntityClassGroup entityClassGroup, Map<String, Object> context) {
        if (this.publisher != null) {
            try {
                IEntityClass entityClass = entityClassGroup.getEntityClass();
                long id = entity.id();
                String code = entityClass.code();
                this.publisher.publishEvent((Object)new EntityBeforeDelete(code, id, false, context));
            }
            catch (Throwable throwable) {
                log.error("", throwable);
            }
        }
    }

    private void publishBeforeMultiCreateEvent(EntityPackage entityPackage, Map<String, Object> context) {
        Map<Tuple2, List<Map.Entry>> grouped = entityPackage.stream().collect(Collectors.groupingBy(x -> Tuple.of((Object)((IEntityClass)x.getValue()).id(), (Object)((IEntityClass)x.getValue()).code())));
        grouped.forEach((k, v) -> {
            ArrayList bodies = new ArrayList();
            v.stream().forEach(x -> {
                IEntityClass targetEntityClass = (IEntityClass)x.getValue();
                if (this.publisher != null) {
                    Map<String, Object> body = this.toMap((IEntity)x.getKey());
                    bodies.add(body);
                    this.publisher.publishEvent((Object)new EntityBeforeCreate(targetEntityClass.code(), ((IEntity)x.getKey()).id(), true, body, context));
                }
            });
            if (!bodies.isEmpty() && this.publisher != null) {
                this.publisher.publishEvent((Object)new EntityBeforeMultiCreate((String)k._2, bodies, context));
            }
        });
    }

    private void publishAfterMultiCreateEvent(EntityPackage entityPackage, Map<String, Object> context) {
        Map<Tuple2, List<Map.Entry>> grouped = entityPackage.stream().collect(Collectors.groupingBy(x -> Tuple.of((Object)((IEntityClass)x.getValue()).id(), (Object)((IEntityClass)x.getValue()).code())));
        grouped.forEach((k, v) -> {
            ArrayList bodies = new ArrayList();
            v.stream().forEach(x -> {
                IEntityClass targetEntityClass = (IEntityClass)x.getValue();
                if (this.publisher != null) {
                    Map<String, Object> body = this.toMap((IEntity)x.getKey());
                    bodies.add(body);
                    this.publisher.publishEvent((Object)new EntityAfterCreate(targetEntityClass.code(), Long.valueOf(((IEntity)x.getKey()).id()), body, true, context));
                }
            });
            if (!bodies.isEmpty() && this.publisher != null) {
                this.publisher.publishEvent((Object)new EntityAfterMultiCreate((String)k._2, bodies, context));
            }
        });
    }

    private void publishBeforeMultiUpdateEvent(EntityPackage entityPackage, Map<String, Object> context) {
        Map<Tuple2, List<Map.Entry>> grouped = entityPackage.stream().collect(Collectors.groupingBy(x -> Tuple.of((Object)((IEntityClass)x.getValue()).id(), (Object)((IEntityClass)x.getValue()).code())));
        grouped.forEach((k, v) -> {
            ArrayList bodies = new ArrayList();
            v.stream().forEach(x -> {
                IEntityClass targetEntityClass = (IEntityClass)x.getValue();
                if (this.publisher != null) {
                    Map<String, Object> body = this.toMap((IEntity)x.getKey());
                    bodies.add(body);
                    this.publisher.publishEvent((Object)new EntityBeforeUpdate(targetEntityClass.code(), ((IEntity)x.getKey()).id(), true, body, context));
                }
            });
            if (!bodies.isEmpty() && this.publisher != null) {
                this.publisher.publishEvent((Object)new EntityBeforeMultiUpdate((String)k._2, bodies, context));
            }
        });
    }

    private void publishAfterMultiUpdateEvent(EntityPackage entityPackage, Map<String, Object> context) {
        Map<Tuple2, List<Map.Entry>> grouped = entityPackage.stream().collect(Collectors.groupingBy(x -> Tuple.of((Object)((IEntityClass)x.getValue()).id(), (Object)((IEntityClass)x.getValue()).code())));
        grouped.forEach((k, v) -> {
            ArrayList bodies = new ArrayList();
            v.stream().forEach(x -> {
                IEntityClass targetEntityClass = (IEntityClass)x.getValue();
                if (this.publisher != null) {
                    Map<String, Object> body = this.toMap((IEntity)x.getKey());
                    bodies.add(body);
                    this.publisher.publishEvent((Object)new EntityAfterUpdate(targetEntityClass.code(), Long.valueOf(((IEntity)x.getKey()).id()), Collections.emptyMap(), body, true, context));
                }
            });
            if (!bodies.isEmpty() && this.publisher != null) {
                this.publisher.publishEvent((Object)new EntityAfterMultiUpdate((String)k._2, bodies.stream().map(x -> Tuple.of(Collections.emptyMap(), (Object)x)).collect(Collectors.toList()), context));
            }
        });
    }

    private void publishAfterMultiDeletedEvent(EntityPackage entityPackage, Map<String, Object> context) {
        Map<Tuple2, List<Map.Entry>> grouped = entityPackage.stream().collect(Collectors.groupingBy(x -> Tuple.of((Object)((IEntityClass)x.getValue()).id(), (Object)((IEntityClass)x.getValue()).code())));
        grouped.forEach((k, v) -> {
            ArrayList bodies = new ArrayList();
            v.stream().forEach(x -> {
                IEntityClass targetEntityClass = (IEntityClass)x.getValue();
                if (this.publisher != null) {
                    Map<String, Object> body = this.toMap((IEntity)x.getKey());
                    bodies.add(body);
                    this.publisher.publishEvent((Object)new EntityAfterDelete(targetEntityClass.code(), Long.valueOf(((IEntity)x.getKey()).id()), Collections.emptyMap(), true, context));
                }
            });
            if (!bodies.isEmpty() && this.publisher != null) {
                this.publisher.publishEvent((Object)new EntityAfterMultiDelete((String)k._2, bodies, context));
            }
        });
    }

    private void publishBeforeMultiDeleteEvent(EntityPackage entityPackage, Map<String, Object> context) {
        Map<Tuple2, List<Map.Entry>> grouped = entityPackage.stream().collect(Collectors.groupingBy(x -> Tuple.of((Object)((IEntityClass)x.getValue()).id(), (Object)((IEntityClass)x.getValue()).code())));
        grouped.forEach((k, v) -> {
            ArrayList bodies = new ArrayList();
            v.stream().forEach(x -> {
                IEntityClass targetEntityClass = (IEntityClass)x.getValue();
                if (this.publisher != null) {
                    bodies.add(((IEntity)x.getKey()).id());
                    this.publisher.publishEvent((Object)new EntityBeforeDelete(targetEntityClass.code(), ((IEntity)x.getKey()).id(), true, context));
                }
            });
            if (!bodies.isEmpty() && this.publisher != null) {
                this.publisher.publishEvent((Object)new EntityBeforeMultiDelete((String)k._2, bodies, context));
            }
        });
    }

    private Map<String, Object> toMap(IEntity entity) {
        IEntityValue iEntityValue = entity.entityValue();
        HashMap<String, Object> payload = new HashMap<String, Object>();
        if (iEntityValue != null) {
            iEntityValue.values().forEach(x -> {
                String name = x.getField().name();
                Object value = x.getValue();
                payload.put(name, value);
            });
        }
        return payload;
    }

    private boolean writeProcessing(final IEntity entity, final EntityClassGroup entityClass, final Operation op, final Map<String, Object> context) throws SQLException {
        this.checkId(entity);
        boolean result = (Boolean)this.template.execute(status -> (Boolean)this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Boolean>(){

            public Boolean doInConnection(Connection con) throws SQLException, DataAccessException {
                boolean[] rs;
                List masterStorageEntities = SQLMasterStorage.this.toMasterStorageEntities(entityClass, entity, op);
                switch (op) {
                    case BUILD: {
                        SQLMasterStorage.this.publishBeforeCreateEvent(entity, entityClass, context);
                        rs = (boolean[])CreateExecutor.build(con, SQLMasterStorage.this.queryTimeout).execute((Object)masterStorageEntities);
                        SQLMasterStorage.this.publishAfterCreateEvent(entity, entityClass, context);
                        break;
                    }
                    case REPLACE: {
                        SQLMasterStorage.this.publishBeforeUpdateEvent(entity, entityClass, context);
                        rs = (boolean[])UpdateExecutor.build(con, SQLMasterStorage.this.queryTimeout).execute((Object)masterStorageEntities);
                        SQLMasterStorage.this.publishAfterUpdateEvent(entity, entityClass, context);
                        break;
                    }
                    case DELETE: {
                        SQLMasterStorage.this.publishBeforeDeleteEvent(entity, entityClass, context);
                        rs = (boolean[])DeleteExecutor.build(con, SQLMasterStorage.this.queryTimeout).execute((Object)masterStorageEntities);
                        SQLMasterStorage.this.publishAfterDeleteEvent(entity, entityClass, context);
                        break;
                    }
                    default: {
                        rs = null;
                    }
                }
                if (SQLMasterStorage.this.publisher != null) {
                    Instant instant = LocalDateTime.now().atZone(DateTimeValue.ZONE_ID).toInstant();
                    long currentTime = instant.toEpochMilli();
                    EntityClassRef entityClassRef = entity.entityClassRef();
                    SQLMasterStorage.this.publisher.publishEvent((Object)new EntityChanged(Collections.singletonList(Tuple.of((Object)entityClassRef.getProfile(), (Object)entityClassRef.getId())), currentTime));
                }
                return SQLMasterStorage.this.checkResult(rs);
            }
        }));
        if (result) {
            entity.neat();
        }
        return result;
    }

    private void packageWriteProcessing(final EntityPackage entityPackage, final Operation op, final Map<String, Object> context) throws SQLException {
        this.template.executeWithoutResult(status -> this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Boolean>(){

            public Boolean doInConnection(Connection con) throws SQLException, DataAccessException {
                ArrayList executionPackages = new ArrayList();
                entityPackage.stream().forEach(er -> {
                    EntityClassGroup group = SQLMasterStorage.this.engine.describe((IEntityClass)er.getValue(), ((IEntityClass)er.getValue()).profile());
                    executionPackages.addAll(SQLMasterStorage.this.toMasterStorageEntities(group, (IEntity)er.getKey(), op));
                });
                List executionPart = Lists.partition(executionPackages, (int)EntityPackage.MAX_SIZE);
                if (SQLMasterStorage.this.publisher != null) {
                    switch (op) {
                        case BUILD: {
                            SQLMasterStorage.this.publishBeforeMultiCreateEvent(entityPackage, context);
                            break;
                        }
                        case REPLACE: {
                            SQLMasterStorage.this.publishBeforeMultiUpdateEvent(entityPackage, context);
                            break;
                        }
                        case DELETE: {
                            SQLMasterStorage.this.publishBeforeMultiDeleteEvent(entityPackage, context);
                        }
                    }
                }
                for (List parts : executionPart) {
                    switch (op) {
                        case BUILD: {
                            CreateExecutor.build(con, SQLMasterStorage.this.queryTimeout).execute((Object)parts);
                            break;
                        }
                        case REPLACE: {
                            UpdateExecutor.build(con, SQLMasterStorage.this.queryTimeout).execute((Object)parts);
                            break;
                        }
                        case DELETE: {
                            DeleteExecutor.build(con, SQLMasterStorage.this.queryTimeout).execute((Object)parts);
                            break;
                        }
                    }
                }
                if (SQLMasterStorage.this.publisher != null) {
                    List list = entityPackage.stream().map(entry -> {
                        String profile = ((IEntity)entry.getKey()).entityClassRef().getProfile();
                        long entityClassId = ((IEntity)entry.getKey()).entityClassRef().getId();
                        return Tuple.of((Object)profile, (Object)entityClassId);
                    }).collect(Collectors.toList());
                    Instant instant = LocalDateTime.now().atZone(DateTimeValue.ZONE_ID).toInstant();
                    long currentTime = instant.toEpochMilli();
                    SQLMasterStorage.this.publisher.publishEvent((Object)new EntityChanged(list, currentTime));
                }
                switch (op) {
                    case BUILD: {
                        SQLMasterStorage.this.publishAfterMultiCreateEvent(entityPackage, context);
                        break;
                    }
                    case REPLACE: {
                        SQLMasterStorage.this.publishAfterMultiUpdateEvent(entityPackage, context);
                        break;
                    }
                    case DELETE: {
                        SQLMasterStorage.this.publishAfterMultiDeletedEvent(entityPackage, context);
                    }
                }
                return true;
            }
        }));
    }

    private List<MasterStorageEntity.TypedStorageValue> extractBocpSystemField(EntityClassGroup group, IEntity entity) {
        Collection allFields = group.getAllFields();
        ArrayList<MasterStorageEntity.TypedStorageValue> values = new ArrayList<MasterStorageEntity.TypedStorageValue>();
        for (IEntityField entityField : allFields) {
            Optional valueOp;
            Optional<SystemField> systemField = Arrays.stream(SystemField.values()).filter(x -> x.getName().equalsIgnoreCase(entityField.name())).findFirst();
            if (!systemField.isPresent() || !(valueOp = entity.entityValue().getValue(entityField)).isPresent()) continue;
            values.add(new MasterStorageEntity.TypedStorageValue(entityField, ((IValue)valueOp.get()).storageValue()));
        }
        return values;
    }

    private MasterStorageEntity merge(MasterStorageEntity entity, List<MasterStorageEntity.TypedStorageValue> values) {
        MasterStorageEntity masterStorageEntity = new MasterStorageEntity();
        masterStorageEntity.setTableName(entity.getTableName());
        masterStorageEntity.setBusinessDynamicFields(entity.getBusinessDynamicFields());
        masterStorageEntity.setSystemColumn(entity.getSystemColumn());
        ArrayList<MasterStorageEntity.TypedStorageValue> mergedValues = new ArrayList<MasterStorageEntity.TypedStorageValue>(values);
        Optional.ofNullable(entity.getBusinessStaticFields()).orElseGet(Collections::emptyList).stream().filter(x -> values.stream().noneMatch(v -> v.getEntityField() == x.getEntityField())).forEach(x -> mergedValues.add((MasterStorageEntity.TypedStorageValue)x));
        masterStorageEntity.setBusinessStaticFields(mergedValues);
        masterStorageEntity.setBusinessDynamicFieldsRemove(entity.getBusinessDynamicFieldsRemove());
        return masterStorageEntity;
    }

    private List<MasterStorageEntity> toMasterStorageEntities(EntityClassGroup group, IEntity entity, Operation op) {
        ArrayList<MasterStorageEntity> masterStorageEntities = new ArrayList<MasterStorageEntity>();
        List<MasterStorageEntity.TypedStorageValue> values = this.extractBocpSystemField(group, entity);
        List<MasterStorageEntity> masterStorageEntity = this.toMasterStorageEntity(group.getEntityClass(), entity, op);
        masterStorageEntity.stream().map(x -> this.merge((MasterStorageEntity)x, values)).forEach(masterStorageEntities::add);
        if (!group.getFatherEntityClass().isEmpty()) {
            Collection entityClasses = group.getFatherEntityClass();
            for (IEntityClass e : entityClasses) {
                List<MasterStorageEntity> multiMaster = this.toMasterStorageEntity(e, entity, op);
                multiMaster.stream().map(x -> this.merge((MasterStorageEntity)x, values)).forEach(masterStorageEntities::add);
            }
        }
        return masterStorageEntities;
    }

    private List<MasterStorageEntity> toMasterStorageEntity(IEntityClass e, IEntity entity, Operation op) {
        Object painValues;
        Optional valueOp;
        ArrayList dynamicValues;
        ArrayList<MasterStorageEntity.TypedStorageValue> staticValues;
        SystemColumn systemColumn;
        MasterStorageEntity masterStorageEntity;
        String profile = e.realProfile();
        if (StringUtils.isEmpty((CharSequence)profile)) {
            Collection selfFields = e.selfWithIndex();
            MasterStorageEntity masterStorageEntity2 = new MasterStorageEntity();
            SystemColumn systemColumn2 = new SystemColumn();
            systemColumn2.setProfile(e.profile());
            systemColumn2.setOperateTime(entity.time());
            systemColumn2.setEntityClass(entity.entityClassRef().getId());
            systemColumn2.setId(entity.id());
            masterStorageEntity2.setSystemColumn(systemColumn2);
            masterStorageEntity2.setTableName(e.masterWriteTable());
            ArrayList<MasterStorageEntity.TypedStorageValue> staticValues2 = new ArrayList<MasterStorageEntity.TypedStorageValue>();
            if (!op.equals((Object)Operation.DELETE)) {
                ArrayList dynamicValues2 = new ArrayList();
                for (IEntityField entityField : selfFields) {
                    Optional valueOp2 = entity.entityValue().getValue(entityField);
                    if (!valueOp2.isPresent()) continue;
                    if (entityField.isDynamic()) {
                        dynamicValues2.add(valueOp2.get());
                        continue;
                    }
                    staticValues2.add(new MasterStorageEntity.TypedStorageValue(entityField, ((IValue)valueOp2.get()).storageValue()));
                }
                masterStorageEntity2.setBusinessStaticFields(staticValues2);
                Map painValues2 = MasterStorageHelper.toPainValues(dynamicValues2);
                if (op.equals((Object)Operation.REPLACE)) {
                    masterStorageEntity2.setBusinessDynamicFields(MasterStorageHelper.buildReplace((Map)painValues2));
                    masterStorageEntity2.setBusinessDynamicFieldsRemove(MasterStorageHelper.buildRemove((Map)painValues2));
                } else {
                    masterStorageEntity2.setBusinessDynamicFields(MasterStorageHelper.toBuildJson((Map)painValues2));
                }
                systemColumn2.setDeleted(false);
            } else {
                systemColumn2.setDeleted(true);
            }
            return Collections.singletonList(masterStorageEntity2);
        }
        ArrayList<MasterStorageEntity> masterStorageEntities = new ArrayList<MasterStorageEntity>();
        Collection selfFields = e.selfWithIndex();
        ArrayList<IEntityField> pureSelfFields = new ArrayList<IEntityField>();
        ArrayList<IEntityField> profileFields = new ArrayList<IEntityField>();
        for (IEntityField selfField : selfFields) {
            String realProfile = selfField.realProfile();
            if (StringUtils.isEmpty((CharSequence)realProfile)) {
                pureSelfFields.add(selfField);
                continue;
            }
            profileFields.add(selfField);
        }
        if (!pureSelfFields.isEmpty()) {
            masterStorageEntity = new MasterStorageEntity();
            systemColumn = new SystemColumn();
            systemColumn.setProfile(profile);
            systemColumn.setOperateTime(entity.time());
            systemColumn.setEntityClass(e.id());
            systemColumn.setId(entity.id());
            masterStorageEntity.setSystemColumn(systemColumn);
            masterStorageEntity.setTableName(e.masterWriteTable());
            staticValues = new ArrayList<MasterStorageEntity.TypedStorageValue>();
            if (!op.equals((Object)Operation.DELETE)) {
                dynamicValues = new ArrayList();
                for (IEntityField entityField : pureSelfFields) {
                    valueOp = entity.entityValue().getValue(entityField);
                    if (!valueOp.isPresent()) continue;
                    if (entityField.isDynamic()) {
                        dynamicValues.add(valueOp.get());
                        continue;
                    }
                    staticValues.add(new MasterStorageEntity.TypedStorageValue(entityField, ((IValue)valueOp.get()).storageValue()));
                }
                masterStorageEntity.setBusinessStaticFields(staticValues);
                painValues = MasterStorageHelper.toPainValues(dynamicValues);
                if (op.equals((Object)Operation.REPLACE)) {
                    masterStorageEntity.setBusinessDynamicFields(MasterStorageHelper.buildReplace((Map)painValues));
                    masterStorageEntity.setBusinessDynamicFieldsRemove(MasterStorageHelper.buildRemove((Map)painValues));
                } else {
                    masterStorageEntity.setBusinessDynamicFields(MasterStorageHelper.toBuildJson((Map)painValues));
                }
                systemColumn.setDeleted(false);
            } else {
                systemColumn.setDeleted(true);
            }
            masterStorageEntities.add(masterStorageEntity);
        }
        if (!profileFields.isEmpty()) {
            masterStorageEntity = new MasterStorageEntity();
            systemColumn = new SystemColumn();
            systemColumn.setProfile(e.profile());
            systemColumn.setOperateTime(entity.time());
            systemColumn.setEntityClass(e.id());
            systemColumn.setId(entity.id());
            masterStorageEntity.setSystemColumn(systemColumn);
            masterStorageEntity.setTableName(e.masterWriteTable().concat("_").concat(profile));
            staticValues = new ArrayList();
            if (!op.equals((Object)Operation.DELETE)) {
                dynamicValues = new ArrayList();
                for (IEntityField entityField : profileFields) {
                    valueOp = entity.entityValue().getValue(entityField);
                    if (!valueOp.isPresent()) continue;
                    if (entityField.isDynamic()) {
                        dynamicValues.add(valueOp.get());
                        continue;
                    }
                    staticValues.add(new MasterStorageEntity.TypedStorageValue(entityField, ((IValue)valueOp.get()).storageValue()));
                }
                masterStorageEntity.setBusinessStaticFields(staticValues);
                painValues = MasterStorageHelper.toPainValues(dynamicValues);
                if (op.equals((Object)Operation.REPLACE)) {
                    masterStorageEntity.setBusinessDynamicFields(MasterStorageHelper.buildReplace((Map)painValues));
                    masterStorageEntity.setBusinessDynamicFieldsRemove(MasterStorageHelper.buildRemove((Map)painValues));
                } else {
                    masterStorageEntity.setBusinessDynamicFields(MasterStorageHelper.toBuildJson((Map)painValues));
                }
                systemColumn.setDeleted(false);
            } else {
                systemColumn.setDeleted(true);
            }
            masterStorageEntities.add(masterStorageEntity);
        }
        return masterStorageEntities;
    }
}

