/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor;

import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.plus.common.executor.Executor;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.MasterQueryEntity;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor.AbstractMasterTaskExecutor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class MultiQueryPrimaryExecutor
extends AbstractMasterTaskExecutor<long[], Collection<MasterQueryEntity>> {
    private IEntityClass entityClass;
    private String table;
    private boolean isViewQuery;

    public MultiQueryPrimaryExecutor(Connection connection, long timeout, IEntityClass entityClass, String table, boolean isViewQuery) {
        super(connection, timeout);
        this.entityClass = entityClass;
        this.table = table;
        this.isViewQuery = isViewQuery;
    }

    public static Executor<long[], Collection<MasterQueryEntity>> build(Connection connection, long timeout, IEntityClass entityClass, String table, boolean isViewQuery) {
        return new MultiQueryPrimaryExecutor(connection, timeout, entityClass, table, isViewQuery);
    }

    public Collection<MasterQueryEntity> execute(long[] ids) throws SQLException {
        LinkedHashMap<String, String> entityFields = new LinkedHashMap<String, String>();
        if (this.isViewQuery) {
            this.entityClass.family().forEach(f -> f.selfWithIndex().stream().filter(s -> !s.isDynamic()).forEach(s -> entityFields.put(s.name(), s.name())));
        } else {
            this.entityClass.selfWithIndex().stream().filter(s -> !s.isDynamic()).forEach(s -> entityFields.put(s.name(), s.name()));
        }
        String sql = this.buildSQL(this.table, ids.length, entityFields);
        try (PreparedStatement st = this.getConnection().prepareStatement(sql);){
            int index = 1;
            for (long id : ids) {
                st.setLong(index++, id);
            }
            st.setBoolean(ids.length + 1, false);
            this.checkTimeout(st);
            ArrayList<MasterQueryEntity> entities = new ArrayList<MasterQueryEntity>(ids.length);
            try (ResultSet rs = st.executeQuery();){
                while (rs.next()) {
                }
            }
            ArrayList<MasterQueryEntity> arrayList = entities;
            return arrayList;
        }
    }

    private String buildSQL(String table, int size, Map<String, String> entityFields) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append(String.join((CharSequence)",", "id", "_sys_entityclass", "_sys_operatetime", "_sys_ver", "_sys_deleted", "_sys_profile"));
        entityFields.forEach((k, v) -> sql.append(",").append((String)k));
        sql.append("_sys_dynamic");
        sql.append(" FROM ").append(table).append(" WHERE ").append("id").append(" IN (").append(String.join((CharSequence)",", Collections.nCopies(size, "?"))).append(") AND ").append("_sys_deleted").append("=").append("?");
        return sql.toString();
    }
}

