/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.master.mysql.utils;

import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.plus.master.calcite.func.JsonUnquote;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.Tuple3;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlJsonValueFunction;
import org.apache.calcite.tools.RelBuilder;

public class RexNodeHelper {
    private static RelBuilder newBuilder;

    public static Tuple2<EntityClassGroup, RelDataTypeField> findSource(int index, List<EntityClassGroup> relatedGroup, RelNode currentNode, boolean isStart, Queue<Boolean> footprint) {
        if (currentNode instanceof TableScan || currentNode instanceof Project && !isStart || currentNode instanceof Aggregate) {
            RelDataTypeField relDataTypeField = (RelDataTypeField)currentNode.getRowType().getFieldList().get(index);
            EntityClassGroup relatedEntityClass = RexNodeHelper.findRelatedEntityClass(currentNode, relatedGroup);
            return Tuple.of((Object)relatedEntityClass, (Object)relDataTypeField);
        }
        if (currentNode instanceof BiRel) {
            RelNode left = ((Join)currentNode).getLeft();
            RelNode right = ((Join)currentNode).getRight();
            int leftSize = left.getRowType().getFieldList().size();
            if (index >= leftSize) {
                footprint.add(true);
                return RexNodeHelper.findSource(index - leftSize, relatedGroup, right, false, footprint);
            }
            footprint.add(false);
            return RexNodeHelper.findSource(index, relatedGroup, left, false, footprint);
        }
        return RexNodeHelper.findSource(index, relatedGroup, currentNode.getInput(0), false, footprint);
    }

    private static Tuple3<Integer, RelNode, Integer> findTarget(Queue<Boolean> footprint, RelBuilder relBuilder, int size) {
        int i = 0;
        AtomicInteger offSet = new AtomicInteger(0);
        if (size > 1) {
            Boolean isRight = footprint.poll();
            if (isRight.booleanValue()) {
                i = 1;
                offSet.addAndGet(relBuilder.peek(0).getRowType().getFieldCount());
                return Tuple.of((Object)i, (Object)RexNodeHelper.findTarget(footprint, relBuilder.peek(0), offSet), (Object)offSet.get());
            }
            return Tuple.of((Object)i, (Object)RexNodeHelper.findTarget(footprint, relBuilder.peek(1), offSet), (Object)offSet.get());
        }
        return Tuple.of((Object)i, (Object)RexNodeHelper.findTarget(footprint, relBuilder.peek(), offSet), (Object)offSet.get());
    }

    private static RelNode findTarget(Queue<Boolean> footprint, RelNode relNode, AtomicInteger offSet) {
        if (relNode instanceof BiRel) {
            RelNode left = ((BiRel)relNode).getLeft();
            RelNode right = ((BiRel)relNode).getRight();
            Boolean isRight = footprint.poll();
            if (isRight.booleanValue()) {
                offSet.addAndGet(left.getRowType().getFieldCount());
                return RexNodeHelper.findTarget(footprint, right, offSet);
            }
            return RexNodeHelper.findTarget(footprint, left, offSet);
        }
        if (relNode instanceof Project || relNode instanceof TableScan || relNode instanceof Aggregate) {
            return relNode;
        }
        RelNode input = relNode.getInput(0);
        return RexNodeHelper.findTarget(footprint, input, offSet);
    }

    public static RexNode convert(RelBuilder newBuilder, int index, List<EntityClassGroup> relatedGroup, RelNode currentNode, boolean isStart, int totalNum) {
        Optional fieldOp;
        LinkedList<Boolean> footprint = new LinkedList<Boolean>();
        Tuple2<EntityClassGroup, RelDataTypeField> source = RexNodeHelper.findSource(index, relatedGroup, currentNode, isStart, footprint);
        EntityClassGroup entityClass = (EntityClassGroup)source._1;
        RelDataTypeField relDataTypeField = (RelDataTypeField)source._2;
        Tuple3<Integer, RelNode, Integer> targetNode = currentNode instanceof BiRel && newBuilder.size() > 1 ? RexNodeHelper.findTarget(footprint, newBuilder, 2) : RexNodeHelper.findTarget(footprint, newBuilder, 1);
        String originName = relDataTypeField.getName();
        String targetName = originName.toLowerCase();
        if (targetName.startsWith("_") && targetName.contains(".")) {
            int i = targetName.lastIndexOf(".");
            fieldOp = entityClass.field(targetName.substring(i + 1));
        } else {
            fieldOp = entityClass.field(targetName);
        }
        if (fieldOp.isPresent()) {
            IEntityField field = (IEntityField)fieldOp.get();
            if (field.isDynamic() && RexNodeHelper.hasDynamic(newBuilder.peek().getRowType()) && !RexNodeHelper.fieldIn(((RelNode)targetNode._2).getRowType(), targetName)) {
                if (currentNode instanceof BiRel && newBuilder.size() > 1) {
                    Integer inputIndex = (Integer)targetNode._1;
                    RexNode call = newBuilder.call((SqlOperator)new SqlJsonValueFunction("JSON_EXTRACT"), new RexNode[]{newBuilder.field(totalNum, inputIndex.intValue(), "_sys_dynamic"), newBuilder.literal((Object)"$.".concat(originName.toLowerCase()))});
                    return newBuilder.call((SqlOperator)new JsonUnquote(), new RexNode[]{call});
                }
                RexNode call = newBuilder.call((SqlOperator)new SqlJsonValueFunction("JSON_EXTRACT"), new RexNode[]{newBuilder.field(1, 0, "_sys_dynamic"), newBuilder.literal((Object)"$.".concat(originName.toLowerCase()))});
                return newBuilder.call((SqlOperator)new JsonUnquote(), new RexNode[]{call});
            }
            String finalTargetName = targetName;
            RelNode targetRelNode = (RelNode)targetNode._2;
            Optional<RelDataTypeField> related = targetRelNode.getRowType().getFieldList().stream().filter(x -> RexNodeHelper.isFitName(x.getName(), finalTargetName)).findFirst();
            if (related.isPresent()) {
                if (currentNode instanceof BiRel && newBuilder.size() > 1) {
                    Integer ptx = (Integer)targetNode._1;
                    return newBuilder.field(totalNum, ptx.intValue(), related.get().getIndex());
                }
                return newBuilder.field(1, 0, related.get().getIndex() + (Integer)targetNode._3);
            }
            throw new RuntimeException("No Related Code");
        }
        if (currentNode instanceof BiRel) {
            Integer ptx = (Integer)targetNode._1;
            RelNode peek = newBuilder.peek();
            if (newBuilder.size() > 1) {
                List fieldNames = newBuilder.peek(1 - ptx).getRowType().getFieldNames();
                int i = fieldNames.indexOf(originName);
                return newBuilder.field(totalNum, ptx.intValue(), i);
            }
            if (peek instanceof BiRel) {
                List fieldNames = newBuilder.peek().getInput(1 - ptx).getRowType().getFieldNames();
                if (ptx == 0) {
                    int i = fieldNames.indexOf(originName);
                    if (i > -1) {
                        return newBuilder.field(1, 0, i);
                    }
                    return newBuilder.field(1, 0, originName);
                }
                int i = fieldNames.indexOf(originName);
                if (i > -1) {
                    return newBuilder.field(totalNum, ptx.intValue(), i + newBuilder.peek().getInput(0).getRowType().getFieldCount());
                }
                return newBuilder.field(totalNum, ptx.intValue(), originName);
            }
            if (peek.getInput(0) instanceof BiRel) {
                List fieldNames = newBuilder.peek().getInput(0).getInput(ptx.intValue()).getRowType().getFieldNames();
                if (ptx == 0) {
                    int i = fieldNames.indexOf(originName);
                    return newBuilder.field(totalNum, ptx.intValue(), i);
                }
                int i = fieldNames.indexOf(originName);
                return newBuilder.field(totalNum, ptx.intValue(), i + newBuilder.peek().getInput(0).getInput(0).getRowType().getFieldCount());
            }
        }
        List fieldNames = newBuilder.peek().getRowType().getFieldNames();
        int i = fieldNames.indexOf(originName);
        return newBuilder.field(totalNum, 0, i);
    }

    private static boolean fieldIn(RelDataType rowType, String targetName) {
        RelDataTypeField field = rowType.getField(targetName, false, false);
        return field != null;
    }

    public static RexNode simpleNameConvert(RelBuilder newBuilder, EntityClassGroup entityClass, String originName, String targetName, int totalNum, int inputIndex, boolean isRight) {
        Optional fieldOp = entityClass.field(targetName);
        if (fieldOp.isPresent()) {
            IEntityField field = (IEntityField)fieldOp.get();
            if (field.isDynamic() && RexNodeHelper.hasDynamic(newBuilder.peek().getRowType())) {
                RexNode call = newBuilder.call((SqlOperator)new SqlJsonValueFunction("JSON_EXTRACT"), new RexNode[]{newBuilder.field(totalNum, totalNum > 1 ? 2 - inputIndex : 0, "_sys_dynamic"), newBuilder.literal((Object)"$.".concat(targetName))});
                return newBuilder.call((SqlOperator)new JsonUnquote(), new RexNode[]{call});
            }
            String finalTargetName = targetName;
            RelNode peeked = newBuilder.peek(inputIndex - 1);
            Optional<RelDataTypeField> first = null;
            first = peeked instanceof Join ? (isRight ? ((Join)peeked).getRight().getRowType().getFieldList().stream().filter(x -> RexNodeHelper.isFitName(x.getName(), finalTargetName)).findFirst() : ((Join)peeked).getLeft().getRowType().getFieldList().stream().filter(x -> RexNodeHelper.isFitName(x.getName(), finalTargetName)).findFirst()) : newBuilder.peek(inputIndex - 1).getRowType().getFieldList().stream().filter(x -> RexNodeHelper.isFitName(x.getName(), finalTargetName)).findFirst();
            if (first.isPresent()) {
                RelDataTypeField targetField = first.get();
                int targetIndex = targetField.getIndex();
                if (!isRight) {
                    return newBuilder.field(totalNum, totalNum > 1 ? 2 - inputIndex : 0, targetIndex);
                }
                if (peeked instanceof Join) {
                    return newBuilder.field(totalNum, totalNum > 1 ? 2 - inputIndex : 0, targetIndex + ((Join)peeked).getLeft().getRowType().getFieldCount());
                }
                return newBuilder.field(totalNum, totalNum > 1 ? 2 - inputIndex : 0, targetIndex);
            }
            return newBuilder.field(totalNum, totalNum > 1 ? 2 - inputIndex : 0, targetName);
        }
        List fieldNames = newBuilder.peek().getRowType().getFieldNames();
        int i = fieldNames.indexOf(originName);
        if (i > 0) {
            return newBuilder.field(totalNum, totalNum > 1 ? 2 - inputIndex : 0, i);
        }
        return newBuilder.field(totalNum, totalNum > 1 ? 2 - inputIndex : 0, originName);
    }

    private static EntityClassGroup findRelatedEntityClass(RelNode relNode, List<EntityClassGroup> allRelatedEntityClasses) {
        Stack<RelNode> stack = new Stack<RelNode>();
        stack.push(relNode);
        while (!stack.isEmpty()) {
            RelNode input;
            RelNode next = (RelNode)stack.pop();
            if (next instanceof TableScan) {
                RelOptTable table = ((TableScan)next).getTable();
                String entityCode = (String)table.getQualifiedName().get(1);
                Optional<EntityClassGroup> first = allRelatedEntityClasses.stream().filter(x -> x.getEntityClass().code().equalsIgnoreCase(entityCode)).findFirst();
                if (!first.isPresent()) continue;
                return first.get();
            }
            if (next instanceof BiRel) {
                input = next.getInput(0);
                stack.push(input);
                continue;
            }
            input = next.getInput(0);
            stack.push(input);
        }
        throw new RuntimeException("No Related EntityClass");
    }

    private static boolean hasDynamic(RelDataType dataType) {
        return dataType.getFieldNames().contains("_sys_dynamic");
    }

    private static boolean isFitName(String name, String finalTargetName) {
        if (name.equalsIgnoreCase(finalTargetName)) {
            return true;
        }
        String transformed = finalTargetName.replaceAll("\\.", "_");
        return name.equalsIgnoreCase(transformed);
    }
}

