package com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor;

import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.plus.common.executor.Executor;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.MasterQueryEntity;
import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.table.SystemColumn;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.*;

/**
 * Created by justin.xu on 03/2023.
 *
 * @since 1.8
 */
public class MultiQueryPrimaryExecutor extends AbstractMasterTaskExecutor<long[], Collection<MasterQueryEntity>> {

    private IEntityClass entityClass;
    private String table;
    private boolean isViewQuery;

    public MultiQueryPrimaryExecutor(Connection connection, long timeout, IEntityClass entityClass, String table, boolean isViewQuery) {
        super(connection, timeout);
        this.entityClass = entityClass;
        this.table = table;
        this.isViewQuery = isViewQuery;
    }

    public static Executor<long[], Collection<MasterQueryEntity>> build(
        Connection connection, long timeout, IEntityClass entityClass, String table, boolean isViewQuery) {
        return new MultiQueryPrimaryExecutor(connection, timeout, entityClass, table, isViewQuery);
    }

    @Override
    public Collection<MasterQueryEntity> execute(long[] ids) throws SQLException {
        final Map<String, String> entityFields = new LinkedHashMap<>();

        if (isViewQuery) {
            entityClass.family().forEach(
                f -> {
                    f.selfWithIndex().stream().filter(s -> !s.isDynamic())
                        .forEach(s -> {
                            entityFields.put(s.name(), s.name());
                        });
                }
            );
        } else {
            entityClass.selfWithIndex().stream().filter(s -> !s.isDynamic()).forEach(s -> {
                entityFields.put(s.name(), s.name());
            });
        }

        String sql
            = buildSQL(table, ids.length, entityFields);

        try (PreparedStatement st = getConnection().prepareStatement(sql)) {
            int index = 1;
            for (long id : ids) {
                st.setLong(index++, id);
            }
            st.setBoolean(ids.length + 1, false);

            checkTimeout(st);

            List<MasterQueryEntity> entities = new ArrayList<>(ids.length);
            try (ResultSet rs = st.executeQuery()) {

                while (rs.next()) {
                    //TODO
                    //entities.add(resultSetToSelectItem(rs, table, entityFields, null));
                }
            }
            return entities;
        }
    }

    private String buildSQL(String table, int size, Map<String, String> entityFields) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append(String.join(",",
            SystemColumn.ID,
            SystemColumn.SYS_ENTITY_CLASS,
            SystemColumn.SYS_OPERATE_TIME,
            SystemColumn.SYS_VERSION,
            SystemColumn.SYS_DELETED,
            SystemColumn.SYS_PROFILE
            )
        );

        entityFields.forEach(
            (k, v) -> {
                sql.append(",").append(k);
            }
        );

        sql.append(SystemColumn.DYNAMIC_FIELD);

        sql.append(" FROM ")
            .append(table)
            .append(" WHERE ")
            .append(SystemColumn.ID).append(" IN (").append(String.join(",", Collections.nCopies(size, "?")))
            .append(") AND ")
            .append(SystemColumn.SYS_DELETED).append("=").append("?");
        return sql.toString();
    }
}
