/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor;

import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.plus.common.executor.Executor;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.MasterQueryEntity;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor.AbstractMasterTaskExecutor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class QueryPrimaryExecutor
extends AbstractMasterTaskExecutor<Long, Optional<MasterQueryEntity>> {
    private IEntityClass entityClass;
    private String table;
    private boolean isViewQuery;

    public QueryPrimaryExecutor(Connection connection, long timeout, IEntityClass entityClass, String table, boolean isViewQuery) {
        super(connection, timeout);
        this.entityClass = entityClass;
        this.table = table;
        this.isViewQuery = isViewQuery;
    }

    public static Executor<Long, Optional<MasterQueryEntity>> build(Connection connection, long timeout, IEntityClass entityClass, String table, boolean isViewQuery) {
        return new QueryPrimaryExecutor(connection, timeout, entityClass, table, isViewQuery);
    }

    public Optional<MasterQueryEntity> execute(Long id) throws SQLException {
        LinkedHashMap<String, String> entityFields = new LinkedHashMap<String, String>();
        if (this.isViewQuery) {
            this.entityClass.family().forEach(f -> f.selfWithIndex().stream().filter(s -> !s.isDynamic()).forEach(s -> entityFields.put(s.name(), s.name())));
        } else {
            this.entityClass.selfWithIndex().stream().filter(s -> !s.isDynamic()).forEach(s -> entityFields.put(s.name(), s.name()));
        }
        String sql = this.buildSQL(this.table, entityFields);
        try (PreparedStatement st = this.getConnection().prepareStatement(sql);){
            st.setLong(1, id);
            st.setBoolean(2, false);
            try (ResultSet rs = st.executeQuery();){
                this.checkTimeout(st);
                if (rs.next()) {
                    Optional<MasterQueryEntity> optional = Optional.empty();
                    return optional;
                }
            }
            Optional<MasterQueryEntity> optional = Optional.empty();
            return optional;
        }
    }

    private String buildSQL(String table, Map<String, String> entityFields) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append(String.join((CharSequence)",", "id", "_sys_entityclass", "_sys_operatetime", "_sys_ver", "_sys_deleted", "_sys_profile"));
        entityFields.forEach((k, v) -> sql.append(",").append((String)k));
        sql.append("_sys_dynamic");
        sql.append(" FROM ").append(table).append(" WHERE ").append("id").append("=").append("?").append(" AND ").append("_sys_deleted").append("=").append("?");
        return sql.toString();
    }
}

