/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor;

import com.xforceplus.ultraman.oqsengine.plus.common.executor.Executor;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.MasterStorageEntity;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.StorageType;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor.AbstractMasterTaskExecutor;
import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.table.SystemColumn;
import com.xforceplus.ultraman.sdk.core.utils.MasterStorageHelper;
import com.xforceplus.ultraman.sdk.infra.codec.MySQLCodecCustom;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.codecs.Codec;

public class UpdateExecutor
extends AbstractMasterTaskExecutor<List<MasterStorageEntity>, boolean[]> {
    private Codec<Character> mySQLCodec = new MySQLCodecCustom(MySQLCodecCustom.Mode.STANDARD);

    public UpdateExecutor(Connection resource, long timeout) {
        super(resource, timeout);
    }

    public static Executor<List<MasterStorageEntity>, boolean[]> build(Connection resource, long timeout) {
        return new UpdateExecutor(resource, timeout);
    }

    public boolean[] execute(List<MasterStorageEntity> masterStorageEntities) throws SQLException {
        boolean isBatch = masterStorageEntities.size() > 1;
        try (Statement st = this.getConnection().createStatement();){
            if (isBatch) {
                for (MasterStorageEntity entity : masterStorageEntities) {
                    String sql = this.buildSql(entity, entity.getBusinessDynamicFields(), entity.getBusinessDynamicFieldsRemove());
                    st.addBatch(sql);
                }
                Object object = this.executedUpdate(st, true);
                return object;
            }
            MasterStorageEntity entity = masterStorageEntities.get(0);
            String sql = this.buildSql(entity, entity.getBusinessDynamicFields(), entity.getBusinessDynamicFieldsRemove());
            boolean[] blArray = new boolean[]{st.executeUpdate(sql) > 0};
            return blArray;
        }
    }

    protected String buildSql(MasterStorageEntity entity, String replace, String remove) throws SQLException {
        StringBuilder base = new StringBuilder();
        base.append(String.format("UPDATE %s SET ", entity.getTableName()));
        base.append("_sys_ver").append("=").append("_sys_ver").append("+1");
        base.append(",").append("_sys_operatetime").append("=").append(entity.getSystemColumn().getOperateTime());
        if (!entity.getBusinessStaticFields().isEmpty()) {
            for (MasterStorageEntity.TypedStorageValue value : entity.getBusinessStaticFields()) {
                String columnName = value.getEntityField().name();
                if (SystemColumn.SYSTEM_WORDS.contains(columnName)) continue;
                StorageType storageType = StorageType.instance(value.getEntityField().type());
                if (null == storageType) {
                    throw new SQLException("storageType not found.");
                }
                base.append(",").append(MasterStorageHelper.toStorageName((String)columnName, (boolean)true)).append("=");
                if (value.getValue() == null) {
                    base.append("null");
                    continue;
                }
                Object targetValue = storageType.isNeedSymbol() ? String.format("'%s'", ESAPI.encoder().encodeForSQL(this.mySQLCodec, value.getValue().toString())) : value.getValue();
                base.append(targetValue);
            }
        }
        if (!replace.isEmpty()) {
            base.append(",");
            base.append("_sys_dynamic").append("=").append(replace);
        }
        if (!remove.isEmpty()) {
            base.append(",");
            base.append("_sys_dynamic").append("=").append(remove);
        }
        base.append(" ").append("where id").append("=").append(entity.getSystemColumn().getId());
        base.append(" AND ").append("_sys_deleted").append("=").append(false);
        return base.toString();
    }
}

