/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.master.mysql.query;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.utils.RexNodeHelper;
import io.vavr.Tuple2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlJsonValueFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Sarg;

public class CopyVisitor
extends RexVisitorImpl<RexNode> {
    private RelBuilder builder;
    private List<EntityClassGroup> involvedEntityClasses;
    private RelNode currentNode;
    private List<RexDynamicParam> dynamic = new ArrayList<RexDynamicParam>();

    public CopyVisitor(RelBuilder builder, List<EntityClassGroup> involvedEntityClasses, RelNode currentNode) {
        super(true);
        this.builder = builder;
        this.involvedEntityClasses = involvedEntityClasses;
        this.currentNode = currentNode;
    }

    public RexNode visitDynamicParam(RexDynamicParam param) {
        this.dynamic.add(param);
        return param;
    }

    public List<RexDynamicParam> getDynamic() {
        return this.dynamic;
    }

    public RexNode visitInputRef(RexInputRef inputRef) {
        return RexNodeHelper.convert(this.builder, inputRef.getIndex(), this.involvedEntityClasses, this.currentNode, true, this.currentNode instanceof BiRel ? 2 : 1);
    }

    public RexNode visitLiteral(RexLiteral literal) {
        RexNode copy = this.builder.getRexBuilder().copy((RexNode)literal);
        return copy;
    }

    public RexNode visitCall(RexCall call) {
        boolean isMultiValue;
        Optional<RexNode> first = call.getOperands().stream().filter(x -> x instanceof RexInputRef).findFirst();
        if (first.isPresent() && (isMultiValue = this.checkIfMultiValue((RexInputRef)first.get(), this.currentNode))) {
            SqlOperator operator = call.getOperator();
            List operands = this.visitList(call.getOperands());
            Optional<RexNode> values = operands.stream().filter(x -> x instanceof RexLiteral).findFirst();
            boolean isIn = true;
            if (values.isPresent()) {
                RexLiteral literal = (RexLiteral)values.get();
                Object value2 = literal.getValue2();
                RexLiteral newValues = null;
                if (value2 instanceof Sarg) {
                    RangeSet rangeSet;
                    Sarg points = (Sarg)value2;
                    if (points.isComplementedPoints()) {
                        isIn = false;
                        rangeSet = TreeRangeSet.create((RangeSet)points.rangeSet).complement();
                    } else {
                        rangeSet = points.rangeSet;
                    }
                    String collect = rangeSet.asRanges().stream().map(x -> ((Range)x).upperEndpoint()).map(x -> ((NlsString)x).getValue()).map(x -> "\"".concat(x.toString()).concat("\"")).collect(Collectors.joining(","));
                    newValues = this.builder.literal((Object)"[".concat(collect).concat("]"));
                } else if (value2 instanceof String) {
                    newValues = this.builder.literal((Object)"[\"".concat((String)value2).concat("\"]"));
                } else if (value2 instanceof Number) {
                    newValues = this.builder.literal((Object)"[\"".concat(value2.toString()).concat("\"]"));
                }
                if (newValues != null) {
                    List<RexNode> rexNodes = Arrays.asList(first.get(), newValues);
                    if (operator == SqlStdOperatorTable.IN || operator == SqlStdOperatorTable.SEARCH || operator == SqlStdOperatorTable.EQUALS) {
                        if (isIn) {
                            return this.builder.getRexBuilder().makeCall(call.getType(), (SqlOperator)new SqlJsonValueFunction("JSON_CONTAINS"), rexNodes);
                        }
                        return this.builder.getRexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{this.builder.getRexBuilder().makeCall(call.getType(), (SqlOperator)new SqlJsonValueFunction("JSON_CONTAINS"), rexNodes)});
                    }
                    if (operator == SqlStdOperatorTable.NOT_IN || operator == SqlStdOperatorTable.NOT_EQUALS) {
                        return this.builder.getRexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{this.builder.getRexBuilder().makeCall(call.getType(), (SqlOperator)new SqlJsonValueFunction("JSON_CONTAINS"), rexNodes)});
                    }
                }
            }
        }
        List operands = this.visitList(call.getOperands());
        return this.builder.getRexBuilder().makeCall(call.getType(), call.getOperator(), operands);
    }

    private boolean checkIfMultiValue(RexInputRef rexInputRef, RelNode currentNode) {
        LinkedList<Boolean> footprint = new LinkedList<Boolean>();
        Tuple2<EntityClassGroup, RelDataTypeField> source = RexNodeHelper.findSource(rexInputRef.getIndex(), this.involvedEntityClasses, currentNode, false, footprint);
        EntityClassGroup entityClassGroup = (EntityClassGroup)source._1;
        RelDataTypeField relDataTypeField = (RelDataTypeField)source._2;
        String name = relDataTypeField.getName();
        Optional field = entityClassGroup.field(name);
        if (field.isPresent()) {
            return ((IEntityField)field.get()).type() == FieldType.STRINGS;
        }
        return false;
    }
}

