package com.xforceplus.ultraman.oqsengine.plus.master.dto;


import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.table.SystemColumn;

import java.util.List;
import java.util.Map;

public class ConditionalStorageEntity {
    
    private String tableSql;
    
    private String conditionSql;

    private MasterStorageEntity masterStorageEntity;
    
    private String targetTable;
    
    private int limit;

    public ConditionalStorageEntity(String targetTable, String tableSql, String conditionSql, int limit, MasterStorageEntity masterStorageEntity) {
        this.tableSql = tableSql;
        this.conditionSql = conditionSql;
        this.masterStorageEntity = masterStorageEntity;
        this.limit = limit;
        this.targetTable = targetTable;
    }

    public String getTargetTable() {
        return targetTable;
    }

    public int getLimit() {
        return limit;
    }

    public String getTableSql() {
        return tableSql;
    }

    public SystemColumn getSystemColumn() {
        return masterStorageEntity.getSystemColumn();
    }

    public String getConditionSql() {
        return conditionSql;
    }


    public List<MasterStorageEntity.TypedStorageValue> getBusinessStaticFields() {
        return masterStorageEntity.getBusinessStaticFields();
    }
}
