package com.xforceplus.ultraman.oqsengine.plus.master.mysql.calcite;

import com.xforceplus.metadata.schema.typed.BoIndex;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.legacy.impl.ColumnField;
import com.xforceplus.ultraman.metadata.service.DictService;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.MysqlSqlDialectEx;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.query.CopyVisitor;
import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.table.SystemColumn;
import com.xforceplus.ultraman.sdk.core.config.ExecutionConfig;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.rel2sql.RelToSqlConverter;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.*;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.util.SqlString;
import org.apache.calcite.tools.RelBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.units.qual.C;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import static com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.table.SystemColumn.SYSTEM_WORDS;

/**
 * convert node to master sql only on sort , filter, tableScan
 */
public class ConditionalSqlShuttle extends RelShuttleImpl {

    private RelBuilder builder;
    
    private String targetCode;
    
    private String conditionSql;
    
    private EntityClassGroup targetGroup;
    
    private int limit;
    
    private ExecutionConfig executionConfig;
    
    private DictService dictService;
    
    public ConditionalSqlShuttle(EntityClassGroup targetGroup
            , RelBuilder builder, String targetCode
            , DictService dictService, ExecutionConfig executionConfig) {
        this.builder = builder;
        this.targetCode = targetCode;
        this.targetGroup = targetGroup;
        this.executionConfig = executionConfig;
        this.dictService = dictService;
    }

    public int getLimit() {
        return limit;
    }

    public String getConditionSql() {
        return conditionSql;
    }

    @Override
    public RelNode visit(LogicalSort sort) {
        RexNode fetch = sort.fetch;
        if(fetch != null) {
            RexLiteral literal = (RexLiteral) fetch;
            limit = literal.getValueAs(Integer.class);
        }
        return super.visit(sort);
    }

    @Override
    public RelNode visit(TableScan scan) {
        /**
         * assume the table is second;
         */
        builder = builder.scan("oqs", targetGroup.getEntityClass().masterQueryTable().toLowerCase());
        return super.visit(scan);
    }

    @Override
    public RelNode visit(LogicalFilter filter) {
        RelNode visit = super.visit(filter);
        MyConverter rexToSqlNodeConverter = new MyConverter(filter);
        RexCall condition = (RexCall) filter.getCondition();
        CopyVisitor copyVisitor = new CopyVisitor(builder, Collections.singletonList(targetGroup)
                , filter, executionConfig.isUseStrictEnum(), dictService, executionConfig.getInClauseRewrite());
        RexNode finalNode = condition.accept(copyVisitor);
        if(finalNode != null) {
            SqlNode sqlNode = rexToSqlNodeConverter.convertCall((RexCall)finalNode);
            if(sqlNode != null ) {
                SqlString sqlString = sqlNode.toSqlString(MysqlSqlDialectEx.DEFAULT);
                conditionSql = sqlString.getSql();
            }
        }
    
        return visit;
    }
    
    class MyConverter extends RexToSqlNodeConverterImpl {
        
        private RelNode relNode;
        
        private String targetCode;

        public MyConverter(RelNode relNode) {
            super(new RexSqlStandardConvertletTable());
            this.relNode = relNode;
        }

        @Override
        public @Nullable SqlNode convertInputRef(RexInputRef ref) {
            int index = ref.getIndex();
            RelDataTypeField relDataTypeField = builder.peek().getRowType().getFieldList().get(index);

            String name = relDataTypeField.getName();
            
            if(SYSTEM_WORDS.contains(name)) {
                name = targetCode.concat(".").concat(relDataTypeField.getName());
            }

            /**
             * redundant fields
             */
            Optional<ColumnField> column = targetGroup.column(name);
            if(column.isPresent()) {
                ColumnField columnField = column.get();
                Stream<BoIndex> selfIndexStream = targetGroup.getEntityClass().indexes().stream();
                Stream<BoIndex> fatherIndexStream = targetGroup.getFatherEntityClass().stream().flatMap(x -> x.indexes().stream());
                Optional<BoIndex> any = Stream.concat(selfIndexStream, fatherIndexStream).filter(x -> x.getName().equals(columnField.name())).findAny();
                if(any.isPresent()) {
                    name = targetCode.concat(".").concat(name);
                }
            }

            return new SqlIdentifier(name, SqlParserPos.QUOTED_ZERO);
        }
    }
}
