package com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.service.DictService;
import com.xforceplus.ultraman.oqsengine.plus.common.executor.Executor;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.MasterQueryResult;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.query.AbstractMasterQueryExecutor;
import com.xforceplus.ultraman.oqsengine.plus.storage.pojo.dto.select.SelectConfig;
import org.apache.calcite.tools.FrameworkConfig;

import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

/**
 * Created by justin.xu on 03/2023.
 *
 * @since 1.8
 */
public class ConditionQueryExecutor extends AbstractMasterQueryExecutor<SelectConfig, MasterQueryResult> {

    private EntityClassGroup entityClass;
    private FrameworkConfig frameworkConfig;


    public static Executor<SelectConfig, MasterQueryResult> build(EntityClassEngine engine, DictService dictService, ObjectMapper mapper,
            Connection connection, long timeout, EntityClassGroup entityClass
            , FrameworkConfig frameworkConfig, boolean useStrictEnum, Map<String, List<String>> rewriteMapping) {
        return new ConditionQueryExecutor(engine, dictService, mapper, connection, timeout, entityClass
                , frameworkConfig, useStrictEnum, rewriteMapping);
    }

    public ConditionQueryExecutor(
            EntityClassEngine engine, DictService dictService, ObjectMapper mapper, Connection connection, long timeout, EntityClassGroup entityClass
            , FrameworkConfig frameworkConfig, boolean useStrictEnum, Map<String, List<String>> rewriteMapping) {
        super(engine, dictService, mapper, connection, timeout, useStrictEnum, rewriteMapping);
        this.entityClass = entityClass;
        this.frameworkConfig = frameworkConfig;

    }

    @Override
    public MasterQueryResult execute(SelectConfig selectConfig) throws SQLException {
        return super.executeQuery(selectConfig, entityClass, frameworkConfig);
    }
}
