package com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor;

import com.xforceplus.ultraman.oqsengine.plus.common.executor.Executor;
import com.xforceplus.ultraman.sdk.infra.codec.MySQLCodecCustom;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.MasterStorageEntity;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.StorageType;
import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.table.SystemColumn;
import com.xforceplus.ultraman.sdk.core.utils.MasterStorageHelper;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.codecs.Codec;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

/**
 * Created by justin.xu on 03/2023.
 *
 * @since 1.8
 */
public class UpdateExecutor extends AbstractMasterTaskExecutor<List<MasterStorageEntity>, Boolean[]> {

    /**
     * TODO
     * current static inited
     */
    private Codec<Character> mySQLCodec = new MySQLCodecCustom(MySQLCodecCustom.Mode.STANDARD);

    public UpdateExecutor(Connection resource, long timeout) {
        super(resource, timeout);
    }

    public static Executor<List<MasterStorageEntity>, Boolean[]> build(
            Connection resource, long timeout) {
        return new UpdateExecutor(resource, timeout);
    }

    @Override
    public Boolean[] execute(List<MasterStorageEntity> masterStorageEntities) throws SQLException {
        boolean isBatch = masterStorageEntities.size() > 1;

        //  设置值.
        try (Statement st = getConnection().createStatement()) {
            if (isBatch) {
                for (MasterStorageEntity entity : masterStorageEntities) {

                    //  建SQL.
                    String sql = buildSql(
                            entity,
                            entity.getBusinessDynamicFields(),
                            entity.getBusinessDynamicFieldsRemove());

                    st.addBatch(sql);
                }

                return executedUpdate(st, true);
            } else {
                MasterStorageEntity entity = masterStorageEntities.get(0);

                //  建SQL.
                String sql = buildSql(
                        entity,
                        entity.getBusinessDynamicFields(),
                        entity.getBusinessDynamicFieldsRemove());

                return new Boolean[]{st.executeUpdate(sql) > 0};
            }
        }
    }

    protected String buildSql(MasterStorageEntity entity, String replace, String remove) throws SQLException {
        StringBuilder base = new StringBuilder();
        base.append(String.format("UPDATE %s SET ", entity.getTableName()));
        base.append(SystemColumn.SYS_VERSION).append("=").append(SystemColumn.SYS_VERSION).append("+1");
        base.append(",").append(SystemColumn.SYS_OPERATE_TIME).append("=").append(entity.getSystemColumn().getOperateTime());

        if (!entity.getBusinessStaticFields().isEmpty()) {
            for (MasterStorageEntity.TypedStorageValue value : entity.getBusinessStaticFields()) {

                String columnName = value.getEntityField().name();
                if (!SystemColumn.SYSTEM_WORDS.contains(columnName)) {
                    StorageType storageType = StorageType.instance(value.getEntityField().type());
                    if (null == storageType) {
                        throw new SQLException("storageType not found.");
                    }

                    base.append(",")
                            .append(MasterStorageHelper.toStorageName(columnName, true))
                            .append("=");

                    if (value.getValue() == null) {
                        base.append("null");
                    } else {
                        Object targetValue = storageType.isNeedSymbol() ?
                                String.format("'%s'", ESAPI.encoder().encodeForSQL(mySQLCodec, value.getValue().toString()))
                                : value.getValue();
                        base.append(targetValue);
                    }
                }
            }
        }

        if (!replace.isEmpty()) {
            base.append(",");
            base.append(SystemColumn.DYNAMIC_FIELD).append("=").append(replace);
        }

        if (!remove.isEmpty()) {
            base.append(",");
            base.append(SystemColumn.DYNAMIC_FIELD).append("=").append(remove);
        }

        base.append(" ").append("where id").append("=").append(entity.getSystemColumn().getId());
        base.append(" AND ").append(SystemColumn.SYS_DELETED).append("=").append(false);

        return base.toString();
    }
}
