/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.master.mysql;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.metadata.cdc.OqsEngineEntity;
import com.xforceplus.ultraman.metadata.constants.SystemField;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.EntityClassRef;
import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.IEntity;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.entity.IEntityValue;
import com.xforceplus.ultraman.metadata.service.DictService;
import com.xforceplus.ultraman.metadata.values.EnumsValue;
import com.xforceplus.ultraman.metadata.values.IValue;
import com.xforceplus.ultraman.oqsengine.plus.common.iterator.DataIterator;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.ConditionalStorageEntity;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.ConditionalStoragePackage;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.MasterQueryResult;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.MasterStorageEntity;
import com.xforceplus.ultraman.oqsengine.plus.master.iterator.IdIterator;
import com.xforceplus.ultraman.oqsengine.plus.master.iterator.OriginEntityIterator;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.MasterStorage;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.calcite.ConditionalSqlShuttle;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.devops.RebuildExecutor;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor.ConditionQueryExecutor;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor.ConditionalReplaceExecutor;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor.CreateExecutor;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor.DeleteExecutor;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor.UpdateExecutor;
import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.Operation;
import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.table.QueryResult;
import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.table.SystemColumn;
import com.xforceplus.ultraman.oqsengine.plus.storage.pojo.dto.EntityPackage;
import com.xforceplus.ultraman.oqsengine.plus.storage.pojo.dto.select.SelectConfig;
import com.xforceplus.ultraman.sdk.core.config.CdcConfig;
import com.xforceplus.ultraman.sdk.core.config.ExecutionConfig;
import com.xforceplus.ultraman.sdk.core.datasource.PackageInternal;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.DynamicDataSource;
import com.xforceplus.ultraman.sdk.core.event.EntityAfterCreate;
import com.xforceplus.ultraman.sdk.core.event.EntityAfterDelete;
import com.xforceplus.ultraman.sdk.core.event.EntityAfterMultiCreate;
import com.xforceplus.ultraman.sdk.core.event.EntityAfterMultiDelete;
import com.xforceplus.ultraman.sdk.core.event.EntityAfterMultiUpdate;
import com.xforceplus.ultraman.sdk.core.event.EntityAfterUpdate;
import com.xforceplus.ultraman.sdk.core.event.EntityBeforeConUpdate;
import com.xforceplus.ultraman.sdk.core.event.EntityBeforeCreate;
import com.xforceplus.ultraman.sdk.core.event.EntityBeforeDelete;
import com.xforceplus.ultraman.sdk.core.event.EntityBeforeMultiCreate;
import com.xforceplus.ultraman.sdk.core.event.EntityBeforeMultiDelete;
import com.xforceplus.ultraman.sdk.core.event.EntityBeforeMultiUpdate;
import com.xforceplus.ultraman.sdk.core.event.EntityBeforeUpdate;
import com.xforceplus.ultraman.sdk.core.event.EntityChanged;
import com.xforceplus.ultraman.sdk.core.event.EntityCreated;
import com.xforceplus.ultraman.sdk.core.event.EntityDeleted;
import com.xforceplus.ultraman.sdk.core.event.EntityMultiCreated;
import com.xforceplus.ultraman.sdk.core.event.EntityMultiDeleted;
import com.xforceplus.ultraman.sdk.core.event.EntityMultiUpdated;
import com.xforceplus.ultraman.sdk.core.event.EntityUpdated;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpContext;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpRel;
import com.xforceplus.ultraman.sdk.core.rel.utils.ExpTreeToRel;
import com.xforceplus.ultraman.sdk.core.utils.MasterStorageHelper;
import com.xforceplus.ultraman.sdk.infra.codec.MySQLCodecCustom;
import com.xforceplus.ultraman.sdk.infra.event.EventPublisher;
import com.xforceplus.ultraman.sdk.infra.logging.LoggingPattern;
import com.xforceplus.ultraman.sdk.infra.logging.LoggingUtils;
import io.micrometer.core.annotation.Timed;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Metrics;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.calcite.adapter.jdbc.JdbcSchema;
import org.apache.calcite.config.Lex;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.plan.Context;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.RelBuilder;
import org.apache.commons.lang3.StringUtils;
import org.owasp.esapi.codecs.Codec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class SQLMasterStorage
implements MasterStorage {
    private static final Logger log = LoggerFactory.getLogger(SQLMasterStorage.class);
    @Autowired(required=false)
    public EventPublisher publisher;
    @Lazy
    @Autowired
    private FrameworkConfig config;
    private PlatformTransactionManager manager;
    private TransactionTemplate template;
    private JdbcTemplate jdbcTemplate;
    private DynamicDataSource dynamicDataSource;
    private DataSource masterDataSource;
    private EntityClassEngine engine;
    private ObjectMapper objectMapper;
    private Map<String, OQSFrameworkConfig> oqsFrameworkConfigMap = new HashMap<String, OQSFrameworkConfig>();
    private SchemaPlus rootSchema;
    private Codec<Character> mySQLCodec = new MySQLCodecCustom(MySQLCodecCustom.Mode.STANDARD);
    private FrameworkConfig frameworkConfig;
    private Map<String, Schema> mapping = new ConcurrentHashMap<String, Schema>();
    private OQSFrameworkConfig defaultConfig;
    private long queryTimeout;
    private long refreshTime;
    private long initTime;
    private ScheduledExecutorService scheduler;
    private CdcConfig cdcConfig;
    private DictService dictService;
    private ExecutionConfig executionConfig;
    private final Counter inserCountTotal = Metrics.counter((String)"oqs.write.count.total", (String[])new String[]{"action", "build"});
    private final Counter replaceCountTotal = Metrics.counter((String)"oqs.write.count.total", (String[])new String[]{"action", "replace"});
    private final Counter deleteCountTotal = Metrics.counter((String)"oqs.write.count.total", (String[])new String[]{"action", "delete"});

    public SQLMasterStorage(PlatformTransactionManager manager, DataSource dataSource, ObjectMapper objectMapper, EntityClassEngine engine, DictService dictService, CdcConfig cdcConfig, ExecutionConfig executionConfig, long queryTimeout, long refreshTime, long initTime) {
        this.manager = manager;
        if (dataSource instanceof DynamicDataSource) {
            this.dynamicDataSource = (DynamicDataSource)dataSource;
        } else {
            this.masterDataSource = dataSource;
        }
        this.objectMapper = objectMapper;
        this.queryTimeout = queryTimeout;
        this.engine = engine;
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.refreshTime = refreshTime;
        this.initTime = initTime;
        this.template = new TransactionTemplate(manager);
        this.cdcConfig = cdcConfig;
        this.jdbcTemplate = new JdbcTemplate((DataSource)this.dynamicDataSource);
        this.dictService = dictService;
        this.executionConfig = executionConfig;
        this.prepareSchema();
    }

    public void setPublisher(EventPublisher publisher) {
        this.publisher = publisher;
    }

    private void prepareSchema() {
        PackageInternal packageInternal = this.dynamicDataSource.allMaster();
        packageInternal.getResourceMapping().forEach((k, v) -> this.oqsFrameworkConfigMap.put((String)k, new OQSFrameworkConfig((DataSource)v)));
        this.defaultConfig = new OQSFrameworkConfig((DataSource)((Object)this.dynamicDataSource.allMaster().getFirst()));
        this.scheduler.scheduleAtFixedRate(() -> {
            try {
                this.defaultConfig.getOqsSchema().getTableNames();
            }
            catch (Throwable throwable) {
                LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.UNKNOWN_ERROR, (String)"GetDataSourceSchema", (Throwable)throwable);
            }
            this.oqsFrameworkConfigMap.forEach((k, v) -> {
                try {
                    v.getOqsSchema().getTableNames();
                }
                catch (Throwable throwable) {
                    LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.UNKNOWN_ERROR, (String)"RefreshDataSourceSchema", (Throwable)throwable);
                }
            });
            log.debug("Trigger RefreshDataSourceSchema");
        }, this.initTime, this.refreshTime, TimeUnit.SECONDS);
    }

    private void checkId(IEntity entity) throws SQLException {
        if (entity.id() == 0L) {
            throw new SQLException("Invalid entity`s id.");
        }
    }

    @Timed(value="oqs.process.delay.latency", percentiles={0.5, 0.9, 0.99}, extraTags={"initiator", "master", "action", "build"})
    public boolean build(IEntity entity, IEntityClass entityClass, Map<String, Object> context) throws SQLException {
        EntityClassGroup group = this.engine.describe(entityClass, entityClass.profile());
        return this.writeProcessing(entity, group, Operation.BUILD, context);
    }

    @Timed(value="oqs.process.delay.latency", percentiles={0.5, 0.9, 0.99}, extraTags={"initiator", "master", "action", "builds"})
    public Boolean[] build(EntityPackage entityPackage, Map<String, Object> context) throws SQLException {
        return this.packageWriteProcessing(entityPackage, Operation.BUILD, context);
    }

    @Timed(value="oqs.process.delay.latency", percentiles={0.5, 0.9, 0.99}, extraTags={"initiator", "master", "action", "replace"})
    public boolean replace(IEntity entity, IEntityClass entityClass, Map<String, Object> context) throws SQLException {
        EntityClassGroup group = this.engine.describe(entityClass, entityClass.profile());
        return this.writeProcessing(entity, group, Operation.REPLACE, context);
    }

    @Timed(value="oqs.process.delay.latency", percentiles={0.5, 0.9, 0.99}, extraTags={"initiator", "master", "action", "replaces"})
    public Boolean[] replace(EntityPackage entityPackage, Map<String, Object> context) throws SQLException {
        return this.packageWriteProcessing(entityPackage, Operation.REPLACE, context);
    }

    @Override
    public int replaceByCondition(EntityPackage entityPackage, Map<String, Object> context) throws SQLException {
        return this.conditionalWriteProcessing(entityPackage, Operation.REPLACE_CON, context);
    }

    @Timed(value="oqs.process.delay.latency", percentiles={0.5, 0.9, 0.99}, extraTags={"initiator", "master", "action", "delete"})
    public boolean delete(IEntity entity, IEntityClass entityClass, Map<String, Object> context) throws SQLException {
        EntityClassGroup group = this.engine.describe(entityClass, entityClass.profile());
        return this.writeProcessing(entity, group, Operation.DELETE, context);
    }

    @Timed(value="oqs.process.delay.latency", percentiles={0.5, 0.9, 0.99}, extraTags={"initiator", "master", "action", "deletes"})
    public Boolean[] delete(EntityPackage entityPackage, Map<String, Object> context) throws SQLException {
        return this.packageWriteProcessing(entityPackage, Operation.DELETE, context);
    }

    @Override
    public DataIterator<Long> iterator(IEntityClass entityClass, long startTime, long endTime, long lastId, int size, boolean useSelfEntityClass) throws SQLException {
        this.dynamicDataSource.resetKey(entityClass.profile());
        return IdIterator.Builder.anEntityIterator().withDataSource(this.dynamicDataSource.currentDataSource()).withEntityClass(entityClass).withStartTime(startTime).withEndTime(endTime).witherTableName(entityClass.masterQueryTable()).witherBuffSize(size).withStartId(lastId).build();
    }

    @Override
    public DataIterator<OqsEngineEntity> iteratorEntity(IEntityClass entityClass, long startTime, long endTime, long lastId, int size, boolean useSelfEntityClass) throws SQLException {
        this.dynamicDataSource.resetKey(entityClass.profile());
        return OriginEntityIterator.Builder.anEntityIterator().withDataSource(this.dynamicDataSource.currentDataSource()).withEntityClass(entityClass).withStartTime(startTime).withEndTime(endTime).witherTableName(entityClass.masterQueryTable()).witherBuffSize(size).withEngine(this.engine).withStartId(lastId).build();
    }

    @Override
    public boolean rebuildIndex(final IEntityClass entityClass, final List<Long> ids) throws SQLException {
        this.dynamicDataSource.resetKey(entityClass.profile());
        return (Boolean)this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Boolean>(){

            public Boolean doInConnection(Connection con) throws SQLException, DataAccessException {
                Boolean[] rs = (Boolean[])RebuildExecutor.build(entityClass, con, 30000L).execute((Object)ids);
                boolean result = true;
                if (null != rs) {
                    Boolean[] booleanArray = rs;
                    int n = booleanArray.length;
                    for (int i = 0; i < n; ++i) {
                        boolean r = booleanArray[i];
                        if (r) continue;
                        result = false;
                        break;
                    }
                }
                return result;
            }
        });
    }

    public Collection<QueryResult> selectEntities(final SelectConfig selectConfig, final IEntityClass entityClass) throws SQLException {
        OQSFrameworkConfig temp = this.oqsFrameworkConfigMap.get(this.dynamicDataSource.currentKey());
        final OQSFrameworkConfig oqsFrameworkConfig = null == temp ? this.defaultConfig : temp;
        selectConfig.setScheme((Schema)oqsFrameworkConfig.getOqsSchema());
        return (Collection)this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Collection<QueryResult>>(){

            public Collection<QueryResult> doInConnection(Connection conn) throws SQLException, DataAccessException {
                MasterQueryResult result = null;
                result = (MasterQueryResult)ConditionQueryExecutor.build(SQLMasterStorage.this.engine, SQLMasterStorage.this.dictService, SQLMasterStorage.this.objectMapper, conn, SQLMasterStorage.this.queryTimeout, SQLMasterStorage.this.engine.describe(entityClass, selectConfig.getProfile()), oqsFrameworkConfig.getFrameworkConfig(), SQLMasterStorage.this.executionConfig.isUseStrictEnum(), SQLMasterStorage.this.executionConfig.getInClauseRewrite()).execute((Object)selectConfig);
                ArrayList<QueryResult> entities = new ArrayList<QueryResult>();
                if (!result.getValues().isEmpty()) {
                    List<String> fieldsNames = result.getFieldsNames();
                    for (List<Object> value : result.getValues()) {
                        QueryResult queryResult = new QueryResult(null);
                        ArrayList<QueryResult.SelectItem> items = new ArrayList<QueryResult.SelectItem>();
                        queryResult.setSelectItems(items);
                        for (int i = 0; i < fieldsNames.size(); ++i) {
                            String field = fieldsNames.get(i);
                            items.add(new QueryResult.SelectItem(field, field, value.get(i)));
                        }
                        entities.add(queryResult);
                    }
                }
                return entities;
            }
        });
    }

    private boolean checkResult(Boolean[] rs) {
        if (null == rs) {
            return false;
        }
        Boolean[] booleanArray = rs;
        int n = booleanArray.length;
        for (int i = 0; i < n; ++i) {
            boolean r = booleanArray[i];
            if (r) continue;
            return false;
        }
        return true;
    }

    private void publishAfterCreateEvent(IEntity entity, EntityClassGroup entityClassGroup, Map<String, Object> context) {
        if (this.publisher != null) {
            try {
                IEntityClass entityClass = entityClassGroup.getEntityClass();
                long id = entity.id();
                String code = entityClass.code();
                Map<String, Object> body = this.toMap(entity);
                this.publisher.publishEvent((Object)new EntityAfterCreate(code, Long.valueOf(id), this.toMap(entity), false, context));
                if (!this.cdcConfig.isEnabled() && !this.cdcConfig.isDisableEvent()) {
                    this.publisher.publishEvent((Object)new EntityCreated(code, Long.valueOf(id), body, false, context));
                }
            }
            catch (Throwable throwable) {
                LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.UNKNOWN_ERROR, (String)"AfterCreateEvent", (Throwable)throwable);
            }
        }
    }

    private void publishBeforeCreateEvent(IEntity entity, EntityClassGroup entityClassGroup, Map<String, Object> context) {
        if (this.publisher != null) {
            try {
                IEntityClass entityClass = entityClassGroup.getEntityClass();
                long id = entity.id();
                String code = entityClass.code();
                this.publisher.publishEvent((Object)new EntityBeforeCreate(code, id, false, this.toMap(entity), context));
            }
            catch (Throwable throwable) {
                LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.UNKNOWN_ERROR, (String)"BeforeCreateEvent", (Throwable)throwable);
            }
        }
    }

    private void publishAfterUpdateEvent(IEntity entity, EntityClassGroup entityClassGroup, Map<String, Object> context) {
        if (this.publisher != null) {
            try {
                IEntityClass entityClass = entityClassGroup.getEntityClass();
                long id = entity.id();
                String code = entityClass.code();
                Map<String, Object> body = this.toMap(entity);
                this.publisher.publishEvent((Object)new EntityAfterUpdate(code, Long.valueOf(id), Collections.emptyMap(), body, false, context));
                if (!this.cdcConfig.isEnabled() && !this.cdcConfig.isDisableEvent()) {
                    this.publisher.publishEvent((Object)new EntityUpdated(code, Long.valueOf(id), Collections.emptyMap(), body, false, context));
                }
            }
            catch (Throwable throwable) {
                LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.UNKNOWN_ERROR, (String)"AfterUpdateEvent", (Throwable)throwable);
            }
        }
    }

    private void publishBeforeUpdateEvent(IEntity entity, EntityClassGroup entityClassGroup, Map<String, Object> context) {
        if (this.publisher != null) {
            try {
                IEntityClass entityClass = entityClassGroup.getEntityClass();
                long id = entity.id();
                String code = entityClass.code();
                this.publisher.publishEvent((Object)new EntityBeforeUpdate(code, id, false, this.toMap(entity), context));
            }
            catch (Throwable throwable) {
                LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.UNKNOWN_ERROR, (String)"BeforeUpdateEvent", (Throwable)throwable);
            }
        }
    }

    private void publishAfterDeleteEvent(IEntity entity, EntityClassGroup entityClassGroup, Map<String, Object> context) {
        if (this.publisher != null) {
            try {
                IEntityClass entityClass = entityClassGroup.getEntityClass();
                long id = entity.id();
                String code = entityClass.code();
                this.publisher.publishEvent((Object)new EntityAfterDelete(code, Long.valueOf(id), Collections.emptyMap(), false, context));
                if (!this.cdcConfig.isEnabled() && !this.cdcConfig.isDisableEvent()) {
                    this.publisher.publishEvent((Object)new EntityDeleted(code, Long.valueOf(id), Collections.emptyMap(), false, context));
                }
            }
            catch (Throwable throwable) {
                LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.UNKNOWN_ERROR, (String)"AfterDeleteEvent", (Throwable)throwable);
            }
        }
    }

    private void publishBeforeDeleteEvent(IEntity entity, EntityClassGroup entityClassGroup, Map<String, Object> context) {
        if (this.publisher != null) {
            try {
                IEntityClass entityClass = entityClassGroup.getEntityClass();
                long id = entity.id();
                String code = entityClass.code();
                this.publisher.publishEvent((Object)new EntityBeforeDelete(code, id, false, context));
            }
            catch (Throwable throwable) {
                LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.UNKNOWN_ERROR, (String)"BeforeDeleteEvent", (Throwable)throwable);
            }
        }
    }

    private void publishBeforeMultiCreateEvent(EntityPackage entityPackage, Map<String, Object> context) {
        Map<Tuple2, List<Map.Entry>> grouped = entityPackage.stream().collect(Collectors.groupingBy(x -> Tuple.of((Object)((IEntityClass)x.getValue()).id(), (Object)((IEntityClass)x.getValue()).code())));
        grouped.forEach((k, v) -> {
            ArrayList bodies = new ArrayList();
            v.stream().forEach(x -> {
                IEntityClass targetEntityClass = (IEntityClass)x.getValue();
                if (this.publisher != null) {
                    try {
                        Map<String, Object> body = this.toMap((IEntity)x.getKey());
                        bodies.add(body);
                        this.publisher.publishEvent((Object)new EntityBeforeCreate(targetEntityClass.code(), ((IEntity)x.getKey()).id(), true, body, context));
                    }
                    catch (Throwable throwable) {
                        LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.UNKNOWN_ERROR, (String)"BeforeCreateEventInMulti", (Throwable)throwable);
                    }
                }
            });
            if (!bodies.isEmpty() && this.publisher != null) {
                try {
                    this.publisher.publishEvent((Object)new EntityBeforeMultiCreate((String)k._2, bodies, context));
                }
                catch (Throwable throwable) {
                    LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.UNKNOWN_ERROR, (String)"BeforeMultiCreateEvent", (Throwable)throwable);
                }
            }
        });
    }

    private void publishAfterMultiCreateEvent(EntityPackage entityPackage, Map<String, Object> context) {
        Map<Tuple2, List<Map.Entry>> grouped = entityPackage.stream().collect(Collectors.groupingBy(x -> Tuple.of((Object)((IEntityClass)x.getValue()).id(), (Object)((IEntityClass)x.getValue()).code())));
        grouped.forEach((k, v) -> {
            ArrayList bodies = new ArrayList();
            v.stream().forEach(x -> {
                IEntityClass targetEntityClass = (IEntityClass)x.getValue();
                if (this.publisher != null) {
                    Map<String, Object> body = this.toMap((IEntity)x.getKey());
                    bodies.add(body);
                    try {
                        this.publisher.publishEvent((Object)new EntityAfterCreate(targetEntityClass.code(), Long.valueOf(((IEntity)x.getKey()).id()), body, true, context));
                    }
                    catch (Throwable throwable) {
                        LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.UNKNOWN_ERROR, (String)"AfterCreateEventInMulti", (Throwable)throwable);
                    }
                    if (!this.cdcConfig.isEnabled() && !this.cdcConfig.isDisableEvent()) {
                        try {
                            this.publisher.publishEvent((Object)new EntityCreated(targetEntityClass.code(), Long.valueOf(((IEntity)x.getKey()).id()), body, true, context));
                        }
                        catch (Throwable throwable) {
                            LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.UNKNOWN_ERROR, (String)"CreateEventInMulti", (Throwable)throwable);
                        }
                    }
                }
            });
            if (!bodies.isEmpty() && this.publisher != null) {
                try {
                    this.publisher.publishEvent((Object)new EntityAfterMultiCreate((String)k._2, bodies, context));
                }
                catch (Throwable throwable) {
                    LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.UNKNOWN_ERROR, (String)"AfterMultiCreateEvent", (Throwable)throwable);
                }
                if (!this.cdcConfig.isEnabled() && !this.cdcConfig.isDisableEvent()) {
                    try {
                        this.publisher.publishEvent((Object)new EntityMultiCreated((String)k._2, bodies, context));
                    }
                    catch (Throwable throwable) {
                        LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.UNKNOWN_ERROR, (String)"MultiCreateEvent", (Throwable)throwable);
                    }
                }
            }
        });
    }

    private void publishBeforeConUpdateEvent(EntityPackage entityPackage, Map<String, Object> context) {
        IEntity requestBody = entityPackage.getExample();
        String targetCode = entityPackage.getTargetCode();
        ExpRel condition = entityPackage.getCondition();
        if (this.publisher != null) {
            try {
                this.publisher.publishEvent((Object)new EntityBeforeConUpdate(targetCode, condition, this.toMap(entityPackage.getExample()), context));
            }
            catch (Throwable throwable) {
                LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.UNKNOWN_ERROR, (String)"BeforeConUpdateEvent", (Throwable)throwable);
            }
        }
    }

    private void publishBeforeMultiUpdateEvent(EntityPackage entityPackage, Map<String, Object> context) {
        Map<Tuple2, List<Map.Entry>> grouped = entityPackage.stream().collect(Collectors.groupingBy(x -> Tuple.of((Object)((IEntityClass)x.getValue()).id(), (Object)((IEntityClass)x.getValue()).code())));
        grouped.forEach((k, v) -> {
            ArrayList bodies = new ArrayList();
            v.stream().forEach(x -> {
                IEntityClass targetEntityClass = (IEntityClass)x.getValue();
                if (this.publisher != null) {
                    try {
                        Map<String, Object> body = this.toMap((IEntity)x.getKey());
                        bodies.add(body);
                        this.publisher.publishEvent((Object)new EntityBeforeUpdate(targetEntityClass.code(), ((IEntity)x.getKey()).id(), true, body, context));
                    }
                    catch (Throwable throwable) {
                        LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.UNKNOWN_ERROR, (String)"BeforeUpdateEventInMulti", (Throwable)throwable);
                    }
                }
            });
            if (!bodies.isEmpty() && this.publisher != null) {
                try {
                    this.publisher.publishEvent((Object)new EntityBeforeMultiUpdate((String)k._2, bodies, context));
                }
                catch (Throwable throwable) {
                    LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.UNKNOWN_ERROR, (String)"BeforeMultiUpdateEvent", (Throwable)throwable);
                }
            }
        });
    }

    private void publishAfterMultiUpdateEvent(EntityPackage entityPackage, Map<String, Object> context) {
        Map<Tuple2, List<Map.Entry>> grouped = entityPackage.stream().collect(Collectors.groupingBy(x -> Tuple.of((Object)((IEntityClass)x.getValue()).id(), (Object)((IEntityClass)x.getValue()).code())));
        grouped.forEach((k, v) -> {
            ArrayList bodies = new ArrayList();
            v.stream().forEach(x -> {
                IEntityClass targetEntityClass = (IEntityClass)x.getValue();
                if (this.publisher != null) {
                    Map<String, Object> body = this.toMap((IEntity)x.getKey());
                    bodies.add(body);
                    try {
                        this.publisher.publishEvent((Object)new EntityAfterUpdate(targetEntityClass.code(), Long.valueOf(((IEntity)x.getKey()).id()), Collections.emptyMap(), body, true, context));
                    }
                    catch (Throwable throwable) {
                        LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.UNKNOWN_ERROR, (String)"AfterUpdateEventInMulti", (Throwable)throwable);
                    }
                    if (!this.cdcConfig.isEnabled() && !this.cdcConfig.isDisableEvent()) {
                        try {
                            this.publisher.publishEvent((Object)new EntityUpdated(targetEntityClass.code(), Long.valueOf(((IEntity)x.getKey()).id()), Collections.emptyMap(), body, true, context));
                        }
                        catch (Throwable throwable) {
                            LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.UNKNOWN_ERROR, (String)"UpdateEventInMulti", (Throwable)throwable);
                        }
                    }
                }
            });
            if (!bodies.isEmpty() && this.publisher != null) {
                try {
                    this.publisher.publishEvent((Object)new EntityAfterMultiUpdate((String)k._2, bodies.stream().map(x -> Tuple.of(Collections.emptyMap(), (Object)x)).collect(Collectors.toList()), context));
                }
                catch (Throwable throwable) {
                    LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.UNKNOWN_ERROR, (String)"AfterMultiUpdateEvent", (Throwable)throwable);
                }
                if (!this.cdcConfig.isEnabled() && !this.cdcConfig.isDisableEvent()) {
                    try {
                        this.publisher.publishEvent((Object)new EntityMultiUpdated((String)k._2, bodies.stream().map(x -> Tuple.of(Collections.emptyMap(), (Object)x)).collect(Collectors.toList()), context));
                    }
                    catch (Throwable throwable) {
                        LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.UNKNOWN_ERROR, (String)"MultiUpdateEvent", (Throwable)throwable);
                    }
                }
            }
        });
    }

    private void publishAfterMultiDeletedEvent(EntityPackage entityPackage, Map<String, Object> context) {
        Map<Tuple2, List<Map.Entry>> grouped = entityPackage.stream().collect(Collectors.groupingBy(x -> Tuple.of((Object)((IEntityClass)x.getValue()).id(), (Object)((IEntityClass)x.getValue()).code())));
        grouped.forEach((k, v) -> {
            ArrayList bodies = new ArrayList();
            v.stream().forEach(x -> {
                IEntityClass targetEntityClass = (IEntityClass)x.getValue();
                if (this.publisher != null) {
                    Map<String, Object> body = this.toMap((IEntity)x.getKey());
                    bodies.add(body);
                    try {
                        this.publisher.publishEvent((Object)new EntityAfterDelete(targetEntityClass.code(), Long.valueOf(((IEntity)x.getKey()).id()), Collections.emptyMap(), true, context));
                    }
                    catch (Throwable throwable) {
                        LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.UNKNOWN_ERROR, (String)"AfterDeleteEventInMulti", (Throwable)throwable);
                    }
                    if (!this.cdcConfig.isEnabled() && !this.cdcConfig.isDisableEvent()) {
                        try {
                            this.publisher.publishEvent((Object)new EntityDeleted(targetEntityClass.code(), Long.valueOf(((IEntity)x.getKey()).id()), Collections.emptyMap(), true, context));
                        }
                        catch (Throwable throwable) {
                            LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.UNKNOWN_ERROR, (String)"DeleteEventInMulti", (Throwable)throwable);
                        }
                    }
                }
            });
            if (!bodies.isEmpty() && this.publisher != null) {
                try {
                    this.publisher.publishEvent((Object)new EntityAfterMultiDelete((String)k._2, bodies, context));
                }
                catch (Throwable throwable) {
                    LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.UNKNOWN_ERROR, (String)"AfterMultiDeleteEvent", (Throwable)throwable);
                }
                if (!this.cdcConfig.isEnabled() && !this.cdcConfig.isDisableEvent()) {
                    try {
                        this.publisher.publishEvent((Object)new EntityMultiDeleted((String)k._2, bodies, context));
                    }
                    catch (Throwable throwable) {
                        LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.UNKNOWN_ERROR, (String)"MultiDeleteEvent", (Throwable)throwable);
                    }
                }
            }
        });
    }

    private void publishBeforeMultiDeleteEvent(EntityPackage entityPackage, Map<String, Object> context) {
        Map<Tuple2, List<Map.Entry>> grouped = entityPackage.stream().collect(Collectors.groupingBy(x -> Tuple.of((Object)((IEntityClass)x.getValue()).id(), (Object)((IEntityClass)x.getValue()).code())));
        grouped.forEach((k, v) -> {
            ArrayList bodies = new ArrayList();
            v.stream().forEach(x -> {
                IEntityClass targetEntityClass = (IEntityClass)x.getValue();
                if (this.publisher != null) {
                    bodies.add(((IEntity)x.getKey()).id());
                    try {
                        this.publisher.publishEvent((Object)new EntityBeforeDelete(targetEntityClass.code(), ((IEntity)x.getKey()).id(), true, context));
                    }
                    catch (Throwable throwable) {
                        LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.UNKNOWN_ERROR, (String)"BeforeDeleteEventInMulti", (Throwable)throwable);
                    }
                }
            });
            if (!bodies.isEmpty() && this.publisher != null) {
                try {
                    this.publisher.publishEvent((Object)new EntityBeforeMultiDelete((String)k._2, bodies, context));
                }
                catch (Throwable throwable) {
                    LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.UNKNOWN_ERROR, (String)"BeforeMultiDeleteEvent", (Throwable)throwable);
                }
            }
        });
    }

    private Map<String, Object> toMap(IEntity entity) {
        IEntityValue iEntityValue = entity.entityValue();
        HashMap<String, Object> payload = new HashMap<String, Object>();
        if (iEntityValue != null) {
            iEntityValue.values().forEach(x -> {
                String name = x.getField().name();
                Object value = x.getValue();
                payload.put(name, value);
            });
        }
        return payload;
    }

    private boolean writeProcessing(final IEntity entity, final EntityClassGroup entityClass, final Operation op, final Map<String, Object> context) throws SQLException {
        this.checkId(entity);
        boolean result = (Boolean)this.template.execute(status -> (Boolean)this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Boolean>(){

            public Boolean doInConnection(Connection con) throws SQLException, DataAccessException {
                Boolean[] rs;
                List masterStorageEntities = SQLMasterStorage.this.toMasterStorageEntities(entityClass, entity, op);
                switch (op) {
                    case BUILD: {
                        SQLMasterStorage.this.publishBeforeCreateEvent(entity, entityClass, context);
                        rs = (Boolean[])CreateExecutor.build(con, SQLMasterStorage.this.queryTimeout).execute((Object)masterStorageEntities);
                        SQLMasterStorage.this.publishAfterCreateEvent(entity, entityClass, context);
                        SQLMasterStorage.this.inserCountTotal.increment();
                        break;
                    }
                    case REPLACE: {
                        SQLMasterStorage.this.publishBeforeUpdateEvent(entity, entityClass, context);
                        rs = (Boolean[])UpdateExecutor.build(con, SQLMasterStorage.this.queryTimeout).execute((Object)masterStorageEntities);
                        SQLMasterStorage.this.publishAfterUpdateEvent(entity, entityClass, context);
                        SQLMasterStorage.this.replaceCountTotal.increment();
                        break;
                    }
                    case DELETE: {
                        SQLMasterStorage.this.publishBeforeDeleteEvent(entity, entityClass, context);
                        Object userCode = context.get("USER_DISPLAYNAME");
                        Object userId = context.get("ID");
                        rs = (Boolean[])DeleteExecutor.build(con, SQLMasterStorage.this.queryTimeout, SQLMasterStorage.this.cdcConfig.getRecordUser(), Optional.ofNullable(userCode).map(x -> x.toString()).filter(x -> !StringUtils.isEmpty((CharSequence)x)).orElseGet(() -> Optional.ofNullable(context.get("USER_LOGINNAME")).map(x -> x.toString()).orElse("")), Optional.ofNullable(userId).map(Object::toString).map(Long::parseLong).orElse(null)).execute((Object)masterStorageEntities);
                        SQLMasterStorage.this.publishAfterDeleteEvent(entity, entityClass, context);
                        SQLMasterStorage.this.deleteCountTotal.increment();
                        break;
                    }
                    default: {
                        rs = null;
                    }
                }
                if (SQLMasterStorage.this.publisher != null) {
                    EntityClassRef entityClassRef = entity.entityClassRef();
                    SQLMasterStorage.this.publisher.publishEvent((Object)new EntityChanged(Collections.singletonList(Tuple.of((Object)entityClassRef.getProfile(), (Object)entityClassRef.getId())), entity.time()));
                }
                return SQLMasterStorage.this.checkResult(rs);
            }
        }));
        if (result) {
            entity.neat();
        }
        return result;
    }

    private int conditionalWriteProcessing(final EntityPackage entityPackage, final Operation op, final Map<String, Object> context) {
        OQSFrameworkConfig temp = this.oqsFrameworkConfigMap.get(this.dynamicDataSource.currentKey());
        final OQSFrameworkConfig oqsFrameworkConfig = null == temp ? this.defaultConfig : temp;
        return (Integer)this.template.execute(status -> (Integer)this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Integer>(){

            public Integer doInConnection(Connection con) throws SQLException, DataAccessException {
                if (SQLMasterStorage.this.publisher != null) {
                    switch (op) {
                        case REPLACE_CON: {
                            SQLMasterStorage.this.publishBeforeConUpdateEvent(entityPackage, context);
                        }
                    }
                }
                int affectedRow = 0;
                int temp = 0;
                ConditionalStoragePackage storagePackage = SQLMasterStorage.this.toRelatedStatement(entityPackage, oqsFrameworkConfig, context);
                switch (op) {
                    case REPLACE_CON: {
                        temp = (Integer)ConditionalReplaceExecutor.build(con, SQLMasterStorage.this.queryTimeout).execute((Object)storagePackage);
                        if (temp < affectedRow) break;
                        affectedRow = temp;
                        break;
                    }
                }
                return affectedRow;
            }
        }));
    }

    private ConditionalStoragePackage toRelatedStatement(EntityPackage entityPackage, OQSFrameworkConfig targetConfig, Map<String, Object> context) {
        ConditionalStoragePackage storagePackage = new ConditionalStoragePackage();
        IEntityClass targetEntityClass = entityPackage.getTargetEntityClass();
        EntityClassGroup group = this.engine.describe(targetEntityClass, targetEntityClass.realProfile());
        List<MasterStorageEntity> masterStorageEntities = this.toMasterStorageEntities(group, entityPackage.getExample(), Operation.REPLACE);
        ExpRel condition = entityPackage.getCondition();
        ExpContext expContext = new ExpContext();
        expContext.setSchema(group);
        expContext.withContext(context);
        RelNode relTree = ExpTreeToRel.toRelTree((ExpContext)expContext, (ExpRel)condition, (FrameworkConfig)this.config, (ExecutionConfig)this.executionConfig);
        RelBuilder relBuilder = RelBuilder.create((FrameworkConfig)targetConfig.getFrameworkConfig());
        String masterWriteTable = group.getEntityClass().masterWriteTable(false);
        String mainTable = group.getJoinTable(masterWriteTable);
        storagePackage.setMainTableName(mainTable);
        ConditionalSqlShuttle conditionalSqlShuttle = new ConditionalSqlShuttle(group, relBuilder, masterWriteTable, this.dictService, this.executionConfig);
        relTree.accept((RelShuttle)conditionalSqlShuttle);
        storagePackage.setLimit(conditionalSqlShuttle.getLimit());
        String conditonaSql = conditionalSqlShuttle.getConditionSql();
        storagePackage.setConditionSql(conditonaSql);
        List<ConditionalStorageEntity> conditionalStorageList = masterStorageEntities.stream().map(x -> {
            String tableName = x.getTableName();
            String joinTable = group.getJoinTable(tableName);
            ConditionalStorageEntity storageEntity = new ConditionalStorageEntity(tableName, joinTable, conditonaSql, 0, (MasterStorageEntity)x);
            return storageEntity;
        }).collect(Collectors.toList());
        storagePackage.setConditionalStorageList(conditionalStorageList);
        return storagePackage;
    }

    private Boolean[] packageWriteProcessing(final EntityPackage entityPackage, final Operation op, final Map<String, Object> context) throws SQLException {
        return (Boolean[])this.template.execute(status -> (Boolean[])this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Boolean[]>(){

            public Boolean[] doInConnection(Connection con) throws SQLException, DataAccessException {
                ArrayList executionPackages = new ArrayList();
                entityPackage.stream().forEach(er -> {
                    EntityClassGroup group = SQLMasterStorage.this.engine.describe((IEntityClass)er.getValue(), ((IEntityClass)er.getValue()).profile());
                    executionPackages.addAll(SQLMasterStorage.this.toMasterStorageEntities(group, (IEntity)er.getKey(), op));
                });
                List executionPart = Lists.partition(executionPackages, (int)EntityPackage.MAX_SIZE);
                if (SQLMasterStorage.this.publisher != null) {
                    switch (op) {
                        case BUILD: {
                            SQLMasterStorage.this.publishBeforeMultiCreateEvent(entityPackage, context);
                            break;
                        }
                        case REPLACE: {
                            SQLMasterStorage.this.publishBeforeMultiUpdateEvent(entityPackage, context);
                            break;
                        }
                        case REPLACE_CON: {
                            SQLMasterStorage.this.publishBeforeConUpdateEvent(entityPackage, context);
                            break;
                        }
                        case DELETE: {
                            SQLMasterStorage.this.publishBeforeMultiDeleteEvent(entityPackage, context);
                        }
                    }
                }
                ArrayList<Boolean[]> resultSet = new ArrayList<Boolean[]>();
                for (List parts : executionPart) {
                    switch (op) {
                        case BUILD: {
                            Boolean[] execute = (Boolean[])CreateExecutor.build(con, SQLMasterStorage.this.queryTimeout).execute((Object)parts);
                            resultSet.add(execute);
                            SQLMasterStorage.this.inserCountTotal.increment((double)Arrays.stream(execute).filter(x -> x).count());
                            break;
                        }
                        case REPLACE: {
                            Boolean[] execute = (Boolean[])UpdateExecutor.build(con, SQLMasterStorage.this.queryTimeout).execute((Object)parts);
                            resultSet.add(execute);
                            SQLMasterStorage.this.replaceCountTotal.increment((double)Arrays.stream(execute).filter(x -> x).count());
                            break;
                        }
                        case DELETE: {
                            Object userCode = context.get("USER_DISPLAYNAME");
                            Object userId = context.get("ID");
                            Boolean[] execute = (Boolean[])DeleteExecutor.build(con, SQLMasterStorage.this.queryTimeout, SQLMasterStorage.this.cdcConfig.getRecordUser(), Optional.ofNullable(userCode).map(x -> x.toString()).orElse(null), Optional.ofNullable(userId).map(Object::toString).map(Long::parseLong).orElse(null)).execute((Object)parts);
                            resultSet.add(execute);
                            SQLMasterStorage.this.deleteCountTotal.increment((double)Arrays.stream(execute).filter(x -> x).count());
                            break;
                        }
                    }
                }
                if (SQLMasterStorage.this.publisher != null) {
                    try {
                        List list = entityPackage.stream().map(entry -> {
                            String profile = ((IEntity)entry.getKey()).entityClassRef().getProfile();
                            long entityClassId = ((IEntity)entry.getKey()).entityClassRef().getId();
                            return Tuple.of((Object)profile, (Object)entityClassId);
                        }).collect(Collectors.toList());
                        if (!list.isEmpty()) {
                            SQLMasterStorage.this.publisher.publishEvent((Object)new EntityChanged(list, ((IEntity)((Map.Entry)entityPackage.get(0).get()).getKey()).time()));
                        }
                    }
                    catch (Throwable throwable) {
                        log.error("{}", throwable);
                    }
                }
                switch (op) {
                    case BUILD: {
                        SQLMasterStorage.this.publishAfterMultiCreateEvent(entityPackage, context);
                        break;
                    }
                    case REPLACE: {
                        SQLMasterStorage.this.publishAfterMultiUpdateEvent(entityPackage, context);
                        break;
                    }
                    case DELETE: {
                        SQLMasterStorage.this.publishAfterMultiDeletedEvent(entityPackage, context);
                    }
                }
                return SQLMasterStorage.this.flatten(resultSet);
            }
        }));
    }

    private Boolean[] flatten(List<Boolean[]> resultSet) {
        return (Boolean[])resultSet.stream().flatMap(x -> Arrays.stream(x)).toArray(Boolean[]::new);
    }

    private List<MasterStorageEntity.TypedStorageValue> extractBocpSystemField(EntityClassGroup group, IEntity entity) {
        Collection allFields = group.getAllFields();
        ArrayList<MasterStorageEntity.TypedStorageValue> values = new ArrayList<MasterStorageEntity.TypedStorageValue>();
        for (IEntityField entityField : allFields) {
            Optional valueOp;
            Optional<SystemField> systemField = Arrays.stream(SystemField.values()).filter(x -> x.getName().equalsIgnoreCase(entityField.name())).findFirst();
            if (!systemField.isPresent() || !(valueOp = entity.entityValue().getValue(entityField)).isPresent()) continue;
            values.add(new MasterStorageEntity.TypedStorageValue(entityField, ((IValue)valueOp.get()).storageValue()));
        }
        return values;
    }

    private MasterStorageEntity merge(MasterStorageEntity entity, List<MasterStorageEntity.TypedStorageValue> values) {
        MasterStorageEntity masterStorageEntity = new MasterStorageEntity();
        masterStorageEntity.setTableName(entity.getTableName());
        masterStorageEntity.setBusinessDynamicFields(entity.getBusinessDynamicFields());
        masterStorageEntity.setSystemColumn(entity.getSystemColumn());
        ArrayList<MasterStorageEntity.TypedStorageValue> mergedValues = new ArrayList<MasterStorageEntity.TypedStorageValue>(values);
        Optional.ofNullable(entity.getBusinessStaticFields()).orElseGet(Collections::emptyList).stream().filter(x -> values.stream().noneMatch(v -> v.getEntityField().id() == x.getEntityField().id())).forEach(x -> mergedValues.add((MasterStorageEntity.TypedStorageValue)x));
        masterStorageEntity.setBusinessStaticFields(mergedValues);
        masterStorageEntity.setBusinessDynamicFieldsRemove(entity.getBusinessDynamicFieldsRemove());
        return masterStorageEntity;
    }

    private List<MasterStorageEntity> toMasterStorageEntities(EntityClassGroup group, IEntity entity, Operation op) {
        ArrayList<MasterStorageEntity> masterStorageEntities = new ArrayList<MasterStorageEntity>();
        List<MasterStorageEntity.TypedStorageValue> values = this.extractBocpSystemField(group, entity);
        List<MasterStorageEntity> masterStorageEntity = this.toMasterStorageEntity(group.getEntityClass(), entity, op);
        masterStorageEntity.stream().map(x -> this.merge((MasterStorageEntity)x, values)).forEach(masterStorageEntities::add);
        if (null != group.getFatherEntityClass() && !group.getFatherEntityClass().isEmpty()) {
            Collection entityClasses = group.getFatherEntityClass();
            for (IEntityClass e : entityClasses) {
                List<MasterStorageEntity> multiMaster = this.toMasterStorageEntity(e, entity, op);
                multiMaster.stream().map(x -> this.merge((MasterStorageEntity)x, values)).forEach(masterStorageEntities::add);
            }
        }
        if (masterStorageEntities.size() > 1 && op == Operation.BUILD) {
            HashMap<String, Integer> attachment = new HashMap<String, Integer>();
            attachment.put("grouped", masterStorageEntities.size());
            masterStorageEntities.forEach(x -> {
                Map map = MasterStorageHelper.buildFromJson((String)x.getBusinessDynamicFields());
                map.put("#a", attachment);
                x.setBusinessDynamicFields(MasterStorageHelper.toBuildJson((Map)map));
            });
        }
        return masterStorageEntities;
    }

    private List<MasterStorageEntity> toMasterStorageEntity(IEntityClass e, IEntity entity, Operation op) {
        String profile = e.realProfile();
        if (StringUtils.isEmpty((CharSequence)profile)) {
            Collection selfFields = e.selfWithIndex();
            MasterStorageEntity masterStorageEntity = new MasterStorageEntity();
            SystemColumn systemColumn = new SystemColumn();
            systemColumn.setProfile(e.profile());
            systemColumn.setOperateTime(entity.time());
            systemColumn.setEntityClass(entity.entityClassRef().getId());
            systemColumn.setId(entity.id());
            masterStorageEntity.setSystemColumn(systemColumn);
            masterStorageEntity.setTableName(e.masterWriteTable(false));
            ArrayList<MasterStorageEntity.TypedStorageValue> staticValues = new ArrayList<MasterStorageEntity.TypedStorageValue>();
            if (!op.equals((Object)Operation.DELETE)) {
                ArrayList dynamicValues = new ArrayList();
                for (IEntityField entityField : selfFields) {
                    Optional valueOp = entity.entityValue().getValue(entityField);
                    if (!valueOp.isPresent()) continue;
                    if (entityField.isDynamic()) {
                        dynamicValues.add(valueOp.get());
                        continue;
                    }
                    if (entityField.type() == FieldType.ENUMS && this.executionConfig.isUseStrictEnum()) {
                        String[] values = (String[])((EnumsValue)valueOp.get()).getValue();
                        staticValues.add(new MasterStorageEntity.TypedStorageValue(entityField, this.getEnumBit(entityField.dictId(), Arrays.asList(values)), true));
                        continue;
                    }
                    staticValues.add(new MasterStorageEntity.TypedStorageValue(entityField, ((IValue)valueOp.get()).storageValue()));
                }
                masterStorageEntity.setBusinessStaticFields(staticValues);
                Map painValues = MasterStorageHelper.toPainValues(dynamicValues);
                if (op.equals((Object)Operation.REPLACE)) {
                    masterStorageEntity.setBusinessDynamicFields(MasterStorageHelper.buildReplace((Map)painValues, this.mySQLCodec));
                    masterStorageEntity.setBusinessDynamicFieldsRemove(MasterStorageHelper.buildRemove((Map)painValues));
                } else {
                    masterStorageEntity.setBusinessDynamicFields(MasterStorageHelper.toBuildJson((Map)painValues));
                }
                systemColumn.setDeleted(false);
            } else {
                systemColumn.setDeleted(true);
            }
            return Collections.singletonList(masterStorageEntity);
        }
        ArrayList<MasterStorageEntity> masterStorageEntities = new ArrayList<MasterStorageEntity>();
        Collection selfFields = e.selfWithIndex();
        ArrayList<IEntityField> pureSelfFields = new ArrayList<IEntityField>();
        ArrayList<IEntityField> profileFields = new ArrayList<IEntityField>();
        for (IEntityField selfField : selfFields) {
            String realProfile = selfField.realProfile();
            if (StringUtils.isEmpty((CharSequence)realProfile)) {
                pureSelfFields.add(selfField);
                continue;
            }
            profileFields.add(selfField);
        }
        MasterStorageEntity masterStorageEntity = new MasterStorageEntity();
        SystemColumn systemColumn = new SystemColumn();
        systemColumn.setProfile(profile);
        systemColumn.setOperateTime(entity.time());
        systemColumn.setEntityClass(e.id());
        systemColumn.setId(entity.id());
        masterStorageEntity.setSystemColumn(systemColumn);
        masterStorageEntity.setTableName(e.masterWriteTable(false));
        ArrayList<MasterStorageEntity.TypedStorageValue> staticValues = new ArrayList<MasterStorageEntity.TypedStorageValue>();
        if (!op.equals((Object)Operation.DELETE)) {
            ArrayList dynamicValues = new ArrayList();
            for (IEntityField entityField : pureSelfFields) {
                Optional valueOp = entity.entityValue().getValue(entityField);
                if (!valueOp.isPresent()) continue;
                if (entityField.isDynamic()) {
                    dynamicValues.add(valueOp.get());
                    continue;
                }
                staticValues.add(new MasterStorageEntity.TypedStorageValue(entityField, ((IValue)valueOp.get()).storageValue()));
            }
            masterStorageEntity.setBusinessStaticFields(staticValues);
            Map painValues = MasterStorageHelper.toPainValues(dynamicValues);
            if (op.equals((Object)Operation.REPLACE)) {
                masterStorageEntity.setBusinessDynamicFields(MasterStorageHelper.buildReplace((Map)painValues, this.mySQLCodec));
                masterStorageEntity.setBusinessDynamicFieldsRemove(MasterStorageHelper.buildRemove((Map)painValues));
            } else {
                masterStorageEntity.setBusinessDynamicFields(MasterStorageHelper.toBuildJson((Map)painValues));
            }
            systemColumn.setDeleted(false);
        } else {
            systemColumn.setDeleted(true);
        }
        masterStorageEntities.add(masterStorageEntity);
        MasterStorageEntity masterStorageEntityProfile = new MasterStorageEntity();
        SystemColumn systemColumnProfile = new SystemColumn();
        systemColumnProfile.setProfile(e.profile());
        systemColumnProfile.setOperateTime(entity.time());
        systemColumnProfile.setEntityClass(e.id());
        systemColumnProfile.setId(entity.id());
        masterStorageEntityProfile.setSystemColumn(systemColumnProfile);
        masterStorageEntityProfile.setTableName(e.masterWriteTable(true));
        ArrayList<MasterStorageEntity.TypedStorageValue> staticValuesProfile = new ArrayList<MasterStorageEntity.TypedStorageValue>();
        if (!op.equals((Object)Operation.DELETE)) {
            ArrayList dynamicValues = new ArrayList();
            for (IEntityField entityField : profileFields) {
                Optional valueOp = entity.entityValue().getValue(entityField);
                if (!valueOp.isPresent()) continue;
                if (entityField.isDynamic()) {
                    dynamicValues.add(valueOp.get());
                    continue;
                }
                staticValuesProfile.add(new MasterStorageEntity.TypedStorageValue(entityField, ((IValue)valueOp.get()).storageValue()));
            }
            masterStorageEntityProfile.setBusinessStaticFields(staticValuesProfile);
            Map painValues = MasterStorageHelper.toPainValues(dynamicValues);
            if (op.equals((Object)Operation.REPLACE)) {
                masterStorageEntityProfile.setBusinessDynamicFields(MasterStorageHelper.buildReplace((Map)painValues, this.mySQLCodec));
                masterStorageEntityProfile.setBusinessDynamicFieldsRemove(MasterStorageHelper.buildRemove((Map)painValues));
            } else {
                masterStorageEntityProfile.setBusinessDynamicFields(MasterStorageHelper.toBuildJson((Map)painValues));
            }
            systemColumnProfile.setDeleted(false);
        } else {
            systemColumnProfile.setDeleted(true);
        }
        masterStorageEntities.add(masterStorageEntityProfile);
        return masterStorageEntities;
    }

    private int getEnumBit(String enumId, List<String> values) {
        List dictItems = this.dictService.findDictItems(enumId, null, Collections.emptyMap());
        Optional<Integer> reduce = values.stream().map(x -> this.dictService.findEnumIndex(dictItems, x)).reduce((a, b) -> a | b);
        return reduce.orElse(0);
    }

    private static final class OQSFrameworkConfig {
        private SchemaPlus rootSchema = CalciteSchema.createRootSchema((boolean)true, (boolean)false).plus();
        private JdbcSchema oqsSchema;
        private FrameworkConfig frameworkConfig;

        public OQSFrameworkConfig(DataSource dataSource) {
            this.oqsSchema = JdbcSchema.create((SchemaPlus)this.rootSchema, (String)"oqs", (DataSource)dataSource, null, null);
            this.rootSchema.add("oqs", (Schema)this.oqsSchema);
            Frameworks.ConfigBuilder configBuilder = Frameworks.newConfigBuilder();
            this.frameworkConfig = configBuilder.defaultSchema(this.rootSchema).parserConfig(SqlParser.config().withLex(Lex.MYSQL).withCaseSensitive(false)).context(new Context(){

                public <C> C unwrap(Class<C> aClass) {
                    if (aClass == RelBuilder.Config.class) {
                        return (C)RelBuilder.Config.DEFAULT.withSimplify(false);
                    }
                    return null;
                }
            }).build();
        }

        public JdbcSchema getOqsSchema() {
            return this.oqsSchema;
        }

        public SchemaPlus getRootSchema() {
            return this.rootSchema;
        }

        public FrameworkConfig getFrameworkConfig() {
            return this.frameworkConfig;
        }
    }
}

