/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.master.mysql.calcite;

import com.xforceplus.metadata.schema.typed.BoIndex;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.legacy.impl.ColumnField;
import com.xforceplus.ultraman.metadata.service.DictService;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.MysqlSqlDialectEx;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.query.CopyVisitor;
import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.table.SystemColumn;
import com.xforceplus.ultraman.sdk.core.config.ExecutionConfig;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSqlConvertletTable;
import org.apache.calcite.rex.RexSqlStandardConvertletTable;
import org.apache.calcite.rex.RexToSqlNodeConverterImpl;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.util.SqlString;
import org.apache.calcite.tools.RelBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ConditionalSqlShuttle
extends RelShuttleImpl {
    private RelBuilder builder;
    private String targetCode;
    private String conditionSql;
    private EntityClassGroup targetGroup;
    private int limit;
    private ExecutionConfig executionConfig;
    private DictService dictService;

    public ConditionalSqlShuttle(EntityClassGroup targetGroup, RelBuilder builder, String targetCode, DictService dictService, ExecutionConfig executionConfig) {
        this.builder = builder;
        this.targetCode = targetCode;
        this.targetGroup = targetGroup;
        this.executionConfig = executionConfig;
        this.dictService = dictService;
    }

    public int getLimit() {
        return this.limit;
    }

    public String getConditionSql() {
        return this.conditionSql;
    }

    public RelNode visit(LogicalSort sort) {
        RexNode fetch = sort.fetch;
        if (fetch != null) {
            RexLiteral literal = (RexLiteral)fetch;
            this.limit = (Integer)literal.getValueAs(Integer.class);
        }
        return super.visit(sort);
    }

    public RelNode visit(TableScan scan) {
        this.builder = this.builder.scan(new String[]{"oqs", this.targetGroup.getEntityClass().masterQueryTable().toLowerCase()});
        return super.visit(scan);
    }

    public RelNode visit(LogicalFilter filter) {
        SqlNode sqlNode;
        CopyVisitor copyVisitor;
        RelNode visit = super.visit(filter);
        MyConverter rexToSqlNodeConverter = new MyConverter((RelNode)filter);
        RexCall condition = (RexCall)filter.getCondition();
        RexNode finalNode = (RexNode)condition.accept((RexVisitor)(copyVisitor = new CopyVisitor(this.builder, Collections.singletonList(this.targetGroup), (RelNode)filter, this.executionConfig.isUseStrictEnum(), this.dictService, this.executionConfig.getInClauseRewrite())));
        if (finalNode != null && (sqlNode = rexToSqlNodeConverter.convertCall((RexCall)finalNode)) != null) {
            SqlString sqlString = sqlNode.toSqlString(MysqlSqlDialectEx.DEFAULT);
            this.conditionSql = sqlString.getSql();
        }
        return visit;
    }

    class MyConverter
    extends RexToSqlNodeConverterImpl {
        private RelNode relNode;
        private String targetCode;

        public MyConverter(RelNode relNode) {
            super((RexSqlConvertletTable)new RexSqlStandardConvertletTable());
            this.relNode = relNode;
        }

        public @Nullable SqlNode convertInputRef(RexInputRef ref) {
            Optional column;
            int index = ref.getIndex();
            RelDataTypeField relDataTypeField = (RelDataTypeField)ConditionalSqlShuttle.this.builder.peek().getRowType().getFieldList().get(index);
            String name = relDataTypeField.getName();
            if (SystemColumn.SYSTEM_WORDS.contains(name)) {
                name = this.targetCode.concat(".").concat(relDataTypeField.getName());
            }
            if ((column = ConditionalSqlShuttle.this.targetGroup.column(name)).isPresent()) {
                Stream fatherIndexStream;
                ColumnField columnField = (ColumnField)column.get();
                Stream selfIndexStream = ConditionalSqlShuttle.this.targetGroup.getEntityClass().indexes().stream();
                Optional<BoIndex> any = Stream.concat(selfIndexStream, fatherIndexStream = ConditionalSqlShuttle.this.targetGroup.getFatherEntityClass().stream().flatMap(x -> x.indexes().stream())).filter(x -> x.getName().equals(columnField.name())).findAny();
                if (any.isPresent()) {
                    name = this.targetCode.concat(".").concat(name);
                }
            }
            return new SqlIdentifier(name, SqlParserPos.QUOTED_ZERO);
        }
    }
}

