/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.master.mysql.devops;

import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.plus.common.StringUtils;
import com.xforceplus.ultraman.oqsengine.plus.common.executor.Executor;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor.AbstractMasterTaskExecutor;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public class RebuildExecutor
extends AbstractMasterTaskExecutor<List<Long>, Boolean[]> {
    private IEntityClass entityClass;

    public RebuildExecutor(IEntityClass entityClass, Connection connection, long timeout) throws SQLException {
        super(connection, timeout);
        this.entityClass = entityClass;
    }

    public static Executor<List<Long>, Boolean[]> build(IEntityClass entityClass, Connection connection, long timeout) throws SQLException {
        return new RebuildExecutor(entityClass, connection, timeout);
    }

    public Boolean[] execute(List<Long> ids) throws SQLException {
        long sysTime = System.currentTimeMillis();
        try (Statement st = this.getConnection().createStatement();){
            for (Long id : ids) {
                for (IEntityClass self = this.entityClass; null != self; self = self.extendEntityClass()) {
                    this.addBatch(self, sysTime, id, st);
                }
            }
            Boolean[] booleanArray = this.executedUpdate(st, true);
            return booleanArray;
        }
    }

    private void addBatch(IEntityClass entityClass, long sysTime, long id, Statement st) throws SQLException {
        if (null != entityClass) {
            String table = entityClass.masterWriteTable(false);
            st.addBatch(this.buildSql(table, sysTime, id));
            String profileTable = null;
            if (!StringUtils.isEmpty((String)entityClass.realProfile())) {
                profileTable = entityClass.masterWriteTable(true);
                st.addBatch(this.buildSql(profileTable, sysTime, id));
            }
        }
    }

    private String buildSql(String table, long sysTime, long id) {
        String base = String.format("UPDATE %s SET ", table) + "_sys_ver" + "=" + "_sys_ver" + "+1, " + "_sys_operatetime" + "=%d where id=%d";
        return String.format(base, sysTime, id);
    }
}

