/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor;

import com.xforceplus.ultraman.oqsengine.plus.common.StringUtils;
import com.xforceplus.ultraman.oqsengine.plus.common.executor.Executor;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.ConditionalStorageEntity;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.ConditionalStoragePackage;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.MasterStorageEntity;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.StorageType;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor.AbstractMasterTaskExecutor;
import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.table.SystemColumn;
import com.xforceplus.ultraman.sdk.core.utils.MasterStorageHelper;
import com.xforceplus.ultraman.sdk.infra.codec.MySQLCodecCustom;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.codecs.Codec;

public class ConditionalReplaceExecutor
extends AbstractMasterTaskExecutor<ConditionalStoragePackage, Integer> {
    private Codec<Character> mySQLCodec = new MySQLCodecCustom(MySQLCodecCustom.Mode.STANDARD);

    public ConditionalReplaceExecutor(Connection connection, long time) {
        super(connection, time);
    }

    public static Executor<ConditionalStoragePackage, Integer> build(Connection connection, long timeout) {
        return new ConditionalReplaceExecutor(connection, timeout);
    }

    public Integer execute(ConditionalStoragePackage storagePackage) throws SQLException {
        try (Statement st = this.getConnection().createStatement();){
            Integer n = st.executeUpdate(this.buildSql(storagePackage));
            return n;
        }
    }

    private String buildSql(ConditionalStoragePackage storagePackage) throws SQLException {
        String mainTableName = storagePackage.getMainTableName();
        StringBuilder base = new StringBuilder();
        base.append("UPDATE ").append(mainTableName).append(" SET ");
        String conditionSql = storagePackage.getConditionSql();
        List<ConditionalStorageEntity> conditionalStorageList = storagePackage.getConditionalStorageList();
        boolean isFirst = true;
        for (ConditionalStorageEntity storageEntity : conditionalStorageList) {
            if (isFirst) {
                isFirst = false;
            } else {
                base.append(",");
            }
            String targetTable = storageEntity.getTargetTable();
            String concatColumn = targetTable.concat(".").concat("_sys_ver");
            String concatOperate = targetTable.concat(".").concat("_sys_operatetime");
            base.append(concatColumn).append(" = ").append(concatColumn).append(" +1 ");
            base.append(",").append(concatOperate).append(" = ").append(storageEntity.getSystemColumn().getOperateTime());
            for (MasterStorageEntity.TypedStorageValue value : storageEntity.getBusinessStaticFields()) {
                String columnName = value.getEntityField().name();
                if (SystemColumn.SYSTEM_WORDS.contains(columnName)) continue;
                StorageType storageType = StorageType.instance(value.getEntityField().type());
                if (null == storageType) {
                    throw new SQLException("storageType not found.");
                }
                base.append(",").append(targetTable.concat(".").concat(MasterStorageHelper.toStorageName((String)columnName, (boolean)true))).append("=");
                if (value.getValue() == null) {
                    base.append("null");
                    continue;
                }
                Object targetValue = storageType.isNeedSymbol() ? String.format("'%s'", ESAPI.encoder().encodeForSQL(this.mySQLCodec, value.getValue().toString())) : value.getValue();
                base.append(targetValue);
            }
        }
        if (!StringUtils.isEmpty((String)conditionSql)) {
            base.append(" where ").append(conditionSql);
        }
        if (storagePackage.getLimit() > 0) {
            base.append(" limit ").append(storagePackage.getLimit());
        }
        return base.toString();
    }
}

