/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor;

import com.xforceplus.ultraman.oqsengine.plus.common.executor.Executor;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.MasterEntity;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.MasterStorageEntity;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor.AbstractMasterTaskExecutor;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.Collectors;

public class DeleteExecutor
extends AbstractMasterTaskExecutor<List<MasterStorageEntity>, Boolean[]> {
    private static final String UPDATE_SQL = "UPDATE %s set _sys_dynamic = %s, _sys_operatetime = %s where id in (%s)";
    private static final String UPDATE_USER = "JSON_MERGE_PATCH(_sys_dynamic, '{\"#a\":{\"deluid\": %s, \"deluname\":\"%s\"}}')";
    private boolean recordUser;
    private String delUser;
    private Long delUserId;

    public DeleteExecutor(Connection connection, long timeout, boolean recordUser, String currentUser, Long currentUserId) {
        super(connection, timeout);
        this.recordUser = recordUser;
        this.delUser = currentUser;
        this.delUserId = currentUserId;
    }

    public static Executor<List<MasterStorageEntity>, Boolean[]> build(Connection connection, long timeout, boolean recordUser, String currentUser, Long currentUserId) {
        return new DeleteExecutor(connection, timeout, recordUser, currentUser, currentUserId);
    }

    public Boolean[] execute(List<MasterStorageEntity> masterStorageEntities) throws SQLException {
        boolean isBatch = masterStorageEntities.size() > 1;
        try (Statement st = this.getConnection().createStatement();){
            this.checkTimeout(st);
            if (isBatch) {
                Object update;
                if (this.recordUser) {
                    update = String.format(UPDATE_USER, Optional.ofNullable(this.delUserId).orElse(0L), Optional.ofNullable(this.delUser).orElse("\u7cfb\u7edf"));
                    Map<String, List<MasterStorageEntity>> mapping = masterStorageEntities.stream().collect(Collectors.groupingBy(MasterEntity::getTableName));
                    mapping.forEach((arg_0, arg_1) -> DeleteExecutor.lambda$execute$2((String)update, st, arg_0, arg_1));
                }
                for (MasterStorageEntity entity : masterStorageEntities) {
                    String sql = this.buildSql(entity);
                    st.addBatch(sql);
                }
                update = this.executedUpdate(st, true);
                return update;
            }
            MasterStorageEntity entity = masterStorageEntities.get(0);
            if (this.recordUser) {
                String update = String.format(UPDATE_USER, Optional.ofNullable(this.delUserId).orElse(0L), Optional.ofNullable(this.delUser).orElse("\u7cfb\u7edf"));
                String updateSQL = String.format(UPDATE_SQL, entity.getTableName(), update, entity.getSystemColumn().getOperateTime(), entity.getSystemColumn().getId());
                st.addBatch(updateSQL);
            }
            String sql = this.buildSql(entity);
            st.addBatch(sql);
            Boolean[] booleanArray = this.executedUpdate(st, true);
            return booleanArray;
        }
    }

    protected String buildSql(MasterStorageEntity masterStorageEntity) {
        StringBuilder base = new StringBuilder();
        base.append("DELETE FROM ").append(masterStorageEntity.getTableName());
        base.append(" ").append("where id").append("=").append(masterStorageEntity.getSystemColumn().getId());
        return base.toString();
    }

    private static /* synthetic */ void lambda$execute$2(String update, Statement st, String k, List v) {
        String ids = v.stream().map(x -> x.getSystemColumn().getId()).filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(","));
        OptionalLong max = v.stream().mapToLong(x -> x.getSystemColumn().getOperateTime()).max();
        String updateSQL = String.format(UPDATE_SQL, k, update, max.orElse(0L), ids);
        try {
            st.addBatch(updateSQL);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

