/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.master.mysql.query;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.legacy.impl.ColumnField;
import com.xforceplus.ultraman.metadata.service.DictService;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.utils.RexNodeHelper;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.Tuple3;
import io.vavr.control.Either;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlJsonValueFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Sarg;

public class CopyVisitor
extends RexVisitorImpl<RexNode> {
    private RelBuilder builder;
    private List<EntityClassGroup> involvedEntityClasses;
    private RelNode currentNode;
    private List<RexDynamicParam> dynamic = new ArrayList<RexDynamicParam>();
    private boolean useStrictEnum;
    private DictService dictService;
    private Map<String, List<String>> rewriteMapping;
    private static final String JSON_CONTAINS = "JSON_CONTAINS";
    private static final String JSON_OVERLAPS = "JSON_OVERLAPS";
    private static final SqlBinaryOperator BIT_AND = new SqlBinaryOperator("&", SqlKind.OTHER, 60, true, ReturnTypes.QUOTIENT_NULLABLE, InferTypes.FIRST_KNOWN, (SqlOperandTypeChecker)OperandTypes.NUMERIC_NUMERIC.or(OperandTypes.INTERVAL_NUMERIC).or(OperandTypes.NUMERIC_INTERVAL));

    public CopyVisitor(RelBuilder builder, List<EntityClassGroup> involvedEntityClasses, RelNode currentNode, boolean useStrictEnum, DictService dictService, Map<String, List<String>> rewriteMapping) {
        super(true);
        this.builder = builder;
        this.involvedEntityClasses = involvedEntityClasses;
        this.currentNode = currentNode;
        this.useStrictEnum = useStrictEnum;
        this.dictService = dictService;
        this.rewriteMapping = rewriteMapping;
    }

    public RexNode visitDynamicParam(RexDynamicParam param) {
        this.dynamic.add(param);
        return param;
    }

    public List<RexDynamicParam> getDynamic() {
        return this.dynamic;
    }

    public RexNode visitInputRef(RexInputRef inputRef) {
        return RexNodeHelper.convert(this.builder, inputRef.getIndex(), this.involvedEntityClasses, this.currentNode, true, this.currentNode instanceof BiRel ? 2 : 1);
    }

    public RexNode visitLiteral(RexLiteral literal) {
        RexNode copy = this.builder.getRexBuilder().copy((RexNode)literal);
        return copy;
    }

    public RexNode visitCall(RexCall call) {
        Optional<RexNode> first = call.getOperands().stream().filter(x -> x instanceof RexInputRef).findFirst();
        if (first.isPresent()) {
            Either<String, Tuple2<String, String>> isMultiValue = this.checkIfMultiValue((RexInputRef)first.get(), this.currentNode);
            if (isMultiValue.isRight()) {
                List<String> rewriteFields = this.rewriteMapping.get(((Tuple2)isMultiValue.get())._1);
                boolean ifRewrite = false;
                if (rewriteFields != null) {
                    ifRewrite = rewriteFields.stream().anyMatch(x -> x.equalsIgnoreCase((String)((Tuple2)isMultiValue.get())._2));
                }
                SqlOperator operator = call.getOperator();
                List<RexNode> operands = this.customVisitList(this.currentNode, this.builder, call.getOperands());
                Optional<RexNode> values = operands.stream().filter(x -> x instanceof RexLiteral).findFirst();
                boolean isIn = true;
                if (values.isPresent()) {
                    RexLiteral literal = (RexLiteral)values.get();
                    Object value2 = literal.getValue2();
                    RexLiteral newValues = null;
                    if (value2 instanceof Sarg) {
                        RangeSet rangeSet;
                        Sarg points = (Sarg)value2;
                        if (points.isComplementedPoints()) {
                            isIn = false;
                            rangeSet = TreeRangeSet.create((RangeSet)points.rangeSet).complement();
                        } else {
                            rangeSet = points.rangeSet;
                        }
                        String collect = rangeSet.asRanges().stream().map(x -> ((Range)x).upperEndpoint()).map(x -> ((NlsString)x).getValue()).map(x -> "\"".concat(x.toString()).concat("\"")).collect(Collectors.joining(","));
                        newValues = this.builder.literal((Object)"[".concat(collect).concat("]"));
                    } else if (value2 instanceof String) {
                        newValues = this.builder.literal((Object)"[\"".concat((String)value2).concat("\"]"));
                    } else if (value2 instanceof Number) {
                        newValues = this.builder.literal((Object)"[\"".concat(value2.toString()).concat("\"]"));
                    }
                    if (newValues != null) {
                        List<RexNode> rexNodes = Arrays.asList((RexNode)first.get().accept((RexVisitor)this), newValues);
                        if (operator == SqlStdOperatorTable.IN || operator == SqlStdOperatorTable.SEARCH || operator == SqlStdOperatorTable.EQUALS) {
                            if (isIn) {
                                return this.builder.getRexBuilder().makeCall(call.getType(), (SqlOperator)new SqlJsonValueFunction(ifRewrite ? JSON_OVERLAPS : JSON_CONTAINS), rexNodes);
                            }
                            return this.builder.getRexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{this.builder.getRexBuilder().makeCall(call.getType(), (SqlOperator)new SqlJsonValueFunction(ifRewrite ? JSON_OVERLAPS : JSON_CONTAINS), rexNodes)});
                        }
                        if (operator == SqlStdOperatorTable.NOT_IN || operator == SqlStdOperatorTable.NOT_EQUALS) {
                            return this.builder.getRexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{this.builder.getRexBuilder().makeCall(call.getType(), (SqlOperator)new SqlJsonValueFunction(ifRewrite ? JSON_OVERLAPS : JSON_CONTAINS), rexNodes)});
                        }
                    }
                }
            }
            Tuple2<Boolean, String> isEnumsIndexed = this.checkIfEnumsIndexed((RexInputRef)first.get(), this.currentNode);
            if (((Boolean)isEnumsIndexed._1).booleanValue() && this.dictService != null) {
                SqlOperator operator = call.getOperator();
                List<RexNode> operands = this.customVisitList(this.currentNode, this.builder, call.getOperands());
                Optional<RexNode> values = operands.stream().filter(x -> x instanceof RexLiteral).findFirst();
                boolean isIn = true;
                if (values.isPresent()) {
                    RexLiteral literal = (RexLiteral)values.get();
                    Object value2 = literal.getValue2();
                    RexLiteral newValues = null;
                    if (value2 instanceof Sarg) {
                        RangeSet rangeSet;
                        Sarg points = (Sarg)value2;
                        if (points.isComplementedPoints()) {
                            isIn = false;
                            rangeSet = TreeRangeSet.create((RangeSet)points.rangeSet).complement();
                        } else {
                            rangeSet = points.rangeSet;
                        }
                        List<String> collect = rangeSet.asRanges().stream().map(x -> ((Range)x).upperEndpoint()).map(x -> ((NlsString)x).getValue()).collect(Collectors.toList());
                        int enumBit = this.getEnumBit((String)isEnumsIndexed._2, collect);
                        newValues = this.builder.literal((Object)enumBit);
                    } else if (value2 instanceof String) {
                        int enumBit = this.getEnumBit((String)isEnumsIndexed._2, Arrays.asList((String)value2));
                        newValues = this.builder.literal((Object)enumBit);
                    } else if (value2 instanceof Number) {
                        int enumBit = this.getEnumBit((String)isEnumsIndexed._2, Arrays.asList(value2.toString()));
                        newValues = this.builder.literal((Object)enumBit);
                    }
                    if (newValues != null) {
                        RexNode rexNode;
                        List<RexNode> rexNodes = Arrays.asList((RexNode)first.get().accept((RexVisitor)this), newValues);
                        if (operator == SqlStdOperatorTable.IN || operator == SqlStdOperatorTable.SEARCH || operator == SqlStdOperatorTable.EQUALS) {
                            rexNode = this.builder.getRexBuilder().makeCall(call.getType(), (SqlOperator)BIT_AND, rexNodes);
                            if (isIn) {
                                return this.builder.getRexBuilder().makeCall(call.getType(), (SqlOperator)SqlStdOperatorTable.EQUALS, Arrays.asList(rexNode, newValues));
                            }
                            return this.builder.getRexBuilder().makeCall(call.getType(), (SqlOperator)SqlStdOperatorTable.NOT_EQUALS, Arrays.asList(rexNode, newValues));
                        }
                        if (operator == SqlStdOperatorTable.NOT_IN || operator == SqlStdOperatorTable.NOT_EQUALS) {
                            rexNode = this.builder.getRexBuilder().makeCall(call.getType(), (SqlOperator)BIT_AND, rexNodes);
                            return this.builder.getRexBuilder().makeCall(call.getType(), (SqlOperator)SqlStdOperatorTable.NOT_EQUALS, Arrays.asList(rexNode, newValues));
                        }
                    }
                }
            }
        }
        List<RexNode> operands = this.customVisitList(this.currentNode, this.builder, call.getOperands());
        return this.builder.getRexBuilder().makeCall(call.getType(), call.getOperator(), operands);
    }

    private Boolean isBoolean(RelNode node, RexInputRef inputRef) {
        return ((RelDataTypeField)node.getRowType().getFieldList().get(inputRef.getIndex())).getType().getSqlTypeName() == SqlTypeName.BOOLEAN;
    }

    private List<RexNode> customVisitList(RelNode node, RelBuilder relBuilder, List<RexNode> inputNodes) {
        ArrayList<RexNode> result = new ArrayList<RexNode>();
        for (RexNode source : inputNodes) {
            if (source instanceof RexInputRef && this.isBoolean(node, (RexInputRef)source).booleanValue()) {
                result.add(this.builder.getRexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{(RexNode)source.accept((RexVisitor)this), this.builder.literal((Object)true)}));
                continue;
            }
            result.add((RexNode)source.accept((RexVisitor)this));
        }
        return result;
    }

    private int getEnumBit(String enumId, List<String> values) {
        List dictItems = this.dictService.findDictItems(enumId, null, Collections.emptyMap());
        Optional<Integer> reduce = values.stream().map(x -> this.dictService.findEnumIndex(dictItems, x)).reduce((a, b) -> a | b);
        return reduce.orElse(0);
    }

    private Either<String, Tuple2<String, String>> checkIfMultiValue(RexInputRef rexInputRef, RelNode currentNode) {
        LinkedList<Boolean> footprint = new LinkedList<Boolean>();
        Tuple3<EntityClassGroup, RelDataTypeField, RelNode> source = RexNodeHelper.findSourceWithNode(rexInputRef.getIndex(), this.involvedEntityClasses, currentNode, false, footprint);
        EntityClassGroup entityClassGroup = (EntityClassGroup)source._1;
        RelDataTypeField relDataTypeField = (RelDataTypeField)source._2;
        String name = relDataTypeField.getName();
        Optional field = entityClassGroup.column(name);
        RelNode cNode = (RelNode)source._3;
        while (!field.isPresent() && !(cNode instanceof TableScan)) {
            if (cNode instanceof Project) {
                int target = ((Project)cNode).getMapping().getSourceOpt(relDataTypeField.getIndex());
                relDataTypeField = (RelDataTypeField)((Project)cNode).getInput().getRowType().getFieldList().get(target);
                name = relDataTypeField.getName();
                field = entityClassGroup.column(name);
            }
            cNode = cNode.getInput(0);
        }
        if (field.isPresent()) {
            boolean isMultiValue;
            boolean bl = isMultiValue = ((ColumnField)field.get()).type() == FieldType.STRINGS || ((ColumnField)field.get()).type() == FieldType.ENUMS && !this.useStrictEnum;
            if (isMultiValue) {
                return Either.right((Object)Tuple.of((Object)entityClassGroup.getEntityClass().code(), (Object)((ColumnField)field.get()).name()));
            }
            return Either.left((Object)"");
        }
        return Either.left((Object)"");
    }

    private Tuple2<Boolean, String> checkIfEnumsIndexed(RexInputRef rexInputRef, RelNode currentNode) {
        LinkedList<Boolean> footprint = new LinkedList<Boolean>();
        Tuple3<EntityClassGroup, RelDataTypeField, RelNode> source = RexNodeHelper.findSourceWithNode(rexInputRef.getIndex(), this.involvedEntityClasses, currentNode, false, footprint);
        EntityClassGroup entityClassGroup = (EntityClassGroup)source._1;
        RelDataTypeField relDataTypeField = (RelDataTypeField)source._2;
        String name = relDataTypeField.getName();
        Optional field = entityClassGroup.column(name);
        RelNode cNode = (RelNode)source._3;
        while (!field.isPresent() && !(cNode instanceof TableScan)) {
            if (cNode instanceof Project) {
                int target = ((Project)cNode).getMapping().getSourceOpt(relDataTypeField.getIndex());
                relDataTypeField = (RelDataTypeField)((Project)cNode).getInput().getRowType().getFieldList().get(target);
                name = relDataTypeField.getName();
                field = entityClassGroup.column(name);
            }
            cNode = cNode.getInput(0);
        }
        if (field.isPresent()) {
            if (((ColumnField)field.get()).type() == FieldType.ENUMS && this.useStrictEnum) {
                return Tuple.of((Object)true, (Object)((ColumnField)field.get()).dictId());
            }
            return Tuple.of((Object)false, (Object)"");
        }
        return Tuple.of((Object)false, (Object)"");
    }
}

