package com.xforceplus.ultraman.oqsengine.plus.master.mock;

import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.ultraman.metadata.domain.vo.dto.AppItem;
import com.xforceplus.ultraman.metadata.domain.vo.dto.BoApiVo;
import com.xforceplus.ultraman.metadata.domain.vo.dto.CurrentVersion;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.engine.dsl.ResourcePath;
import com.xforceplus.ultraman.metadata.engine.impl.EntityClassGroupImpl;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.legacy.impl.ColumnField;
import com.xforceplus.ultraman.metadata.repository.MetadataRepository;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * Created by justin.xu on 05/2023.
 * only use in class engine
 * @since 1.8
 */
public class MockEntityClassEngine implements EntityClassEngine {

    private List<IEntityClass> entityClasses;
    private List<IEntityClass> entityClassesWithProfile;

    public void initEntityClasses(List<IEntityClass> entityClasses) {
        this.entityClasses = new ArrayList<>();
        this.entityClassesWithProfile = new ArrayList<>();

        for (IEntityClass entityClass : entityClasses) {
            if (!entityClass.profile().isEmpty()) {
                this.entityClassesWithProfile.add(entityClass);
            } else {
                this.entityClasses.add(entityClass);
            }
        }
    }

    @Override
    public void onRefresh(Object payload) {

    }

    @Override
    public List<String> codes() {
        Set<String> codes = new HashSet<>();
        for (IEntityClass entityClass : entityClasses) {
            codes.add(entityClass.code());
        }

        for (IEntityClass entityClass : entityClassesWithProfile) {
            codes.add(entityClass.code());
        }
        return new ArrayList<>(codes);
    }

    @Override
    public MetadataEngine meta() {
        return null;
    }

    @Override
    public String appCode() {
        return "";
    }

    @Override
    public Optional<IEntityClass> load(String boId, String profile) {

        if (null != profile && !profile.isEmpty()) {
            Optional<IEntityClass> entityClassOptional = entityClassesWithProfile.stream().filter(e -> {
                return Long.parseLong(boId) == e.id() && profile.equals(e.profile());
            }).findFirst();

            if (entityClassOptional.isPresent()) {
                return entityClassOptional;
            }
        }

        return entityClasses.stream().filter(e -> {
            return Long.parseLong(boId) == e.id();
        }).findFirst();
    }

    @Override
    public Optional<IEntityClass> load(String boId, String profile, String version) {
        return load(boId, profile);
    }

    @Override
    public Optional<IEntityClass> loadByCode(String boCode, String profile) {

        if (null != profile && !profile.isEmpty()) {
            Optional<IEntityClass> entityClassOptional = entityClassesWithProfile.stream().filter(e -> {
                return boCode.equals(e.code()) && profile.equals(e.profile());
            }).findFirst();

            if (entityClassOptional.isPresent()) {
                return entityClassOptional;
            }
        }

        return entityClasses.stream().filter(e -> {
            return boCode.equals(e.code());
        }).findFirst();
    }

    @Override
    public Optional<IEntityClass> loadByCode(String boCode, String profile, String version) {
        return loadByCode(boCode, profile);
    }

    @Override
    public EntityClassGroup describe(IEntityClass entityClass, String profile) {
        return null;
    }

    @Override
    public List<ColumnField> columns(ResourcePath resourcePath, String profile) {
        return null;
    }

    @Override
    public MetadataRepository getRepository() {
        return null;
    }

    @Override
    public List<ColumnField> columns(IEntityClass root, ResourcePath resourcePath, String profile) {
        return null;
    }

    @Override
    public Optional<ColumnField> column(ResourcePath resourcePath, String profile) {
        return Optional.empty();
    }

    @Override
    public Optional<ColumnField> column(IEntityClass root, ResourcePath resourcePath, String profile) {
        return Optional.empty();
    }

    @Override
    public List<IEntityClass> findAllEntities(String profile) {

        Set<IEntityClass> entityClassesSets = new HashSet<>();

        for (IEntityClass entityClass : entityClasses) {
            if (entityClass.profile().equals(profile)) {
                entityClassesSets.add(entityClass);
            }
        }

        for (IEntityClass entityClass : entityClassesWithProfile) {
            if (entityClass.profile().equals(profile)) {
                entityClassesSets.add(entityClass);
            }
        }

        return new ArrayList<>(entityClassesSets);
    }

    @Override
    public Set<String> findCustomActionsById(long id) {
        return null;
    }

    @Override
    public List<BoApiVo> loadApiByCode(String code, String profile) {
        return null;
    }

    @Override
    public CurrentVersion currentVersion() {
        return null;
    }

    @Override
    public AppItem getCurrentApp() {
        return null;
    }
}
