package com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.oqsengine.plus.common.executor.Executor;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.MasterQueryResult;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.query.AbstractMasterQueryExecutor;
import com.xforceplus.ultraman.oqsengine.plus.storage.pojo.dto.select.SelectConfig;
import org.apache.calcite.tools.FrameworkConfig;

import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.SQLException;

/**
 * Created by justin.xu on 03/2023.
 *
 * @since 1.8
 */
public class ConditionQueryExecutor extends AbstractMasterQueryExecutor<SelectConfig, MasterQueryResult> {

    private EntityClassGroup entityClass;
    private FrameworkConfig frameworkConfig;


    public static Executor<SelectConfig, MasterQueryResult> build(ObjectMapper mapper,
            Connection connection, long timeout, EntityClassGroup entityClass, FrameworkConfig frameworkConfig) {
        return new ConditionQueryExecutor(mapper, connection, timeout, entityClass, frameworkConfig);
    }

    public ConditionQueryExecutor(
            ObjectMapper mapper, Connection connection, long timeout, EntityClassGroup entityClass
            , FrameworkConfig frameworkConfig) {
        super(mapper, connection, timeout);
        this.entityClass = entityClass;
        this.frameworkConfig = frameworkConfig;

    }

    @Override
    public MasterQueryResult execute(SelectConfig selectConfig) throws SQLException {
        return super.executeQuery(selectConfig, entityClass, frameworkConfig);
    }
}
