package com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor;

import com.xforceplus.ultraman.oqsengine.plus.common.executor.Executor;
import com.xforceplus.ultraman.sdk.infra.codec.MySQLCodecCustom;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.MasterStorageEntity;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.StorageType;
import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.table.SystemColumn;
import com.xforceplus.ultraman.sdk.core.utils.MasterStorageHelper;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.codecs.Codec;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

/**
 * Created by justin.xu on 03/2023.
 *
 * @since 1.8
 */
public class CreateExecutor extends AbstractMasterTaskExecutor<List<MasterStorageEntity>, boolean[]> {

    /**
     * TODO
     * current static inited
     */
    private Codec<Character> mySQLCodec = new MySQLCodecCustom(MySQLCodecCustom.Mode.STANDARD);

    public CreateExecutor(Connection connection, long timeout) {
        super(connection, timeout);
    }

    public static Executor<List<MasterStorageEntity>, boolean[]> build(Connection connection, long timeout) {
        return new CreateExecutor(connection, timeout);
    }

    @Override
    public boolean[] execute(List<MasterStorageEntity> collection) throws SQLException {
        try (Statement st = getConnection().createStatement()) {

            checkTimeout(st);

            boolean isBatch = collection.size() > 1;
            if (isBatch) {
                for (int i = 0; i < collection.size(); i++) {
                    //  建SQL.
                    String sql = buildSql(collection.get(i));
                    st.addBatch(sql);
                }

                return executedUpdate(st, true);
            } else {
                String sql = buildSql(collection.get(0));
                return new boolean[]{st.executeUpdate(sql) > 0};
            }
        }
    }

    protected String buildSql(MasterStorageEntity masterStorageEntity) throws SQLException {
        StringBuilder base = new StringBuilder();
        base.append("INSERT INTO ").append(masterStorageEntity.getTableName()).append(" (");

        //  systemField.
        base.append(String.join(",", SystemColumn.ID, SystemColumn.SYS_ENTITY_CLASS, SystemColumn.SYS_VERSION, SystemColumn.SYS_OPERATE_TIME, SystemColumn.SYS_DELETED, SystemColumn.SYS_PROFILE));

        //  static field
        if (!masterStorageEntity.getBusinessStaticFields().isEmpty()) {
            for (MasterStorageEntity.TypedStorageValue value : masterStorageEntity.getBusinessStaticFields()) {
                String columnName = value.getEntityField().name().toLowerCase();
                if (!SystemColumn.SYSTEM_WORDS.contains(columnName)) {
                    base.append(",").append(MasterStorageHelper.toStorageName(columnName, true));
                }
            }
        }

        //  dynamic field
        if (!masterStorageEntity.getBusinessDynamicFields().isEmpty()) {
            base.append(",").append(SystemColumn.DYNAMIC_FIELD);
        }

        base.append(") VALUES (");

        base.append(masterStorageEntity.getSystemColumn().getId()).append(",").append(masterStorageEntity.getSystemColumn().getEntityClass()).append(",").append(masterStorageEntity.getSystemColumn().getVersion()).append(",").append(masterStorageEntity.getSystemColumn().getOperateTime()).append(",").append(masterStorageEntity.getSystemColumn().getDeleted()).append(",").append("'").append(masterStorageEntity.getSystemColumn().getProfile()).append("'");

        //  static field
        if (!masterStorageEntity.getBusinessStaticFields().isEmpty()) {
            for (MasterStorageEntity.TypedStorageValue value : masterStorageEntity.getBusinessStaticFields()) {
                if (!SystemColumn.SYSTEM_WORDS.contains(value.getEntityField().name())) {
                    StorageType storageType = StorageType.instance(value.getEntityField().type());
                    if (null == storageType) {
                        throw new SQLException("storageType not found.");
                    }

                    Object targetValue = storageType.isNeedSymbol() ? String.format("'%s'", ESAPI.encoder().encodeForSQL(mySQLCodec, value.getValue().toString())) : value.getValue();
                    base.append(",").append(targetValue);
                }
            }
        }

        //  dynamic field
        if (!masterStorageEntity.getBusinessDynamicFields().isEmpty()) {
            base.append(",").append("'").append(masterStorageEntity.getBusinessDynamicFields()).append("'");
        }

        base.append(")");

        return base.toString();
    }
}
