package com.xforceplus.ultraman.oqsengine.plus.master.mysql.query;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Data;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;

/**
 * Created by justin.xu on 03/2023.
 *
 * @since 1.8
 */
@Data
public class CalciteQueryPackage {
    private DataSource dataSource;
    private Connection connection;
    private CalciteConnection calciteConnection;
    private SchemaPlus rootSchema;

    public static CalciteQueryPackage newInstance(DataSource dataSource, Schema schema, String schemaName) throws SQLException {
        CalciteQueryPackage calciteQueryPackage = new CalciteQueryPackage();
//        Properties info = new Properties();
//        info.setProperty("caseSensitive", "false");
//        info.setProperty("conformance", "MYSQL_5");
//        info.setProperty("fun", "mysql");
//        Connection connection = DriverManager.getConnection("jdbc:calcite:", info);

//        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);

//        SchemaPlus rootSchema = calciteConnection.getRootSchema();
//        rootSchema.add("oqs",schema);

//        calciteQueryPackage.setRootSchema(rootSchema);
        calciteQueryPackage.setDataSource(dataSource);
//        calciteQueryPackage.setCalciteConnection(calciteConnection);
//        calciteQueryPackage.setConnection(connection);
        return calciteQueryPackage;
    }

    public void destroyInstance() throws SQLException {
        if (null != calciteConnection && !calciteConnection.isClosed()) {
            calciteConnection.close();
        }

        //TODO check
        if (null != connection && !connection.isClosed()) {
            connection.close();
        }
    }

}
