package com.xforceplus.ultraman.oqsengine.plus.master.mysql.query;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.utils.RexNodeHelper;
import io.vavr.Tuple2;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.*;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlJsonValueFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Sarg;

import java.util.*;
import java.util.stream.Collectors;

/**
 * TODO add custom filter
 */
public class CopyVisitor extends RexVisitorImpl<RexNode> {

    private RelBuilder builder;
    private List<EntityClassGroup> involvedEntityClasses;
    private RelNode currentNode;

    private List<RexDynamicParam> dynamic = new ArrayList<>();

    public CopyVisitor(
            RelBuilder builder
            , List<EntityClassGroup> involvedEntityClasses
            , RelNode currentNode
    ) {

        super(true);
        this.builder = builder;
        this.involvedEntityClasses = involvedEntityClasses;

        /**
         * current node is in old type
         * if is a join will get left and right
         */
        this.currentNode = currentNode;
    }

    @Override
    public RexNode visitDynamicParam(RexDynamicParam param) {
        dynamic.add(param);
        return param;
    }

    public List<RexDynamicParam> getDynamic() {
        return dynamic;
    }

    /**
     * @param inputRef
     * @return
     */
    @Override
    public RexNode visitInputRef(RexInputRef inputRef) {
        //turn origin to current type
//        RelDataTypeField relDataTypeField = null;
//        EntityClassGroup ptr = null;
//        int input = 1;
//
//        RelNode nodePtr = currentNode;
//
//        /**
//         * case the filter - join has no project .will cause the filter fields is not right
//         * for example
//         *    join A, B , C, D
//         *    filter will see A, B, C,D
//         *    but if use builder.field("C") may fail
//         */
////        if(nodePtr instanceof Filter) {
////
////        }
//        int inputCount = 1;
//        boolean isRight = false;
//        /**
//         * TODO multi field on ??
//         * if join the case is on condition
//         * we need do two field on
//         */
//        if (nodePtr instanceof Join) {
//            inputCount = 2;
//            int leftSize = nodePtr.getInput(0).getRowType().getFieldList().size();
//            int index = inputRef.getIndex();
//            if (index >= leftSize) {
//                //find in 1
//                relDataTypeField = nodePtr.getInput(1).getRowType().getFieldList().get(index - leftSize);
//                ptr = involvedEntityClasses.get(1);
//                input = 1;
//                isRight = true;
//            } else {
//                //find in 0
//                relDataTypeField = nodePtr.getInput(0).getRowType().getFieldList().get(index);
//                ptr = involvedEntityClasses.get(0);
//                input = 2;
//            }
//        } else if (nodePtr instanceof Filter || nodePtr instanceof Project) {
//            if (((SingleRel) nodePtr).getInput() instanceof Join) {
//                //if no project join real field should do in join
//                nodePtr = ((Filter) nodePtr).getInput();
//                //find real field for filter
//                int leftSize = nodePtr.getInput(0).getRowType().getFieldList().size();
//                int index = inputRef.getIndex();
//                if (index >= leftSize) {
//                    //find in 1
//                    relDataTypeField = nodePtr.getInput(1).getRowType().getFieldList().get(index - leftSize);
//                    ptr = involvedEntityClasses.get(1);
//                    isRight = true;
//                } else {
//                    //find in 0
//                    relDataTypeField = nodePtr.getInput(0).getRowType().getFieldList().get(index);
//                    ptr = involvedEntityClasses.get(1);
//                }
//            }
//        }
//
//        /**
//         * other case
//         */
//        if (relDataTypeField == null) {
//            ptr = involvedEntityClasses.get(0);
//            relDataTypeField = nodePtr.getRowType().getFieldList().get(inputRef.getIndex());
//        }
//
//        /**
//         * first find the real target field
//         */
//        if (relDataTypeField != null) {
//            String name = relDataTypeField.getName();
//            return nameConvert(builder, name, ptr, input, inputCount, isRight);
//        }
//
//        throw new RuntimeException("No Related Column");

        return RexNodeHelper.convert(builder, inputRef.getIndex(), involvedEntityClasses, currentNode, true, currentNode instanceof BiRel ? 2 : 1);
    }

    @Override
    public RexNode visitLiteral(RexLiteral literal) {
        RexNode copy = builder.getRexBuilder().copy(literal);
        return copy;
    }

    @Override
    public RexNode visitCall(RexCall call) {

        Optional<RexNode> first = call.getOperands().stream().filter(x -> x instanceof RexInputRef).findFirst();
        if (first.isPresent()) {
            boolean isMultiValue = checkIfMultiValue((RexInputRef) first.get(), currentNode);
            if (isMultiValue) {
                SqlOperator operator = call.getOperator();
                List<RexNode> operands = visitList(call.getOperands());
                Optional<RexNode> values = operands.stream().filter(x -> x instanceof RexLiteral).findFirst();
                boolean isIn = true;
                if(values.isPresent()) {
                    RexLiteral literal = (RexLiteral) values.get();
                    Object value2 = literal.getValue2();
                    RexLiteral newValues = null;
                    if (value2 instanceof Sarg) {
                        Sarg points = (Sarg) value2;
                        //((NlsString)((Range)((Sarg) ((RexLiteral) operands.get(1)).value)
                        // .rangeSet.asRanges().iterator().next()).upperEndpoint()).getValue()
                        RangeSet rangeSet;
                        if(points.isComplementedPoints()) {
                            isIn = false;
                            rangeSet = TreeRangeSet.create(points.rangeSet).complement();
                        } else {
                            rangeSet = points.rangeSet;
                        }
                        String collect = (String) rangeSet.asRanges().stream()
                                .map(x -> ((Range) x).upperEndpoint())
                                .map(x -> ((NlsString) x).getValue())
                                .map(x -> "\"".concat(x.toString()).concat("\""))
                                .collect(Collectors.joining(","));
                        newValues = builder.literal("[".concat(collect).concat("]"));
                    } else if (value2 instanceof String) {
                        newValues = builder.literal("[\"".concat((String) value2).concat("\"]"));
                    } else if (value2 instanceof Number) {
                        newValues = builder.literal("[\"".concat(value2.toString()).concat("\"]"));
                    }

                    if(newValues != null) {
                        List<RexNode> rexNodes = Arrays.asList(first.get(), newValues);
                        if (operator == SqlStdOperatorTable.IN || operator == SqlStdOperatorTable.SEARCH || operator == SqlStdOperatorTable.EQUALS) {
                            if(isIn) {
                                return builder.getRexBuilder().makeCall(call.getType(), new SqlJsonValueFunction("JSON_CONTAINS"), rexNodes);
                            } else {
                                return builder.getRexBuilder().makeCall(SqlStdOperatorTable.NOT, builder.getRexBuilder().makeCall(call.getType(), new SqlJsonValueFunction("JSON_CONTAINS"), rexNodes));
                            }
                        } else if (operator == SqlStdOperatorTable.NOT_IN || operator == SqlStdOperatorTable.NOT_EQUALS) {
                            return builder.getRexBuilder().makeCall(SqlStdOperatorTable.NOT, builder.getRexBuilder().makeCall(call.getType(), new SqlJsonValueFunction("JSON_CONTAINS"), rexNodes));
                        }
                    }
                }
            }
        }

        List<RexNode> operands = visitList(call.getOperands());
        return builder.getRexBuilder().makeCall(call.getType(), call.getOperator(), operands);
    }

    private boolean checkIfMultiValue(RexInputRef rexInputRef, RelNode currentNode) {
        Queue<Boolean> footprint = new LinkedList<>();
        Tuple2<EntityClassGroup, RelDataTypeField> source = RexNodeHelper.findSource(rexInputRef.getIndex(), involvedEntityClasses, currentNode, false, footprint);
        EntityClassGroup entityClassGroup = source._1;
        RelDataTypeField relDataTypeField = source._2;
        String name = relDataTypeField.getName();
        Optional<IEntityField> field = entityClassGroup.field(name);
        if(field.isPresent()) {
            return field.get().type() == FieldType.STRINGS;
        } else {
            return false;
        }
    }

//    private String nameConvert(String originName, IEntityClass entityClass) {
//        originName = originName.toLowerCase();
//        Optional<IEntityField> fieldOp = entityClass.field(originName);
//        if (fieldOp.isPresent()) {
//            IEntityField field = fieldOp.get();
//
//            //  表示查询了一个dynamic字段 && !field.isIndex()
//            if (field.isDynamic()) {
//                return SystemColumn.DYNAMIC_FIELD + ".$" + originName;
//            }
//        }
//        return originName;
//    }
}
