package com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor;


import com.xforceplus.ultraman.oqsengine.plus.common.executor.Executor;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.MasterEntity;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.MasterStorageEntity;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * Created by justin.xu on 03/2023.
 *
 * @since 1.8
 */
public class DeleteExecutor extends AbstractMasterTaskExecutor<List<MasterStorageEntity>, boolean[]> {

    private final static String UPDATE_SQL = "UPDATE %s set _sys_dynamic = %s where id in (%s)";
    //update oqs_new20_any0523001 set _sys_dynamic = JSON_MERGE_PATCH(_sys_dynamic,'{"#a": {"grouped": 1}}') where id = 1669166938506395648
    private final static String UPDATE_USER = "JSON_MERGE_PATCH(_sys_dynamic, '{\"#a\":{\"deluid\": %s, \"deluname\":\"%s\"}}')";
    private boolean recordUser;
    private String delUser;
    private Long delUserId;

    public DeleteExecutor(Connection connection, long timeout, boolean recordUser, String currentUser, Long currentUserId) {
        super(connection, timeout);
        this.recordUser = recordUser;
        this.delUser = currentUser;
        this.delUserId = currentUserId;
    }

    public static Executor<List<MasterStorageEntity>, boolean[]> build(
            Connection connection, long timeout, boolean recordUser, String currentUser, Long currentUserId) {
        return new DeleteExecutor(connection, timeout, recordUser, currentUser, currentUserId);
    }

    @Override
    public boolean[] execute(List<MasterStorageEntity> masterStorageEntities) throws SQLException {

        boolean isBatch = masterStorageEntities.size() > 1;

        try (Statement st = getConnection().createStatement()) {
            checkTimeout(st);
            if (isBatch) {
                if (recordUser) {

                    String update = String.format(UPDATE_USER, Optional.ofNullable(delUserId).orElse(0L)
                            , Optional.ofNullable(delUser).orElse("系统"));

                    Map<String, List<MasterStorageEntity>> mapping = masterStorageEntities.stream()
                            .collect(Collectors.groupingBy(MasterEntity::getTableName));

                    mapping.forEach((k, v) -> {
                        String ids = v.stream().map(x -> x.getSystemColumn().getId()).filter(Objects::nonNull).map(Object::toString)
                                .collect(Collectors.joining(","));
                        String updateSQL = String.format(UPDATE_SQL, k, update, ids);
                        try {
                            st.addBatch(updateSQL);
                        } catch (SQLException e) {
                            e.printStackTrace();
                        }
                    });
                }

                for (MasterStorageEntity entity : masterStorageEntities) {
                    String sql = buildSql(entity);
                    st.addBatch(sql);
                }

                return executedUpdate(st, true);
            } else {
                MasterStorageEntity entity = masterStorageEntities.get(0);

                if (recordUser) {
                    String update = String.format(UPDATE_USER, Optional.ofNullable(delUserId).orElse(0L)
                            , Optional.ofNullable(delUser).orElse("系统"));

                    String updateSQL = String.format(UPDATE_SQL, entity.getTableName(), update, entity.getSystemColumn().getId());
                    st.addBatch(updateSQL);
                }

                String sql = buildSql(entity);
                st.addBatch(sql);

                return executedUpdate(st, true);
            }
        }
    }

    protected String buildSql(MasterStorageEntity masterStorageEntity) {

        StringBuilder base = new StringBuilder();

        base.append("DELETE FROM ").append(masterStorageEntity.getTableName());
        base.append(" ").append("where id").append("=").append(masterStorageEntity.getSystemColumn().getId());

        return base.toString();
    }
}
