/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.master.iterator;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.xforceplus.ultraman.metadata.cdc.OqsEngineEntity;
import com.xforceplus.ultraman.metadata.entity.EntityClassRef;
import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.plus.common.StringUtils;
import com.xforceplus.ultraman.oqsengine.plus.common.iterator.DataIterator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;

public class EntityUpdateTimeRangeIterator
implements DataIterator<OqsEngineEntity> {
    private static final int DEFAULT_BUFFER_SIZE = 1000;
    private int buffSize;
    private long startTime;
    private long endTime;
    private String tableName;
    private IEntityClass entityClass;
    private DataSource dataSource;
    private List<OqsEngineEntity> buffer;
    private Connection connection;
    private PreparedStatement ps;
    private ResultSet rs;

    public void init() throws Exception {
        this.buffer = new ArrayList<OqsEngineEntity>(this.buffSize);
        this.connection = this.dataSource.getConnection();
        String sql = this.buildSQL(this.tableName, this.entityClass.selfFields().stream().filter(f -> !f.isDynamic()).collect(Collectors.toList()));
        this.ps = this.connection.prepareStatement(sql, 1003, 1007);
        this.ps.setFetchSize(Integer.MIN_VALUE);
        int pos = 1;
        this.ps.setLong(pos++, this.entityClass.id());
        this.ps.setLong(pos++, this.startTime);
        this.ps.setLong(pos++, this.endTime);
        this.rs = this.ps.executeQuery();
    }

    public void destroy() throws Exception {
        if (this.rs != null) {
            this.rs.close();
        }
        if (this.ps != null) {
            this.ps.close();
        }
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public boolean hasNext() {
        if (this.buffer.isEmpty()) {
            this.load();
        }
        return !this.buffer.isEmpty();
    }

    public OqsEngineEntity next() {
        if (this.hasNext()) {
            return this.buffer.remove(0);
        }
        return null;
    }

    private void load() throws RuntimeException {
        try {
            while (this.rs.next()) {
                OqsEngineEntity engineEntity = this.buildFormResultSet(this.rs);
                if (null == engineEntity) continue;
                this.buffer.add(engineEntity);
                if (this.buffer.size() != this.buffSize) continue;
                break;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private OqsEngineEntity buildFormResultSet(ResultSet rs) throws Exception {
        EntityClassRef entityClassRef = new EntityClassRef(rs.getLong("_sys_entityclass"), this.entityClass.appCode(), rs.getString("_sys_profile"));
        if (!this.entityClass.ref().equals((Object)entityClassRef)) {
            return null;
        }
        OqsEngineEntity entity = new OqsEngineEntity();
        entity.setId(rs.getLong("id"));
        entity.setUpdateTime(rs.getLong("_sys_operatetime"));
        entity.setDeleted(false);
        entity.setVersion(rs.getInt("_sys_ver"));
        entity.setEntityClassRef(new EntityClassRef(this.entityClass.id(), this.entityClass.appCode(), rs.getString("_sys_profile")));
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("id", entity.getId());
        String dynamic = rs.getString("_sys_dynamic");
        if (!dynamic.isEmpty()) {
            try {
                Map attrDynamics = OqsEngineEntity.addDynamicAttrWithNullValue((IEntityClass)this.entityClass, (String)dynamic);
                attrs.putAll(attrDynamics);
            }
            catch (JsonProcessingException e) {
                throw new SQLException(e);
            }
        }
        for (IEntityField entityField : this.entityClass.selfFields().stream().filter(f -> !f.isDynamic()).collect(Collectors.toList())) {
            String name = entityField.name().toLowerCase();
            Object value = rs.getObject(name);
            if (value == null || !entityField.type().equals((Object)FieldType.BOOLEAN)) {
                attrs.put(name, value);
                continue;
            }
            attrs.put(name, (Integer)value > 0);
        }
        entity.setAttributes(attrs);
        return entity;
    }

    private String buildSQL(String table, Collection<IEntityField> entityFields) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append(String.join((CharSequence)",", "id", "_sys_entityclass", "_sys_operatetime", "_sys_ver", "_sys_deleted", "_sys_profile"));
        entityFields.stream().filter(e -> !e.isDynamic()).forEach(e -> sql.append(",").append(e.name().toLowerCase()));
        sql.append("_sys_dynamic");
        sql.append(" FROM ").append(table).append(" WHERE ").append("_sys_operatetime").append(" >= ").append("?").append(" AND ").append("_sys_operatetime").append(" <= ").append("?").append(") AND ").append("id").append(" > ").append("?");
        return sql.toString();
    }

    public static final class Builder {
        private int buffSize = 1000;
        private long startTime = -1L;
        private long endTime = -1L;
        private String tableName;
        private IEntityClass entityClass;
        private DataSource dataSource;

        private Builder() {
        }

        public static Builder anEntityIterator() {
            return new Builder();
        }

        public Builder witherBuffSize(int size) {
            this.buffSize = size;
            return this;
        }

        public Builder witherTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder withStartTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder withEndTime(long endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder withEntityClass(IEntityClass entityClass) {
            this.entityClass = entityClass;
            return this;
        }

        public Builder withDataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public EntityUpdateTimeRangeIterator build() {
            if (this.entityClass == null) {
                throw new RuntimeException("Invalid meta information.");
            }
            if (this.startTime < 0L) {
                throw new RuntimeException("Invalid start time.");
            }
            if (this.endTime < 0L) {
                throw new RuntimeException("Invalid end time.");
            }
            if (this.startTime > this.endTime) {
                throw new RuntimeException(String.format("The start time cannot be later than the end time.[%d, %d]", this.startTime, this.endTime));
            }
            if (this.dataSource == null) {
                throw new RuntimeException("Invalid data source.");
            }
            if (StringUtils.isEmpty((String)this.tableName)) {
                throw new RuntimeException("Invalid table name.");
            }
            EntityUpdateTimeRangeIterator entityIterator = new EntityUpdateTimeRangeIterator();
            entityIterator.buffSize = this.buffSize;
            entityIterator.startTime = this.startTime;
            entityIterator.endTime = this.endTime;
            entityIterator.dataSource = this.dataSource;
            entityIterator.entityClass = this.entityClass;
            entityIterator.tableName = this.tableName;
            try {
                entityIterator.init();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return entityIterator;
        }
    }
}

