/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.master.mock;

import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.ultraman.metadata.domain.vo.dto.AppItem;
import com.xforceplus.ultraman.metadata.domain.vo.dto.BoApiVo;
import com.xforceplus.ultraman.metadata.domain.vo.dto.CurrentVersion;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.engine.dsl.ResourcePath;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.legacy.impl.ColumnField;
import com.xforceplus.ultraman.metadata.repository.MetadataRepository;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class MockEntityClassEngine
implements EntityClassEngine {
    private List<IEntityClass> entityClasses;
    private List<IEntityClass> entityClassesWithProfile;

    public void initEntityClasses(List<IEntityClass> entityClasses) {
        this.entityClasses = new ArrayList<IEntityClass>();
        this.entityClassesWithProfile = new ArrayList<IEntityClass>();
        for (IEntityClass entityClass : entityClasses) {
            if (!entityClass.profile().isEmpty()) {
                this.entityClassesWithProfile.add(entityClass);
                continue;
            }
            this.entityClasses.add(entityClass);
        }
    }

    public void onRefresh(Object payload) {
    }

    public List<String> codes() {
        HashSet<String> codes = new HashSet<String>();
        for (IEntityClass entityClass : this.entityClasses) {
            codes.add(entityClass.code());
        }
        for (IEntityClass entityClass : this.entityClassesWithProfile) {
            codes.add(entityClass.code());
        }
        return new ArrayList<String>(codes);
    }

    public MetadataEngine meta() {
        return null;
    }

    public String appCode() {
        return "";
    }

    public Optional<IEntityClass> load(String boId, String profile) {
        Optional<IEntityClass> entityClassOptional;
        if (null != profile && !profile.isEmpty() && (entityClassOptional = this.entityClassesWithProfile.stream().filter(e -> Long.parseLong(boId) == e.id() && profile.equals(e.profile())).findFirst()).isPresent()) {
            return entityClassOptional;
        }
        return this.entityClasses.stream().filter(e -> Long.parseLong(boId) == e.id()).findFirst();
    }

    public Optional<IEntityClass> load(String boId, String profile, String version) {
        return this.load(boId, profile);
    }

    public Optional<IEntityClass> loadByCode(String boCode, String profile) {
        Optional<IEntityClass> entityClassOptional;
        if (null != profile && !profile.isEmpty() && (entityClassOptional = this.entityClassesWithProfile.stream().filter(e -> boCode.equals(e.code()) && profile.equals(e.profile())).findFirst()).isPresent()) {
            return entityClassOptional;
        }
        return this.entityClasses.stream().filter(e -> boCode.equals(e.code())).findFirst();
    }

    public Optional<IEntityClass> loadByCode(String boCode, String profile, String version) {
        return this.loadByCode(boCode, profile);
    }

    public EntityClassGroup describe(IEntityClass entityClass, String profile) {
        return null;
    }

    public List<ColumnField> columns(ResourcePath resourcePath, String profile) {
        return null;
    }

    public MetadataRepository getRepository() {
        return null;
    }

    public List<ColumnField> columns(IEntityClass root, ResourcePath resourcePath, String profile) {
        return null;
    }

    public Optional<ColumnField> column(ResourcePath resourcePath, String profile) {
        return Optional.empty();
    }

    public Optional<ColumnField> column(IEntityClass root, ResourcePath resourcePath, String profile) {
        return Optional.empty();
    }

    public List<IEntityClass> findAllEntities(String profile) {
        HashSet<IEntityClass> entityClassesSets = new HashSet<IEntityClass>();
        for (IEntityClass entityClass : this.entityClasses) {
            if (!entityClass.profile().equals(profile)) continue;
            entityClassesSets.add(entityClass);
        }
        for (IEntityClass entityClass : this.entityClassesWithProfile) {
            if (!entityClass.profile().equals(profile)) continue;
            entityClassesSets.add(entityClass);
        }
        return new ArrayList<IEntityClass>(entityClassesSets);
    }

    public Set<String> findCustomActionsById(long id) {
        return null;
    }

    public List<BoApiVo> loadApiByCode(String code, String profile) {
        return null;
    }

    public CurrentVersion currentVersion() {
        return null;
    }

    public AppItem getCurrentApp() {
        return null;
    }
}

