/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor;

import com.xforceplus.ultraman.oqsengine.plus.common.executor.Executor;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.MasterStorageEntity;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor.AbstractMasterTaskExecutor;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public class DeleteExecutor
extends AbstractMasterTaskExecutor<List<MasterStorageEntity>, boolean[]> {
    public DeleteExecutor(Connection connection, long timeout) {
        super(connection, timeout);
    }

    public static Executor<List<MasterStorageEntity>, boolean[]> build(Connection connection, long timeout) {
        return new DeleteExecutor(connection, timeout);
    }

    public boolean[] execute(List<MasterStorageEntity> masterStorageEntities) throws SQLException {
        boolean isBatch = masterStorageEntities.size() > 1;
        try (Statement st = this.getConnection().createStatement();){
            this.checkTimeout(st);
            if (isBatch) {
                for (MasterStorageEntity entity : masterStorageEntities) {
                    String sql = this.buildSql(entity);
                    st.addBatch(sql);
                }
                Object object = this.executedUpdate(st, true);
                return object;
            }
            MasterStorageEntity entity = masterStorageEntities.get(0);
            String sql = this.buildSql(entity);
            boolean[] blArray = new boolean[]{st.executeUpdate(sql) > 0};
            return blArray;
        }
    }

    protected String buildSql(MasterStorageEntity masterStorageEntity) {
        StringBuilder base = new StringBuilder();
        base.append("DELETE FROM ").append(masterStorageEntity.getTableName());
        base.append(" ").append("where id").append("=").append(masterStorageEntity.getSystemColumn().getId());
        return base.toString();
    }
}

