/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.master.mysql.query;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.helper.ConvertHelper;
import com.xforceplus.ultraman.oqsengine.plus.common.StringUtils;
import com.xforceplus.ultraman.oqsengine.plus.master.calcite.visitor.RemoveSortWithLimitVisitor;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.MasterQueryResult;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.MysqlSqlDialectEx;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor.AbstractMasterTaskExecutor;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.query.CopyCustomShuttle;
import com.xforceplus.ultraman.oqsengine.plus.storage.pojo.dto.select.SelectConfig;
import com.xforceplus.ultraman.sdk.core.utils.MasterStorageHelper;
import io.vavr.Tuple2;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.calcite.DataContext;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.rel2sql.RelToSqlConverter;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.dialect.MysqlSqlDialect;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Sarg;
import org.apache.calcite.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMasterQueryExecutor<T, R>
extends AbstractMasterTaskExecutor<T, R> {
    private static final Logger log = LoggerFactory.getLogger(AbstractMasterQueryExecutor.class);
    private String schemaName = "oqsengine";
    private static ZoneId zoneId = ZoneId.of("Asia/Shanghai");
    private static DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private List<Map.Entry<String, Tuple2<StructKind, Class>>> targetFields;
    private ObjectMapper mapper;
    private TypeReference<List<String>> typeReference = new TypeReference<List<String>>(){};

    public AbstractMasterQueryExecutor(ObjectMapper mapper, Connection connection, long timeoutMs) {
        super(connection, timeoutMs);
        this.mapper = mapper;
    }

    private void genProjectFromType(Pair<RexNode, String> projectPair, RelDataType dataType, IEntityClass entityClass, List<Pair<String, String>> fieldMapping) {
        RexNode inputRef = (RexNode)projectPair.getKey();
        if (inputRef instanceof RexInputRef) {
            String originField = ((RelDataTypeField)dataType.getFieldList().get(((RexInputRef)inputRef).getIndex())).getName();
            String field = AbstractMasterQueryExecutor.nameConvert(originField, entityClass);
            fieldMapping.add((Pair<String, String>)new Pair((Object)field, projectPair.getValue()));
        }
    }

    protected MasterQueryResult executeQuery(SelectConfig selectConfig, EntityClassGroup entityClassGroup, FrameworkConfig config) throws SQLException {
        Connection resource = this.getConnection();
        ArrayList queryEntities = new ArrayList();
        try {
            RelBuilder relBuilder = this.makeRelBuilder(config);
            RelNode rawTree = selectConfig.getRawTree();
            String plan = RelOptUtil.toString((RelNode)rawTree);
            log.debug("old plan {}", (Object)plan);
            CopyCustomShuttle copyCustomShuttle = new CopyCustomShuttle(relBuilder, entityClassGroup, new HashMap<String, String>());
            rawTree.accept((RelShuttle)copyCustomShuttle);
            RelNode finalNode = relBuilder.build();
            HepProgram program = HepProgram.builder().build();
            HepPlanner planner = new HepPlanner(program);
            planner.setRoot(finalNode);
            RelNode optimizedNode = planner.findBestExp();
            DataContext dataContext = selectConfig.getDataContext();
            List<RexDynamicParam> params = copyCustomShuttle.getParams();
            MasterQueryResult result = new MasterQueryResult();
            if (!this.onlyCount(selectConfig)) {
                String newPlan = RelOptUtil.toString((RelNode)optimizedNode);
                log.debug("new plan {}", (Object)newPlan);
                SqlNode sqlNode = new RelToSqlConverter(MysqlSqlDialect.DEFAULT).visitRoot(optimizedNode).asStatement();
                String s = Util.toLinux((String)sqlNode.toSqlString(MysqlSqlDialectEx.DEFAULT).getSql()).replaceAll("\n", " ");
                log.debug("final sql {}", (Object)s);
                List targetFields = selectConfig.getFields();
                PreparedStatement preparedStatement = resource.prepareStatement(s);
                params.forEach(param -> {
                    int index = param.getIndex();
                    SqlTypeName sqlTypeName = param.getType().getSqlTypeName();
                    try {
                        preparedStatement.setObject(index + 1, dataContext.get(param.getName()), sqlTypeName.getJdbcOrdinal());
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                });
                long queryStart = System.currentTimeMillis();
                try (ResultSet rs = preparedStatement.executeQuery();){
                    System.out.println("Main Query Consume:" + (System.currentTimeMillis() - queryStart));
                    for (Map.Entry targetField : targetFields) {
                        String key = (String)targetField.getKey();
                        if (key.startsWith("EXPR$")) {
                            String index = key.substring("EXPR$".length());
                            key = rs.getMetaData().getColumnLabel(Integer.parseInt(index) + 1);
                        }
                        result.appendField(key, (Class)((Tuple2)targetField.getValue())._2);
                    }
                    while (rs.next()) {
                        result.newRecord();
                        result.getFields().forEach(x -> {
                            Object rs1 = MasterStorageHelper.getRs((ResultSet)rs, (String)((String)x._1), (Class)((Class)x._2));
                            result.append((String)x._1, rs1);
                        });
                    }
                }
            }
            if (this.hasCount(selectConfig)) {
                long start = System.currentTimeMillis();
                RelNode countNode = this.buildCount(relBuilder, optimizedNode);
                SqlNode countSqlNode = new RelToSqlConverter(MysqlSqlDialect.DEFAULT).visitRoot(countNode).asStatement();
                String countSql = Util.toLinux((String)countSqlNode.toSqlString(MysqlSqlDialectEx.DEFAULT).getSql()).replaceAll("\n", " ");
                System.out.println("Cosume To Count:" + (System.currentTimeMillis() - start));
                PreparedStatement statement = resource.prepareStatement(countSql);
                params.forEach(param -> {
                    int index = param.getIndex();
                    SqlTypeName sqlTypeName = param.getType().getSqlTypeName();
                    try {
                        statement.setObject(index + 1, dataContext.get(param.getName()), sqlTypeName.getJdbcOrdinal());
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                });
                ResultSet resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    long count = resultSet.getLong("c");
                    selectConfig.getContext().put("show_count", count);
                    result.getExtra().put("show_count", count);
                }
            }
            MasterQueryResult masterQueryResult = result;
            return masterQueryResult;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw throwable;
        }
    }

    private boolean isPlainArrayJson(Object rs1) {
        String substring;
        return rs1 instanceof String && !StringUtils.isEmpty((String)((String)rs1)) && ((String)rs1).startsWith("[") && ((String)rs1).endsWith("]") && !((String)rs1).contains("{") && !((String)rs1).contains("}") && !(substring = ((String)rs1).substring(1, ((String)rs1).length() - 1)).contains("[") && !substring.contains("]");
    }

    private boolean extractPlainArrayJson(SelectConfig selectConfig) {
        return selectConfig.getHints().stream().anyMatch(x -> x.hintName.equalsIgnoreCase("extract_array_json"));
    }

    private RelNode buildCount(RelBuilder builder, RelNode optimizedNode) {
        RemoveSortWithLimitVisitor removeSortWithLimitVisitor = RemoveSortWithLimitVisitor.DEFAULT_INS;
        builder.clear();
        builder.push(optimizedNode.accept((RelShuttle)removeSortWithLimitVisitor));
        builder.push(builder.aggregate(builder.groupKey(), new RelBuilder.AggCall[]{builder.countStar("c")}).build());
        return builder.build();
    }

    private Class convertToJavaType() {
        return String.class;
    }

    private boolean hasCount(SelectConfig selectConfig) {
        return selectConfig.getHints().stream().anyMatch(x -> x.hintName.equalsIgnoreCase("show_count"));
    }

    private boolean onlyCount(SelectConfig selectConfig) {
        return selectConfig.getHints().stream().anyMatch(x -> x.hintName.equalsIgnoreCase("only_count"));
    }

    private RexNode[] toSorts(RelBuilder relBuilder, IEntityClass entityClass, List<Map.Entry<String, RelFieldCollation.Direction>> sorts) {
        int sortSize = sorts.size();
        RexNode[] rexNodes = new RexNode[sortSize];
        for (int i = 0; i < sortSize; ++i) {
            Map.Entry<String, RelFieldCollation.Direction> sort = sorts.get(i);
            RexInputRef rexInputRef = relBuilder.field(AbstractMasterQueryExecutor.nameConvert(sort.getKey(), entityClass));
            rexNodes[i] = sort.getValue().isDescending() ? relBuilder.desc((RexNode)rexInputRef) : rexInputRef;
        }
        return rexNodes;
    }

    private RelBuilder makeRelBuilder(FrameworkConfig config) {
        return RelBuilder.create((FrameworkConfig)config);
    }

    private RelBuilder.AggCall aggregateConvert(AggregateCall aggCall, RelBuilder relBuilder, RelDataType older, RelDataType newer, IEntityClass entityClass, String alise) {
        if (null == newer.getFieldNames() || newer.getFieldNames().isEmpty()) {
            throw new RuntimeException("agg convert failed, table relDataType is invalid.");
        }
        ArrayList newArgList = new ArrayList();
        ArrayList nameList = new ArrayList();
        Consumer<Integer> integerConsumer = arg -> {
            String field = ((RelDataTypeField)older.getFieldList().get((int)arg)).getName();
            String tableColumnName = field;
            if (!tableColumnName.equals("*")) {
                tableColumnName = AbstractMasterQueryExecutor.nameConvert(field, entityClass);
            }
            nameList.add(tableColumnName);
            for (int i = 0; i < newer.getFieldNames().size(); ++i) {
                if (!tableColumnName.equals(newer.getFieldNames().get(i))) continue;
                newArgList.add(i);
                break;
            }
        };
        aggCall.getArgList().forEach(integerConsumer);
        String name = aggCall.getName();
        if (!StringUtils.isEmpty((String)alise)) {
            name = alise;
        }
        RelBuilder.AggCall aggCall1 = relBuilder.aggregateCall(aggCall.getAggregation(), (Iterable)nameList.stream().map(x -> relBuilder.field(x)).collect(Collectors.toList()));
        return aggCall1;
    }

    private static String nameConvert(String originName, IEntityClass entityClass) {
        IEntityField field;
        Optional fieldOp = entityClass.field(originName = originName.toLowerCase());
        if (fieldOp.isPresent() && (field = (IEntityField)fieldOp.get()).isDynamic()) {
            return "_sys_dynamic.$" + originName;
        }
        return originName;
    }

    private static class RefNameValue {
        private String field;
        private List<RexLiteral> literals;
        private RelBuilder relBuilder;

        public RefNameValue(RelBuilder relBuilder) {
            this.relBuilder = relBuilder;
            this.literals = new ArrayList<RexLiteral>();
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public List<RexLiteral> getLiterals() {
            return this.literals;
        }

        public RexNode toRexField() {
            if (null != this.field) {
                return this.relBuilder.field(this.field);
            }
            throw new RuntimeException("build rexField error, field is not init");
        }

        public RexNode toFirstRexLiteral() {
            if (null == this.literals || this.literals.isEmpty()) {
                throw new RuntimeException("build rexField error, literals is not init");
            }
            return (RexNode)this.literals.get(0);
        }

        public RexNode[] toRexLiterals() {
            if (null == this.literals || this.literals.isEmpty()) {
                throw new RuntimeException("build rexField error, literals is not init");
            }
            RexNode[] rexNodes = new RexNode[this.literals.size()];
            for (int i = 0; i < this.literals.size(); ++i) {
                rexNodes[i] = (RexNode)this.literals.get(i);
            }
            return rexNodes;
        }
    }

    public static class TableRexVisitor
    extends RexVisitorImpl<RexNode> {
        private RelBuilder builder;
        private IEntityClass entityClass;
        private RelDataType dataType;
        private RefNameValue refNameValue;

        public TableRexVisitor(RelBuilder builder, RelDataType type, IEntityClass entityClass) {
            super(true);
            this.builder = builder;
            this.entityClass = entityClass;
            this.dataType = type;
        }

        public RexNode visitCall(RexCall call) {
            this.refNameValue = new RefNameValue(this.builder);
            switch (call.getKind()) {
                case AND: {
                    this.builder = this.builder.filter(new RexNode[]{this.builder.and((RexNode[])call.getOperands().stream().map(operand -> (RexNode)operand.accept((RexVisitor)this)).toArray(RexNode[]::new))});
                    return call;
                }
                case OR: {
                    this.builder = this.builder.filter(new RexNode[]{this.builder.or((RexNode[])call.getOperands().stream().map(operand -> (RexNode)operand.accept((RexVisitor)this)).toArray(RexNode[]::new))});
                    return call;
                }
                case EQUALS: {
                    this.travel(call);
                    this.builder = this.builder.filter(new RexNode[]{this.builder.equals(this.refNameValue.toRexField(), this.refNameValue.toFirstRexLiteral())});
                    return call;
                }
                case NOT_EQUALS: {
                    this.travel(call);
                    this.builder = this.builder.filter(new RexNode[]{this.builder.notEquals(this.refNameValue.toRexField(), this.refNameValue.toFirstRexLiteral())});
                    return call;
                }
                case GREATER_THAN: {
                    this.travel(call);
                    this.builder = this.builder.filter(new RexNode[]{this.builder.greaterThan(this.refNameValue.toRexField(), this.refNameValue.toFirstRexLiteral())});
                    return call;
                }
                case GREATER_THAN_OR_EQUAL: {
                    this.travel(call);
                    this.builder = this.builder.filter(new RexNode[]{this.builder.greaterThanOrEqual(this.refNameValue.toRexField(), this.refNameValue.toFirstRexLiteral())});
                    return call;
                }
                case LESS_THAN: {
                    this.travel(call);
                    this.builder = this.builder.filter(new RexNode[]{this.builder.lessThan(this.refNameValue.toRexField(), this.refNameValue.toFirstRexLiteral())});
                    return call;
                }
                case LESS_THAN_OR_EQUAL: {
                    this.travel(call);
                    this.builder = this.builder.filter(new RexNode[]{this.builder.lessThanOrEqual(this.refNameValue.toRexField(), this.refNameValue.toFirstRexLiteral())});
                    return call;
                }
                case IN: {
                    this.travel(call);
                    this.builder = this.builder.filter(new RexNode[]{this.builder.in(this.refNameValue.toRexField(), this.refNameValue.toRexLiterals())});
                    return call;
                }
                case SEARCH: 
                case BETWEEN: {
                    this.travel(call);
                    RexNode[] rexNodes = this.refNameValue.toRexLiterals();
                    if (rexNodes.length != 2) {
                        throw new RuntimeException("between must have two range value");
                    }
                    this.builder = this.builder.filter(new RexNode[]{this.builder.between(this.refNameValue.toRexField(), rexNodes[0], rexNodes[1])});
                    return call;
                }
                case LIKE: {
                    this.travel(call);
                    this.builder = this.builder.filter(new RexNode[]{this.builder.getRexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LIKE, new RexNode[]{this.refNameValue.toRexField(), this.refNameValue.toFirstRexLiteral()})});
                    return call;
                }
                case CAST: {
                    this.travel(call);
                    return call;
                }
            }
            throw new RuntimeException("Unsupported RexCall type: " + call.getKind());
        }

        public RexNode visitInputRef(RexInputRef inputRef) {
            String originField = ((RelDataTypeField)this.dataType.getFieldList().get(inputRef.getIndex())).getName();
            String field = AbstractMasterQueryExecutor.nameConvert(originField, this.entityClass);
            this.refNameValue.setField(field);
            return inputRef;
        }

        public RexNode visitLiteral(RexLiteral literal) {
            this.rexLiteralParser(this.refNameValue, literal);
            return literal;
        }

        private void travel(RexCall call) {
            call.operands.forEach(c -> c.accept((RexVisitor)this));
        }

        private Object rexLiteralParser(RefNameValue refNameValue, RexLiteral literal) {
            if (null == refNameValue.getField()) {
                throw new RuntimeException("filter field could not be null");
            }
            if (null == literal.getValue2()) {
                return literal;
            }
            RelDataTypeField realType = this.builder.peek().getRowType().getField(refNameValue.getField(), false, false);
            SqlTypeName typeName = literal.getTypeName();
            switch (typeName) {
                case BOOLEAN: 
                case INTEGER: 
                case TINYINT: 
                case SMALLINT: 
                case DECIMAL: 
                case DOUBLE: 
                case FLOAT: 
                case REAL: 
                case BIGINT: 
                case DATE: 
                case TIME: 
                case TIME_WITH_LOCAL_TIME_ZONE: 
                case TIMESTAMP: 
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
                case INTERVAL_YEAR: 
                case INTERVAL_YEAR_MONTH: 
                case INTERVAL_MONTH: 
                case INTERVAL_DAY: 
                case INTERVAL_DAY_HOUR: 
                case INTERVAL_DAY_MINUTE: 
                case INTERVAL_DAY_SECOND: 
                case INTERVAL_HOUR: 
                case INTERVAL_HOUR_MINUTE: 
                case INTERVAL_HOUR_SECOND: 
                case INTERVAL_MINUTE: 
                case INTERVAL_MINUTE_SECOND: 
                case INTERVAL_SECOND: 
                case VARCHAR: 
                case CHAR: 
                case VARBINARY: 
                case BINARY: 
                case SYMBOL: 
                case ROW: 
                case GEOMETRY: 
                case ANY: 
                case NULL: {
                    Object singleValue = literal.getValue2();
                    String convert = ConvertHelper.convert((Object)singleValue);
                    this.addTargetValue(realType, convert, singleValue);
                    break;
                }
                case SARG: {
                    String converted;
                    Object rangeValue = literal.getValue2();
                    Sarg sarg = (Sarg)rangeValue;
                    RangeSet rangeSet = sarg.rangeSet;
                    if (sarg.isPoints()) {
                        Set ranges = sarg.rangeSet.asRanges();
                        ranges.stream().forEach(range -> {
                            String converted = ConvertHelper.convert((Object)range.lowerEndpoint());
                            this.addTargetValue(realType, converted, range.lowerEndpoint());
                        });
                        break;
                    }
                    Optional first = sarg.rangeSet.asRanges().stream().findFirst();
                    Range range2 = (Range)first.get();
                    if (range2.hasLowerBound()) {
                        converted = ConvertHelper.convert((Object)range2.lowerEndpoint());
                        this.addTargetValue(realType, converted, range2.lowerEndpoint());
                    }
                    if (!range2.hasUpperBound()) break;
                    converted = ConvertHelper.convert((Object)range2.upperEndpoint());
                    this.addTargetValue(realType, converted, range2.upperEndpoint());
                    break;
                }
                default: {
                    throw Util.unexpected((Enum)typeName);
                }
            }
            return literal;
        }

        private void addTargetValue(RelDataTypeField realType, String originValue, Object rawObj) {
            if (null != realType) {
                switch (realType.getType().getSqlTypeName()) {
                    case BIGINT: {
                        this.refNameValue.getLiterals().add(this.builder.literal((Object)Long.parseLong(originValue)));
                        break;
                    }
                    case DECIMAL: {
                        this.refNameValue.getLiterals().add(this.builder.literal((Object)new BigDecimal(originValue)));
                        break;
                    }
                    case VARCHAR: {
                        this.refNameValue.getLiterals().add(this.builder.literal((Object)originValue));
                        break;
                    }
                    case BOOLEAN: {
                        this.refNameValue.getLiterals().add(this.builder.literal((Object)Boolean.parseBoolean(originValue)));
                        break;
                    }
                    case TIMESTAMP: {
                        if (rawObj instanceof Long) {
                            LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli((Long)rawObj), zoneId);
                            this.refNameValue.getLiterals().add(this.builder.literal((Object)dateTime.format(formatter)));
                            break;
                        }
                        if (rawObj instanceof BigDecimal) {
                            LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(((BigDecimal)rawObj).longValue()), zoneId);
                            this.refNameValue.getLiterals().add(this.builder.literal((Object)dateTime.format(formatter)));
                            break;
                        }
                        this.refNameValue.getLiterals().add(this.builder.literal((Object)originValue));
                        break;
                    }
                    default: {
                        this.refNameValue.getLiterals().add(this.builder.literal(rawObj));
                    }
                }
            }
        }
    }
}

