package com.xforceplus.ultraman.oqsengine.plus.master.dto;


import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.values.IValue;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by justin.xu on 03/2023.
 *
 * @since 1.8
 */
public class MasterStorageEntity extends MasterEntity {

    //  固定列名
    private List<TypedStorageValue> businessStaticFields;

    private List<IValue> businessDynamicFields;
    
    private Map<String, Object> attachment = new HashMap<>();

    //  修改时的空列
//    private String businessDynamicFieldsRemove;
    
    private boolean useOptimisticLock = false;
    
    private boolean onlyFather = false;
    
    private boolean isProfiled = false;
    
    public List<TypedStorageValue> getBusinessStaticFields() {
        return businessStaticFields;
    }
    
    public List<IValue> getBusinessDynamicFields() {
        return businessDynamicFields;
    }

    public Map<String, Object> getAttachment() {
        return attachment;
    }

    public void setAttachment(Map<String, Object> attachment) {
        this.attachment = attachment;
    }

    public EntityClassGroup rawEntityClass;

    public void setBusinessStaticFields(
        List<TypedStorageValue> businessStaticFields) {
        this.businessStaticFields = businessStaticFields;
    }

    public void setBusinessDynamicFields(List<IValue> businessDynamicFields) {
        this.businessDynamicFields = businessDynamicFields;
    }

    public boolean isProfiled() {
        return isProfiled;
    }

    public EntityClassGroup getRawEntityClass() {
        return rawEntityClass;
    }

    public void setRawEntityClass(EntityClassGroup rawEntityClass) {
        this.rawEntityClass = rawEntityClass;
    }

    public void setProfiled(boolean profiled) {
        isProfiled = profiled;
    }

    public boolean isUseOptimisticLock() {
        return useOptimisticLock;
    }

    public void setUseOptimisticLock(boolean useOptimisticLock) {
        this.useOptimisticLock = useOptimisticLock;
    }

    public boolean isOnlyFather() {
        return onlyFather;
    }

    public void setOnlyFather(boolean onlyFather) {
        this.onlyFather = onlyFather;
    }

    public static class TypedStorageValue {
        private IEntityField entityField;
        private Object value;
        
        private Object rawValue;
        
        private boolean isIndex = false;
        
        private boolean keepRaw = false;
        
        private boolean keepRawOnDuplicate = false;

        public TypedStorageValue(IEntityField entityField, Object value) {
            this.entityField = entityField;
            this.value = value;
        }

        public TypedStorageValue(IEntityField entityField, Object value, boolean isIndex) {
            this.entityField = entityField;
            this.value = value;
            this.isIndex = isIndex;
        }

        public boolean isKeepRaw() {
            return keepRaw;
        }

        public void setKeepRaw(boolean keepRaw) {
            this.keepRaw = keepRaw;
        }

        public boolean isKeepRawOnDuplicate() {
            return keepRawOnDuplicate;
        }

        public void setKeepRawOnDuplicate(boolean keepRawOnDuplicate) {
            this.keepRawOnDuplicate = keepRawOnDuplicate;
        }

        public Object getValue() {
            return value;
        }

        public boolean isIndex() {
            return isIndex;
        }

        public IEntityField getEntityField() {
            return entityField;
        }

        public void setRawValue(Object rawValue) {
            this.rawValue = rawValue;
        }

        public Object getRawValue() {
            return rawValue;
        }
    }
}
