package com.xforceplus.ultraman.oqsengine.plus.master.iterator;

import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.plus.common.iterator.DataIterator;
import com.xforceplus.ultraman.oqsengine.plus.master.iterator.exception.TaskRetryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.*;

/**
 * Created by justin.xu on 07/2023.
 *
 * @since 1.8
 */
public abstract class EntityUpdateTimeRangeIterator<T> implements DataIterator<T> {
    private Logger logger = LoggerFactory.getLogger(EntityUpdateTimeRangeIterator.class);

    protected static final int DEFAULT_BUFFER_SIZE = 1000;
    protected int buffSize;
    protected long startTime;
    protected long endTime;
    protected long startId;
    protected String tableName;
    protected IEntityClass entityClass;
    protected DataSource dataSource;
    protected List<T> buffer;
    protected Connection connection;
    protected PreparedStatement ps;
    protected ResultSet rs;

    protected String filterProfile;

    @Override
    public void init() throws Exception {
        buffer = new ArrayList<>(buffSize);

        connection = dataSource.getConnection();
        ps = preparedSQL(tableName, filterProfile);

        rs = ps.executeQuery();
    }

    @Override
    public void destroy() throws Exception {
        if (rs != null) {
            rs.close();
        }
        if (ps != null) {
            ps.close();
        }
        if (connection != null) {
            connection.close();
        }
    }

    @Override
    public boolean hasNext() {
        if (buffer.isEmpty()) {
            load();
        }

        return !buffer.isEmpty();
    }

    @Override
    public T next() {
        if (hasNext()) {
            return buffer.remove(0);
        } else {
            return null;
        }
    }

    private void load() throws RuntimeException {
        try {
            while (rs.next()) {
                T result = buildFromResultSet(rs);
                if (null != result) {
                    this.buffer.add(result);
                    if (this.buffer.size() == buffSize) {
                        break;
                    }
                }
            }
        } catch (Exception ex) {
            if (ex instanceof SQLException) {
                throw new TaskRetryException(ex.getMessage(), ex);
            }
            throw new RuntimeException(ex);
        }
    }

    protected abstract T buildFromResultSet(ResultSet rs) throws Exception;


    protected abstract PreparedStatement preparedSQL(String table, String profile) throws SQLException;

}
